/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.storage.file;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.model.ListingStatus;
import org.texboobcat.globalMarketplace.model.ListingType;
import org.texboobcat.globalMarketplace.repo.ListingRepository;
import org.texboobcat.globalMarketplace.storage.JsonStore;

public class FileListingRepository
implements ListingRepository {
    private final Path file;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<UUID, Listing> listings;

    public FileListingRepository(Path file) throws IOException {
        this.file = file;
        ListingsSnapshot snap = JsonStore.read(file, ListingsSnapshot.class, new ListingsSnapshot());
        this.listings = snap.map != null ? snap.map : new HashMap<UUID, Listing>();
    }

    private void persist() throws SQLException {
        this.lock.writeLock().lock();
        try {
            ListingsSnapshot snap = new ListingsSnapshot();
            snap.map = this.listings;
            try {
                JsonStore.writeAtomic(this.file, snap);
            }
            catch (IOException e) {
                throw new SQLException("Failed to write listings file", e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void createListing(Listing listing) throws SQLException {
        this.lock.writeLock().lock();
        try {
            this.listings.put(listing.getUuid(), listing);
            this.persist();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Optional<Listing> getByUuid(UUID uuid) throws SQLException {
        this.lock.readLock().lock();
        try {
            Optional<Listing> optional = Optional.ofNullable(this.listings.get(uuid));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateStatus(UUID uuid, ListingStatus status) throws SQLException {
        this.lock.writeLock().lock();
        try {
            Listing l = this.listings.get(uuid);
            if (l == null) {
                boolean bl = false;
                return bl;
            }
            l.setStatus(status);
            this.persist();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryUpdateStatusIf(UUID uuid, ListingStatus expectedCurrent, ListingStatus newStatus) throws SQLException {
        this.lock.writeLock().lock();
        try {
            Listing l = this.listings.get(uuid);
            if (l == null) {
                boolean bl = false;
                return bl;
            }
            if (l.getStatus() != expectedCurrent) {
                boolean bl = false;
                return bl;
            }
            l.setStatus(newStatus);
            this.persist();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateBid(UUID uuid, BigDecimal bid, UUID bidder) throws SQLException {
        this.lock.writeLock().lock();
        try {
            Listing l = this.listings.get(uuid);
            if (l == null) {
                boolean bl = false;
                return bl;
            }
            l.setCurrentBid(bid);
            l.setBidderUuid(bidder);
            this.persist();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Listing> findActive(int limit, int offset) throws SQLException {
        this.lock.readLock().lock();
        try {
            List active = this.listings.values().stream().filter(l -> l.getStatus() == ListingStatus.ACTIVE && (l.getExpiresAt() == null || l.getExpiresAt().isAfter(Instant.now()))).sorted(Comparator.comparing(Listing::getExpiresAt, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
            int from = Math.min(offset, active.size());
            int to = Math.min(from + limit, active.size());
            ArrayList<Listing> arrayList = new ArrayList<Listing>(active.subList(from, to));
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Listing> findExpiredActiveAuctions(Instant now, int limit) throws SQLException {
        this.lock.readLock().lock();
        try {
            List<Listing> list = this.listings.values().stream().filter(l -> l.getStatus() == ListingStatus.ACTIVE && l.getExpiresAt() != null && !l.getExpiresAt().isAfter(now) && l.getType() == ListingType.AUCTION).sorted(Comparator.comparing(Listing::getExpiresAt, Comparator.nullsLast(Comparator.naturalOrder()))).limit(limit).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Listing> findExpiredActiveAny(Instant now, int limit) throws SQLException {
        this.lock.readLock().lock();
        try {
            List<Listing> list = this.listings.values().stream().filter(l -> l.getStatus() == ListingStatus.ACTIVE && l.getExpiresAt() != null && !l.getExpiresAt().isAfter(now)).sorted(Comparator.comparing(Listing::getExpiresAt, Comparator.nullsLast(Comparator.naturalOrder()))).limit(limit).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteByUuid(UUID uuid) throws SQLException {
        this.lock.writeLock().lock();
        try {
            Listing removed = this.listings.remove(uuid);
            if (removed != null) {
                this.persist();
            }
            boolean bl = removed != null;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public List<Listing> findRecentSoldListings(int limit) throws SQLException {
        this.lock.readLock().lock();
        try {
            List<Listing> list = this.listings.values().stream().filter(l -> l.getStatus() == ListingStatus.SOLD).sorted(Comparator.comparing(Listing::getId).reversed()).limit(limit).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static class ListingsSnapshot {
        Map<UUID, Listing> map = new HashMap<UUID, Listing>();

        private ListingsSnapshot() {
        }
    }
}

