/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.texboobcat.globalMarketplace.commands.GMarketCommand;
import org.texboobcat.globalMarketplace.commands.GMarketHelpCommand;
import org.texboobcat.globalMarketplace.commands.GMarketTabCompleter;
import org.texboobcat.globalMarketplace.dao.BalanceDao;
import org.texboobcat.globalMarketplace.dao.DeliveryDao;
import org.texboobcat.globalMarketplace.dao.ListingDao;
import org.texboobcat.globalMarketplace.dao.LockDao;
import org.texboobcat.globalMarketplace.dao.LockProvider;
import org.texboobcat.globalMarketplace.dao.TransactionDao;
import org.texboobcat.globalMarketplace.economy.EconomyService;
import org.texboobcat.globalMarketplace.integrations.DiscordWebhookService;
import org.texboobcat.globalMarketplace.listeners.CreationListener;
import org.texboobcat.globalMarketplace.listeners.JoinListener;
import org.texboobcat.globalMarketplace.listeners.SearchListener;
import org.texboobcat.globalMarketplace.repo.BalanceRepository;
import org.texboobcat.globalMarketplace.repo.DeliveryQueue;
import org.texboobcat.globalMarketplace.repo.ListingRepository;
import org.texboobcat.globalMarketplace.repo.TransactionLog;
import org.texboobcat.globalMarketplace.repo.adapters.JdbcBalanceRepository;
import org.texboobcat.globalMarketplace.repo.adapters.JdbcDeliveryQueue;
import org.texboobcat.globalMarketplace.repo.adapters.JdbcListingRepository;
import org.texboobcat.globalMarketplace.repo.adapters.JdbcTransactionLog;
import org.texboobcat.globalMarketplace.service.MarketplaceService;
import org.texboobcat.globalMarketplace.storage.DatabaseManager;
import org.texboobcat.globalMarketplace.storage.MigrationRunner;
import org.texboobcat.globalMarketplace.storage.file.FileBalanceRepository;
import org.texboobcat.globalMarketplace.storage.file.FileDeliveryQueue;
import org.texboobcat.globalMarketplace.storage.file.FileListingRepository;
import org.texboobcat.globalMarketplace.storage.file.FileTransactionLog;
import org.texboobcat.globalMarketplace.storage.file.InMemoryLockProvider;
import org.texboobcat.globalMarketplace.sync.RedisLockProvider;
import org.texboobcat.globalMarketplace.sync.RedisSync;
import org.texboobcat.globalMarketplace.ui.GuiListener;

public class GlobalMarketplacePlugin
extends JavaPlugin {
    private static GlobalMarketplacePlugin instance;
    private Economy economy;
    private DatabaseManager database;
    private RedisSync redisSync;
    private EconomyService economyService;
    private MarketplaceService marketplaceService;
    private DiscordWebhookService discordService;

    public static GlobalMarketplacePlugin getInstance() {
        return instance;
    }

    public void onEnable() {
        LockProvider lockProvider;
        DeliveryQueue deliveryQueue;
        TransactionLog txLog;
        BalanceRepository balanceRepo;
        ListingRepository listingRepo;
        String storageType;
        boolean useMySql;
        instance = this;
        this.saveDefaultConfig();
        this.saveResource("messages.yml", false);
        this.saveResource("gui/default.yml", false);
        this.setupVault();
        if (this.economy != null) {
            this.economyService = new EconomyService(this.economy);
        }
        if (useMySql = (storageType = this.getConfig().getString("database.type", "file").toLowerCase()).equals("mysql")) {
            try {
                this.initDatabase();
                MigrationRunner.runMigrations(this.database);
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to initialize database: " + e.getMessage());
                e.printStackTrace();
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        } else if (storageType.equals("file")) {
            this.getLogger().info("Using file-based storage backend (JSON). Initializing repositories...");
        } else {
            this.getLogger().severe("Unknown storage type: " + storageType + ". Valid options: mysql, file");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (useMySql) {
            ListingDao listingDao = new ListingDao(this.database);
            BalanceDao balanceDao = new BalanceDao(this.database);
            TransactionDao transactionDao = new TransactionDao(this.database);
            DeliveryDao deliveryDao = new DeliveryDao(this.database);
            LockDao lockDao = new LockDao(this.database);
            listingRepo = new JdbcListingRepository(listingDao);
            balanceRepo = new JdbcBalanceRepository(balanceDao);
            txLog = new JdbcTransactionLog(transactionDao);
            deliveryQueue = new JdbcDeliveryQueue(deliveryDao);
            lockProvider = lockDao;
        } else {
            try {
                if (!this.getDataFolder().exists()) {
                    this.getDataFolder().mkdirs();
                }
                Path data = this.getDataFolder().toPath();
                listingRepo = new FileListingRepository(data.resolve("listings.json"));
                balanceRepo = new FileBalanceRepository(data.resolve("balances.json"));
                deliveryQueue = new FileDeliveryQueue(data.resolve("deliveries.json"));
                txLog = new FileTransactionLog(data.resolve("transactions.json"));
                lockProvider = new InMemoryLockProvider();
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to initialize file-based storage: " + e.getMessage());
                e.printStackTrace();
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        }
        if (this.getConfig().getBoolean("redis.locks.enabled", false)) {
            String rHost = this.getConfig().getString("redis.host", "localhost");
            int rPort = this.getConfig().getInt("redis.port", 6379);
            String rPass = this.getConfig().getString("redis.password", "");
            String keyPrefix = this.getConfig().getString("redis.locks.keyPrefix", "gmarket:lock:");
            try {
                lockProvider = new RedisLockProvider(rHost, rPort, rPass, keyPrefix);
                this.getLogger().info("Using Redis-based distributed locks at " + rHost + ":" + rPort);
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to initialize Redis lock provider: " + e.getMessage());
            }
        }
        ArrayList<DiscordWebhookService.Webhook> hooks = new ArrayList<DiscordWebhookService.Webhook>();
        try {
            if (this.getConfig().isList("discord.webhooks")) {
                for (Object o : this.getConfig().getList("discord.webhooks")) {
                    if (!(o instanceof Map)) continue;
                    Map m = (Map)o;
                    String name = GlobalMarketplacePlugin.asString(m.get("name"));
                    String url = GlobalMarketplacePlugin.asString(m.get("url"));
                    String username = GlobalMarketplacePlugin.asString(m.getOrDefault("username", "GlobalMarket"));
                    String avatar = GlobalMarketplacePlugin.asString(m.getOrDefault("avatar_url", ""));
                    HashSet<DiscordWebhookService.EventType> events = new HashSet<DiscordWebhookService.EventType>();
                    Object ev = m.get("events");
                    if (ev instanceof List) {
                        for (Object e : (List)ev) {
                            if (e == null) continue;
                            try {
                                events.add(DiscordWebhookService.EventType.valueOf(e.toString().toUpperCase(Locale.ROOT)));
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                    }
                    if (url == null || url.isEmpty()) continue;
                    hooks.add(new DiscordWebhookService.Webhook(name != null ? name : "webhook", url, events, username, avatar));
                }
            }
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to parse discord.webhooks: " + e.getMessage());
        }
        if (!hooks.isEmpty()) {
            this.discordService = new DiscordWebhookService(hooks);
            this.getLogger().info("Discord webhooks enabled: " + hooks.size());
        }
        this.marketplaceService = new MarketplaceService(listingRepo, balanceRepo, txLog, this.economyService, deliveryQueue, lockProvider, this.discordService);
        if (this.getConfig().getBoolean("redis.enabled", false)) {
            String rHost = this.getConfig().getString("redis.host", "localhost");
            int rPort = this.getConfig().getInt("redis.port", 6379);
            String rPass = this.getConfig().getString("redis.password", "");
            String rChannel = this.getConfig().getString("redis.channel", "gmarket-sync");
            this.redisSync = new RedisSync(rHost, rPort, rPass, rChannel);
            this.redisSync.start();
            this.getLogger().info("Redis sync enabled on channel '" + rChannel + "'.");
        }
        if (this.getCommand("gmarket") != null) {
            this.getCommand("gmarket").setExecutor((CommandExecutor)new GMarketCommand());
            this.getCommand("gmarket").setTabCompleter((TabCompleter)new GMarketTabCompleter());
        } else {
            this.getLogger().warning("Command 'gmarket' not found in plugin.yml");
        }
        if (this.getCommand("gmarkethelp") != null) {
            this.getCommand("gmarkethelp").setExecutor((CommandExecutor)new GMarketHelpCommand());
        } else {
            this.getLogger().warning("Command 'gmarkethelp' not found in plugin.yml");
        }
        this.getServer().getPluginManager().registerEvents((Listener)new GuiListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CreationListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SearchListener(), (Plugin)this);
        long periodTicks = 600L;
        this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
            try {
                int b;
                int a;
                if (this.marketplaceService != null && (a = this.marketplaceService.processExpiredAuctions(50)) + (b = this.marketplaceService.processExpiredListings(100)) > 0) {
                    this.getLogger().fine("Processed expirations - auctions: " + a + ", listings: " + b);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, periodTicks, periodTicks);
        this.getLogger().info("GlobalMarketplace enabled. Vault=" + (this.economy != null));
    }

    public void onDisable() {
        if (this.discordService != null) {
            try {
                this.discordService.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.database != null) {
            this.database.close();
        }
        if (this.redisSync != null) {
            this.redisSync.stop();
        }
        this.getLogger().info("GlobalMarketplace disabled.");
    }

    public EconomyService getEconomyService() {
        return this.economyService;
    }

    public MarketplaceService getMarketplaceService() {
        return this.marketplaceService;
    }

    private void setupVault() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().warning("Vault not found. Economy features will be disabled until Vault is installed.");
            return;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.getLogger().warning("No Economy provider found via Vault.");
            return;
        }
        this.economy = (Economy)rsp.getProvider();
    }

    private void initDatabase() {
        String host = this.getConfig().getString("database.host", "localhost");
        int port = this.getConfig().getInt("database.port", 3306);
        String dbName = this.getConfig().getString("database.database", "global_marketplace");
        String user = this.getConfig().getString("database.username", "root");
        String pass = this.getConfig().getString("database.password", "");
        int maxPool = this.getConfig().getInt("database.pool.maximumPoolSize", 10);
        int minIdle = this.getConfig().getInt("database.pool.minimumIdle", 2);
        long timeout = this.getConfig().getLong("database.pool.connectionTimeout", 30000L);
        this.database = new DatabaseManager(host, port, dbName, user, pass, maxPool, minIdle, timeout);
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public DatabaseManager getDatabase() {
        return this.database;
    }

    private static String asString(Object o) {
        return o == null ? null : String.valueOf(o);
    }
}

