/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.commands;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.commands.GMarketHelpCommand;
import org.texboobcat.globalMarketplace.service.MarketplaceService;
import org.texboobcat.globalMarketplace.ui.MainMenu;
import org.texboobcat.globalMarketplace.util.ItemSerializer;

public class GMarketCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players.");
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("globalmarketplace.use")) {
            sender.sendMessage("You do not have permission.");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("claim")) {
            int delivered;
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            if (svc == null) {
                player.sendMessage("\u00a7cMarketplace unavailable.");
                return true;
            }
            int max = 36;
            if (args.length >= 2) {
                try {
                    max = Math.max(1, Integer.parseInt(args[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((delivered = svc.claimDeliveries(player, max)) > 0) {
                player.sendMessage("\u00a7aClaimed " + delivered + " item(s).");
            } else {
                player.sendMessage("\u00a7eNo items to claim or inventory full.");
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("help")) {
            GMarketHelpCommand.sendHelp(player, label);
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("cancel")) {
            UUID listingId;
            if (!player.hasPermission("globalmarketplace.cancel")) {
                player.sendMessage("\u00a7cNo permission.");
                return true;
            }
            if (args.length < 2) {
                player.sendMessage("\u00a7eUsage: /" + label + " cancel <listingUuid>");
                return true;
            }
            try {
                listingId = UUID.fromString(args[1]);
            }
            catch (Exception e) {
                player.sendMessage("\u00a7cInvalid listing UUID.");
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            boolean ok = svc != null && svc.cancelListing(player.getUniqueId(), listingId);
            player.sendMessage(ok ? "\u00a7aListing cancelled. Item enqueued to your claims." : "\u00a7cCancel failed. Ensure listing is ACTIVE and owned by you.");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("admin")) {
            if (args.length < 2) {
                player.sendMessage("\u00a7eUsage: /" + label + " admin <remove|reload|rollback> ...");
                return true;
            }
            String sub = args[1].toLowerCase();
            if (sub.equals("remove")) {
                if (!player.hasPermission("globalmarketplace.admin.remove")) {
                    player.sendMessage("\u00a7cNo permission.");
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage("\u00a7eUsage: /" + label + " admin remove <listingUuid>");
                    return true;
                }
                try {
                    UUID id = UUID.fromString(args[2]);
                    MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                    boolean ok = svc != null && svc.adminRemoveListing(id);
                    player.sendMessage(ok ? "\u00a7aListing removed." : "\u00a7cFailed to remove listing (not found?).");
                }
                catch (IllegalArgumentException ex) {
                    player.sendMessage("\u00a7cInvalid UUID.");
                }
                return true;
            }
            if (sub.equals("reload")) {
                if (!player.hasPermission("globalmarketplace.admin.reload")) {
                    player.sendMessage("\u00a7cNo permission.");
                    return true;
                }
                GlobalMarketplacePlugin.getInstance().reloadConfig();
                player.sendMessage("\u00a7aGlobalMarketplace configuration reloaded.");
                return true;
            }
            if (sub.equals("rollback")) {
                if (!player.hasPermission("globalmarketplace.admin.rollback")) {
                    player.sendMessage("\u00a7cNo permission.");
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage("\u00a7eUsage: /" + label + " admin rollback <listingUuid>");
                    return true;
                }
                try {
                    UUID id = UUID.fromString(args[2]);
                    MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                    boolean ok = svc != null && svc.adminRollbackListing(id);
                    player.sendMessage(ok ? "\u00a7aRollback successful: listing set ACTIVE, buyer refunded." : "\u00a7cRollback failed. Ensure listing is SOLD and balances allow revert.");
                }
                catch (IllegalArgumentException ex) {
                    player.sendMessage("\u00a7cInvalid UUID.");
                }
                return true;
            }
            player.sendMessage("\u00a7eUsage: /" + label + " admin <remove|reload|rollback> ...");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("payout")) {
            Optional<BigDecimal> pendingOpt;
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            if (svc == null) {
                player.sendMessage("\u00a7cMarketplace unavailable.");
                return true;
            }
            BigDecimal amount = null;
            if (args.length >= 2 && !args[1].equalsIgnoreCase("all")) {
                try {
                    amount = new BigDecimal(args[1]);
                    if (amount.compareTo(BigDecimal.ZERO) <= 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7cInvalid amount. Use a number or 'all'.");
                    return true;
                }
            }
            if ((pendingOpt = svc.getPendingBalance(player.getUniqueId())).isEmpty()) {
                player.sendMessage("\u00a7cCould not fetch your balance.");
                return true;
            }
            BigDecimal pending = pendingOpt.get();
            if (pending.compareTo(BigDecimal.ZERO) <= 0) {
                player.sendMessage("\u00a7eYou have no pending balance to withdraw.");
                return true;
            }
            boolean ok = svc.payout(player.getUniqueId(), amount);
            if (ok) {
                BigDecimal after = svc.getPendingBalance(player.getUniqueId()).orElse(BigDecimal.ZERO);
                player.sendMessage("\u00a7aPayout successful. Remaining pending: $" + String.valueOf(after));
            } else {
                player.sendMessage("\u00a7cPayout failed. Try again later.");
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("sell")) {
            String serialized;
            BigDecimal price;
            if (args.length < 2) {
                player.sendMessage("\u00a7eUsage: /" + label + " sell <price>");
                return true;
            }
            try {
                price = new BigDecimal(args[1]);
                if (price.compareTo(BigDecimal.ZERO) <= 0) {
                    player.sendMessage("\u00a7cPrice must be greater than 0.");
                    return true;
                }
            }
            catch (NumberFormatException e) {
                player.sendMessage("\u00a7cInvalid price. Use a number like 100 or 99.99");
                return true;
            }
            ItemStack inHand = player.getInventory().getItemInMainHand();
            if (inHand == null || inHand.getType() == Material.AIR) {
                player.sendMessage("\u00a7cHold the item you want to sell in your main hand.");
                return true;
            }
            try {
                serialized = ItemSerializer.toBase64(inHand);
            }
            catch (Exception ex) {
                player.sendMessage("\u00a7cFailed to serialize item. Try again.");
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            if (svc == null) {
                player.sendMessage("\u00a7cMarketplace service unavailable.");
                return true;
            }
            Optional<UUID> created = svc.createFixedListing(player.getUniqueId(), serialized, price);
            if (created.isPresent()) {
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                player.sendMessage("\u00a7aListing created! ID: " + String.valueOf(created.get()));
            } else {
                player.sendMessage("\u00a7cCould not create listing. Please try again later.");
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("auction")) {
            String serialized;
            int minutes;
            BigDecimal start;
            if (args.length < 3) {
                player.sendMessage("\u00a7eUsage: /" + label + " auction <startPrice> <minutes>");
                return true;
            }
            try {
                start = new BigDecimal(args[1]);
                minutes = Integer.parseInt(args[2]);
                if (start.compareTo(BigDecimal.ZERO) <= 0 || minutes <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                player.sendMessage("\u00a7cInvalid arguments. Example: /" + label + " auction 100 60");
                return true;
            }
            ItemStack inHand = player.getInventory().getItemInMainHand();
            if (inHand == null || inHand.getType() == Material.AIR) {
                player.sendMessage("\u00a7cHold the item you want to auction in your main hand.");
                return true;
            }
            try {
                serialized = ItemSerializer.toBase64(inHand);
            }
            catch (Exception ex) {
                player.sendMessage("\u00a7cFailed to serialize item.");
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            Optional<UUID> created = svc.createAuctionListing(player.getUniqueId(), serialized, start, Instant.now().plus(Duration.ofMinutes(minutes)));
            if (created.isPresent()) {
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                player.sendMessage("\u00a7aAuction created! ID: " + String.valueOf(created.get()));
            } else {
                player.sendMessage("\u00a7cCould not create auction.");
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("bid")) {
            BigDecimal amount;
            UUID listingId;
            if (args.length < 3) {
                player.sendMessage("\u00a7eUsage: /" + label + " bid <listingUuid> <amount>");
                return true;
            }
            try {
                listingId = UUID.fromString(args[1]);
                amount = new BigDecimal(args[2]);
                if (amount.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (Exception e) {
                player.sendMessage("\u00a7cInvalid arguments.");
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            boolean ok = svc.placeBid(listingId, player.getUniqueId(), amount);
            player.sendMessage(ok ? "\u00a7aBid placed." : "\u00a7cBid rejected.");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("directsell")) {
            String serialized;
            UUID target;
            BigDecimal price;
            if (args.length < 3) {
                player.sendMessage("\u00a7eUsage: /" + label + " directsell <price> <playerUuid>");
                return true;
            }
            try {
                price = new BigDecimal(args[1]);
                target = UUID.fromString(args[2]);
                if (price.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (Exception e) {
                player.sendMessage("\u00a7cInvalid arguments.");
                return true;
            }
            ItemStack inHand = player.getInventory().getItemInMainHand();
            if (inHand == null || inHand.getType() == Material.AIR) {
                player.sendMessage("\u00a7cHold the item you want to sell directly in your main hand.");
                return true;
            }
            try {
                serialized = ItemSerializer.toBase64(inHand);
            }
            catch (Exception ex) {
                player.sendMessage("\u00a7cFailed to serialize item.");
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            Optional<UUID> created = svc.createDirectListing(player.getUniqueId(), target, serialized, price);
            if (created.isPresent()) {
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                player.sendMessage("\u00a7aDirect listing created for target buyer. ID: " + String.valueOf(created.get()));
            } else {
                player.sendMessage("\u00a7cCould not create direct listing.");
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("directbuy")) {
            UUID listingId;
            if (args.length < 2) {
                player.sendMessage("\u00a7eUsage: /" + label + " directbuy <listingUuid>");
                return true;
            }
            try {
                listingId = UUID.fromString(args[1]);
            }
            catch (Exception e) {
                player.sendMessage("\u00a7cInvalid listing UUID.");
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            boolean ok = svc.purchaseDirect(player.getUniqueId(), listingId);
            if (ok) {
                int delivered = svc.claimDeliveries(player, 36);
                if (delivered > 0) {
                    player.sendMessage("\u00a7aDirect purchase successful. Item delivered to your inventory.");
                } else {
                    player.sendMessage("\u00a7eDirect purchase successful, but your inventory was full. Use /gmarket claim to receive.");
                }
            } else {
                player.sendMessage("\u00a7cDirect purchase failed.");
            }
            return true;
        }
        new MainMenu().open(player);
        GlobalMarketplacePlugin.getInstance().getLogger().info("/gmarket opened MainMenu for " + sender.getName());
        return true;
    }
}

