/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.integrations;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.util.ItemSerializer;

public class DiscordWebhookService {
    private final List<Webhook> webhooks;
    private final ExecutorService pool = Executors.newFixedThreadPool(2);

    public DiscordWebhookService(List<Webhook> webhooks) {
        this.webhooks = webhooks != null ? webhooks : Collections.emptyList();
    }

    public void shutdown() {
        this.pool.shutdownNow();
    }

    public void send(EventType type, Listing listing, UUID actorUuid, BigDecimal amount) {
        if (this.webhooks.isEmpty() || listing == null) {
            return;
        }
        String content = this.buildMessage(type, listing, actorUuid, amount);
        if (content == null || content.isEmpty()) {
            return;
        }
        for (Webhook wh : this.webhooks) {
            if (!wh.isEnabled(type)) continue;
            this.pool.submit(() -> this.post(wh, content));
        }
    }

    private void post(Webhook wh, String content) {
        try {
            URL u = new URL(wh.url);
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            String payload = this.toJsonPayload(content, wh.username, wh.avatarUrl);
            try (OutputStream os = conn.getOutputStream();){
                os.write(payload.getBytes(StandardCharsets.UTF_8));
            }
            int code = conn.getResponseCode();
            if (code < 200 || code >= 300) {
                GlobalMarketplacePlugin.getInstance().getLogger().fine("Discord webhook response code: " + code + " for " + wh.name);
            }
        }
        catch (Exception e) {
            GlobalMarketplacePlugin.getInstance().getLogger().fine("Discord webhook post failed: " + e.getMessage());
        }
    }

    private String toJsonPayload(String content, String username, String avatarUrl) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append("\"content\":").append(this.quote(content));
        if (username != null && !username.isEmpty()) {
            sb.append(',').append("\"username\":").append(this.quote(username));
        }
        if (avatarUrl != null && !avatarUrl.isEmpty()) {
            sb.append(',').append("\"avatar_url\":").append(this.quote(avatarUrl));
        }
        sb.append('}');
        return sb.toString();
    }

    private String quote(String s) {
        String esc = s.replace("\\", "\\\\").replace("\"", "\\\"");
        return "\"" + esc + "\"";
    }

    private String buildMessage(EventType type, Listing l, UUID actorUuid, BigDecimal amount) {
        String itemName = this.resolveItemName(l);
        String seller = this.nameOf(l.getSellerUuid());
        String buyer = actorUuid != null ? this.nameOf(actorUuid) : null;
        String id = l.getUuid().toString().substring(0, 8);
        String price = (amount != null ? amount : l.getPrice()) != null ? (amount != null ? amount : l.getPrice()).toPlainString() : "";
        StringBuilder sb = new StringBuilder();
        switch (type.ordinal()) {
            case 0: {
                sb.append("\ud83c\udd95 New Fixed Listing: ").append(itemName).append(" for $").append(price).append(" by ").append(seller).append(" (ID ").append(id).append(")");
                break;
            }
            case 1: {
                sb.append("\ud83c\udd95 New Auction: ").append(itemName).append(" starting at $").append(price).append(" by ").append(seller).append(this.expirySuffix(l)).append(" (ID ").append(id).append(")");
                break;
            }
            case 2: {
                sb.append("\ud83d\udcc8 Bid Placed: ").append(itemName).append(" $").append(price).append(" by ").append(buyer).append(" (Seller ").append(seller).append(") ").append("(ID ").append(id).append(")");
                break;
            }
            case 3: {
                sb.append("\u2705 Sold (Fixed): ").append(itemName).append(" for $").append(price).append(" to ").append(buyer).append(" (Seller ").append(seller).append(") ").append("(ID ").append(id).append(")");
                break;
            }
            case 4: {
                sb.append("\ud83e\udd1d Sold (Direct): ").append(itemName).append(" for $").append(price).append(" to ").append(buyer).append(" (Seller ").append(seller).append(") ").append("(ID ").append(id).append(")");
                break;
            }
            case 5: {
                sb.append("\ud83c\udfc6 Auction Won: ").append(itemName).append(" for $").append(price).append(" by ").append(buyer).append(" (Seller ").append(seller).append(") ").append("(ID ").append(id).append(")");
                break;
            }
            case 6: {
                sb.append("\u231b Auction Expired: ").append(itemName).append(" (Seller ").append(seller).append(") ").append("(ID ").append(id).append(")");
            }
        }
        return sb.toString();
    }

    private String expirySuffix(Listing l) {
        Instant ex = l.getExpiresAt();
        if (ex == null) {
            return "";
        }
        long secs = Math.max(0L, ex.getEpochSecond() - Instant.now().getEpochSecond());
        long h = secs / 3600L;
        long m = secs % 3600L / 60L;
        return " \u00b7 ends in " + (String)(h > 0L ? h + "h " : "") + ((String)(m > 0L ? m + "m" : "")).trim();
    }

    private String resolveItemName(Listing l) {
        try {
            ItemStack stack = ItemSerializer.fromBase64(l.getItemSerialized());
            if (stack == null || stack.getType() == Material.AIR) {
                return "Unknown Item";
            }
            ItemMeta meta = stack.getItemMeta();
            if (meta != null && meta.hasDisplayName()) {
                return meta.getDisplayName();
            }
            String n = stack.getType().name().toLowerCase(Locale.ROOT).replace('_', ' ');
            String[] parts = n.split(" ");
            StringBuilder sb = new StringBuilder();
            for (String p : parts) {
                if (p.isEmpty()) continue;
                sb.append(Character.toUpperCase(p.charAt(0))).append(p.substring(1)).append(' ');
            }
            return sb.toString().trim();
        }
        catch (Exception e) {
            return "Unknown Item";
        }
    }

    private String nameOf(UUID uuid) {
        try {
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)uuid);
            if (op != null && op.getName() != null) {
                return op.getName();
            }
        }
        catch (Throwable op) {
            // empty catch block
        }
        String u = uuid != null ? uuid.toString() : "?";
        return u.substring(0, Math.min(8, u.length()));
    }

    public static enum EventType {
        NEW_FIXED,
        NEW_AUCTION,
        BID_PLACED,
        FIXED_SOLD,
        DIRECT_SOLD,
        AUCTION_SOLD,
        AUCTION_EXPIRED;

    }

    public static class Webhook {
        public final String name;
        public final String url;
        public final Set<EventType> enabled;
        public final String username;
        public final String avatarUrl;

        public Webhook(String name, String url, Set<EventType> enabled, String username, String avatarUrl) {
            this.name = name;
            this.url = url;
            this.enabled = enabled;
            this.username = username;
            this.avatarUrl = avatarUrl;
        }

        public boolean isEnabled(EventType type) {
            return this.enabled == null || this.enabled.isEmpty() || this.enabled.contains((Object)type);
        }
    }
}

