/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.sync;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.Duration;
import org.texboobcat.globalMarketplace.dao.LockProvider;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.params.SetParams;

public class RedisLockProvider
implements LockProvider {
    private final JedisPooled jedis;
    private final String keyPrefix;

    public RedisLockProvider(String host, int port, String password, String keyPrefix) {
        String uri;
        if (password != null && !password.isEmpty()) {
            String enc = URLEncoder.encode(password, StandardCharsets.UTF_8);
            uri = "redis://:" + enc + "@" + host + ":" + port;
        } else {
            uri = "redis://" + host + ":" + port;
        }
        this.jedis = new JedisPooled(uri);
        this.keyPrefix = keyPrefix == null ? "gmarket:lock:" : keyPrefix;
    }

    @Override
    public boolean tryAcquire(String key, Duration ttl) throws SQLException {
        try {
            String redisKey = this.keyPrefix + key;
            long px = Math.max(100L, ttl.toMillis());
            String res = this.jedis.set(redisKey, "1", SetParams.setParams().nx().px(px));
            return "OK".equals(res);
        }
        catch (Exception e) {
            throw new SQLException("Redis lock acquire failed: " + e.getMessage(), e);
        }
    }

    @Override
    public void release(String key) throws SQLException {
        try {
            this.jedis.del(this.keyPrefix + key);
        }
        catch (Exception e) {
            throw new SQLException("Redis lock release failed: " + e.getMessage(), e);
        }
    }
}

