/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.ui;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.model.ListingType;
import org.texboobcat.globalMarketplace.service.MarketplaceService;
import org.texboobcat.globalMarketplace.util.ItemSerializer;

public class AuctionMenu {
    public static final String TITLE_PREFIX = "Auction: ";

    public void open(Player player, UUID listingUuid) {
        ItemStack display;
        MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
        if (svc == null) {
            player.sendMessage("\u00a7cMarketplace unavailable.");
            return;
        }
        Optional<Listing> opt = svc.getListing(listingUuid);
        if (opt.isEmpty()) {
            player.sendMessage("\u00a7cListing not found.");
            return;
        }
        Listing l = opt.get();
        if (l.getType() != ListingType.AUCTION) {
            player.sendMessage("\u00a7cThis listing is not an auction.");
            return;
        }
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)(TITLE_PREFIX + listingUuid.toString()));
        try {
            display = ItemSerializer.fromBase64(l.getItemSerialized());
            if (display == null || display.getType() == Material.AIR) {
                display = new ItemStack(Material.CHEST);
            }
        }
        catch (Exception ex) {
            display = new ItemStack(Material.CHEST);
        }
        ItemMeta im = display.getItemMeta();
        if (im != null) {
            String rem;
            BigDecimal current = l.getCurrentBid() != null ? l.getCurrentBid() : l.getPrice();
            String baseItemName = im.hasDisplayName() ? im.getDisplayName() : AuctionMenu.prettify(display.getType().name());
            im.setDisplayName("\u00a7bAuction: \u00a7f" + baseItemName);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a77Current Bid: \u00a7a$" + String.valueOf(current));
            if (l.getExpiresAt() != null && !(rem = AuctionMenu.remaining(l.getExpiresAt())).isEmpty()) {
                lore.add("\u00a77Ends In: \u00a7f" + rem);
            }
            lore.add("\u00a77Seller: \u00a7f" + AuctionMenu.sellerName(l.getSellerUuid()));
            lore.add("\u00a78ID: " + String.valueOf(l.getUuid()));
            AuctionMenu.appendEnchantLore(display, im, lore);
            im.setLore(lore);
            display.setItemMeta(im);
        }
        inv.setItem(13, display);
        inv.setItem(11, this.createButton(Material.LIME_WOOL, "\u00a7aBid +1", listingUuid, "bid:+1"));
        inv.setItem(15, this.createButton(Material.GREEN_WOOL, "\u00a7aBid +10", listingUuid, "bid:+10"));
        player.openInventory(inv);
    }

    private ItemStack createButton(Material material, String name, UUID listingUuid, String action) {
        ItemStack it = new ItemStack(material);
        ItemMeta meta = it.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            NamespacedKey keyListing = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_listing");
            NamespacedKey keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            pdc.set(keyListing, PersistentDataType.STRING, (Object)listingUuid.toString());
            pdc.set(keyAction, PersistentDataType.STRING, (Object)action);
            it.setItemMeta(meta);
        }
        return it;
    }

    private static String prettify(String enumName) {
        String lower = enumName.toLowerCase(Locale.ROOT).replace('_', ' ');
        String[] parts = lower.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            sb.append(Character.toUpperCase(p.charAt(0))).append(p.substring(1)).append(' ');
        }
        return sb.toString().trim();
    }

    private static String remaining(Instant expiresAt) {
        if (expiresAt == null) {
            return "";
        }
        Instant now = Instant.now();
        if (!expiresAt.isAfter(now)) {
            return "expired";
        }
        Duration d = Duration.between(now, expiresAt);
        long days = d.toDays();
        d = d.minusDays(days);
        long hours = d.toHours();
        d = d.minusHours(hours);
        long minutes = d.toMinutes();
        d = d.minusMinutes(minutes);
        long seconds = d.getSeconds();
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (seconds > 0L && days == 0L && hours == 0L) {
            sb.append(seconds).append("s");
        }
        return sb.toString().trim();
    }

    private static String sellerName(UUID uuid) {
        try {
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)uuid);
            if (op != null && op.getName() != null) {
                return op.getName();
            }
        }
        catch (Throwable op) {
            // empty catch block
        }
        String u = uuid.toString();
        return u.substring(0, 8);
    }

    private static void appendEnchantLore(ItemStack item, ItemMeta meta, List<String> lore) {
        Map ench = item.getEnchantments();
        if (ench != null && !ench.isEmpty()) {
            lore.add("\u00a77Enchantments:");
            for (Map.Entry e : ench.entrySet()) {
                String name = AuctionMenu.prettify(((Enchantment)e.getKey()).getKey().getKey());
                lore.add("\u00a78- \u00a7f" + name + " " + AuctionMenu.roman((Integer)e.getValue()));
            }
        }
    }

    private static String roman(int n) {
        String[] romans = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        if (n >= 0 && n < romans.length) {
            return romans[n];
        }
        return Integer.toString(n);
    }
}

