/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.ui;

import java.math.BigDecimal;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.model.ListingType;
import org.texboobcat.globalMarketplace.service.MarketplaceService;
import org.texboobcat.globalMarketplace.session.CreationSessionManager;
import org.texboobcat.globalMarketplace.session.SearchSessionManager;
import org.texboobcat.globalMarketplace.ui.AuctionMenu;
import org.texboobcat.globalMarketplace.ui.ListMenu;
import org.texboobcat.globalMarketplace.ui.MainMenu;

public class GuiListener
implements Listener {
    private static final String TITLE = "Global Marketplace";

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        NamespacedKey keyAction;
        ItemMeta meta;
        ItemStack item;
        Player player;
        if (event.getView() == null) {
            return;
        }
        String title = event.getView().getTitle();
        if (TITLE.equals(title)) {
            event.setCancelled(true);
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                return;
            }
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            NamespacedKey key = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_listing");
            keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            NamespacedKey keyPage = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_page");
            NamespacedKey keyQuery = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_query");
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            String action = (String)pdc.get(keyAction, PersistentDataType.STRING);
            if ("open_list_menu".equals(action)) {
                new ListMenu().open(player);
                return;
            }
            if ("page_prev".equals(action) || "page_next".equals(action)) {
                Integer page = (Integer)pdc.get(keyPage, PersistentDataType.INTEGER);
                String query = (String)pdc.get(keyQuery, PersistentDataType.STRING);
                if (page == null) {
                    page = 0;
                }
                new MainMenu().open(player, Math.max(0, page), query);
                return;
            }
            if ("open_search".equals(action)) {
                SearchSessionManager.get().start(player.getUniqueId());
                player.closeInventory();
                player.sendMessage("\u00a7eType your search in chat. Examples: \u00a77diamond\u00a7e, \u00a77seller:Steve\u00a7e, \u00a77type:auction min:100 max:500");
                return;
            }
            String uuidStr = (String)pdc.get(key, PersistentDataType.STRING);
            if (uuidStr == null) {
                return;
            }
            try {
                UUID listingUuid2 = UUID.fromString(uuidStr);
                MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                if (svc == null) {
                    return;
                }
                Optional<Listing> opt = svc.getListing(listingUuid2);
                if (opt.isEmpty()) {
                    player.sendMessage("\u00a7cListing unavailable.");
                    return;
                }
                Listing l = opt.get();
                if (l.getType() == ListingType.FIXED) {
                    boolean ok = svc.purchaseFixed(player.getUniqueId(), listingUuid2);
                    if (ok) {
                        int delivered = svc.claimDeliveries(player, 36);
                        if (delivered > 0) {
                            player.sendMessage("\u00a7aPurchase successful! Item delivered to your inventory.");
                        } else {
                            player.sendMessage("\u00a7ePurchase successful, but your inventory was full. Use /gmarket claim to receive.");
                        }
                        player.closeInventory();
                    } else {
                        player.sendMessage("\u00a7cPurchase failed. The listing might be unavailable or you lack funds.");
                    }
                } else if (l.getType() == ListingType.AUCTION) {
                    new AuctionMenu().open(player, listingUuid2);
                } else {
                    player.sendMessage("\u00a7eThis listing cannot be purchased from the main menu.");
                }
            }
            catch (IllegalArgumentException listingUuid2) {
                // empty catch block
            }
        }
        if (title != null && title.startsWith("Auction: ")) {
            event.setCancelled(true);
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                return;
            }
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            NamespacedKey keyListing = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_listing");
            keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            String uuidStr = (String)pdc.get(keyListing, PersistentDataType.STRING);
            String action = (String)pdc.get(keyAction, PersistentDataType.STRING);
            if (uuidStr == null || action == null) {
                return;
            }
            try {
                UUID listingUuid = UUID.fromString(uuidStr);
                int inc = 0;
                if (action.startsWith("bid:+")) {
                    try {
                        inc = Integer.parseInt(action.substring(5));
                    }
                    catch (NumberFormatException listingUuid2) {
                        // empty catch block
                    }
                }
                if (inc <= 0) {
                    return;
                }
                MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                if (svc == null) {
                    return;
                }
                Optional<Listing> opt = svc.getListing(listingUuid);
                if (opt.isEmpty()) {
                    player.sendMessage("\u00a7cListing not found.");
                    return;
                }
                Listing l = opt.get();
                BigDecimal base = l.getCurrentBid() != null ? l.getCurrentBid() : l.getPrice();
                BigDecimal amount = base.add(new BigDecimal(inc));
                boolean ok = svc.placeBid(listingUuid, player.getUniqueId(), amount);
                player.sendMessage((String)(ok ? "\u00a7aBid placed for $" + String.valueOf(amount) : "\u00a7cBid rejected."));
                new AuctionMenu().open(player, listingUuid);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ("List an Item".equals(title)) {
            event.setCancelled(true);
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                return;
            }
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            NamespacedKey keyAction2 = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            String action = (String)meta.getPersistentDataContainer().get(keyAction2, PersistentDataType.STRING);
            if (action == null) {
                return;
            }
            if (action.equals("list_fixed")) {
                CreationSessionManager.get().start(player.getUniqueId(), CreationSessionManager.Mode.FIXED);
                player.closeInventory();
                player.sendMessage("\u00a7eEnter price in chat (e.g., 100 or 99.99)");
            } else if (action.equals("list_auction")) {
                CreationSessionManager.get().start(player.getUniqueId(), CreationSessionManager.Mode.AUCTION);
                player.closeInventory();
                player.sendMessage("\u00a7eEnter start price and minutes in chat (e.g., 100 60)");
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.getView() == null) {
            return;
        }
        String title = event.getView().getTitle();
        if (TITLE.equals(title)) {
            event.setCancelled(true);
        }
        if (title != null && title.startsWith("Auction: ")) {
            event.setCancelled(true);
        }
    }
}

