/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.ui;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.model.ListingType;
import org.texboobcat.globalMarketplace.service.MarketplaceService;
import org.texboobcat.globalMarketplace.util.ItemSerializer;

public class MainMenu {
    private static final int ROWS = 6;
    private static final String TITLE = "Global Marketplace";

    public void open(Player player) {
        this.open(player, 0, null);
    }

    public void open(Player player, int page, String query) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)TITLE);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = filler.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(" ");
            filler.setItemMeta(meta);
        }
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, filler);
        }
        MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
        if (svc != null) {
            int slot = 0;
            List<Listing> listings = query == null || query.isEmpty() ? svc.getActiveListings(page, inv.getSize() - 9) : svc.searchActiveListings(query, page, inv.getSize() - 9);
            for (Listing l : listings) {
                ItemStack display;
                try {
                    display = ItemSerializer.fromBase64(l.getItemSerialized());
                    if (display == null || display.getType() == Material.AIR) {
                        display = new ItemStack(Material.CHEST);
                    }
                }
                catch (Exception ex) {
                    display = new ItemStack(Material.CHEST);
                }
                ItemMeta im = display.getItemMeta();
                if (im != null) {
                    String baseItemName = im.hasDisplayName() ? im.getDisplayName() : MainMenu.prettify(display.getType().name());
                    String title = l.getType() == ListingType.AUCTION ? "\u00a7bAuction: \u00a7f" + baseItemName : "\u00a7aFixed: \u00a7f" + baseItemName;
                    im.setDisplayName(title);
                    ArrayList<String> lore = new ArrayList<String>();
                    if (l.getType() == ListingType.AUCTION) {
                        String rem;
                        BigDecimal current = l.getCurrentBid() != null ? l.getCurrentBid() : l.getPrice();
                        lore.add("\u00a77Type: \u00a7bAuction");
                        lore.add("\u00a77Current Bid: \u00a7a$" + String.valueOf(current));
                        if (l.getExpiresAt() != null && !(rem = MainMenu.remaining(l.getExpiresAt())).isEmpty()) {
                            lore.add("\u00a77Ends In: \u00a7f" + rem);
                        }
                    } else {
                        lore.add("\u00a77Type: \u00a7aFixed Price");
                        lore.add("\u00a77Price: \u00a7a$" + String.valueOf(l.getPrice()));
                        double avg = MainMenu.avgPriceForMaterial(listings, display.getType());
                        if (avg > 0.0) {
                            lore.add("\u00a77Avg Price: \u00a7f$" + String.format(Locale.US, "%.2f", avg));
                        }
                    }
                    MainMenu.appendEnchantLore(display, im, lore);
                    String seller = MainMenu.sellerName(l.getSellerUuid());
                    lore.add("\u00a77Seller: \u00a7f" + seller);
                    lore.add("\u00a78ID: " + String.valueOf(l.getUuid()));
                    im.setLore(lore);
                    NamespacedKey key = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_listing");
                    PersistentDataContainer pdc = im.getPersistentDataContainer();
                    pdc.set(key, PersistentDataType.STRING, (Object)l.getUuid().toString());
                    display.setItemMeta(im);
                }
                if (slot >= inv.getSize() - 9) break;
                inv.setItem(slot, display);
                ++slot;
            }
        }
        NamespacedKey keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
        NamespacedKey keyPage = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_page");
        NamespacedKey keyQuery = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_query");
        ItemStack prev = new ItemStack(Material.ARROW);
        ItemMeta pm = prev.getItemMeta();
        if (pm != null) {
            pm.setDisplayName("\u00a7ePrevious Page");
            pm.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)"page_prev");
            pm.getPersistentDataContainer().set(keyPage, PersistentDataType.INTEGER, (Object)Math.max(0, page - 1));
            if (query != null) {
                pm.getPersistentDataContainer().set(keyQuery, PersistentDataType.STRING, (Object)query);
            }
            prev.setItemMeta(pm);
        }
        inv.setItem(45, prev);
        ItemStack listBtn = new ItemStack(Material.GOLD_INGOT);
        ItemMeta lm = listBtn.getItemMeta();
        if (lm != null) {
            lm.setDisplayName("\u00a76List Item");
            lm.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)"open_list_menu");
            listBtn.setItemMeta(lm);
        }
        inv.setItem(49, listBtn);
        ItemStack next = new ItemStack(Material.ARROW);
        ItemMeta nm = next.getItemMeta();
        if (nm != null) {
            nm.setDisplayName("\u00a7eNext Page");
            nm.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)"page_next");
            nm.getPersistentDataContainer().set(keyPage, PersistentDataType.INTEGER, (Object)Math.max(0, page + 1));
            if (query != null) {
                nm.getPersistentDataContainer().set(keyQuery, PersistentDataType.STRING, (Object)query);
            }
            next.setItemMeta(nm);
        }
        inv.setItem(53, next);
        ItemStack search = new ItemStack(Material.COMPASS);
        ItemMeta sm = search.getItemMeta();
        if (sm != null) {
            sm.setDisplayName("\u00a7fSearch");
            sm.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)"open_search");
            if (query != null) {
                sm.getPersistentDataContainer().set(keyQuery, PersistentDataType.STRING, (Object)query);
            }
            search.setItemMeta(sm);
        }
        inv.setItem(47, search);
        player.openInventory(inv);
    }

    private static String prettify(String enumName) {
        String lower = enumName.toLowerCase(Locale.ROOT).replace('_', ' ');
        String[] parts = lower.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            sb.append(Character.toUpperCase(p.charAt(0))).append(p.substring(1)).append(' ');
        }
        return sb.toString().trim();
    }

    private static String remaining(Instant expiresAt) {
        if (expiresAt == null) {
            return "";
        }
        Instant now = Instant.now();
        if (!expiresAt.isAfter(now)) {
            return "expired";
        }
        Duration d = Duration.between(now, expiresAt);
        long days = d.toDays();
        d = d.minusDays(days);
        long hours = d.toHours();
        d = d.minusHours(hours);
        long minutes = d.toMinutes();
        d = d.minusMinutes(minutes);
        long seconds = d.getSeconds();
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (seconds > 0L && days == 0L && hours == 0L) {
            sb.append(seconds).append("s");
        }
        return sb.toString().trim();
    }

    private static String sellerName(UUID uuid) {
        try {
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)uuid);
            if (op != null && op.getName() != null) {
                return op.getName();
            }
        }
        catch (Throwable op) {
            // empty catch block
        }
        String u = uuid.toString();
        return u.substring(0, 8);
    }

    private static void appendEnchantLore(ItemStack item, ItemMeta meta, List<String> lore) {
        Map ench = item.getEnchantments();
        if (ench != null && !ench.isEmpty()) {
            lore.add("\u00a77Enchantments:");
            for (Map.Entry e : ench.entrySet()) {
                String name = MainMenu.prettify(((Enchantment)e.getKey()).getKey().getKey());
                lore.add("\u00a78- \u00a7f" + name + " " + MainMenu.roman((Integer)e.getValue()));
            }
        }
    }

    private static String roman(int n) {
        String[] romans = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        if (n >= 0 && n < romans.length) {
            return romans[n];
        }
        return Integer.toString(n);
    }

    private static double avgPriceForMaterial(List<Listing> listings, Material mat) {
        double sum = 0.0;
        int count = 0;
        for (Listing li : listings) {
            try {
                ItemStack is = ItemSerializer.fromBase64(li.getItemSerialized());
                if (is == null || is.getType() != mat || li.getType() != ListingType.FIXED || li.getPrice() == null) continue;
                sum += li.getPrice().doubleValue();
                ++count;
            }
            catch (Exception exception) {}
        }
        return count > 0 ? sum / (double)count : 0.0;
    }
}

