/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.economy;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.texboobcat.globalMarketplace.economy.EconomyAdapter;
import org.texboobcat.globalMarketplace.economy.VaultUnlockedAdapter;

public class EconomyService {
    private final EconomyAdapter adapter;

    public EconomyService(EconomyAdapter adapter) {
        this.adapter = adapter;
    }

    public boolean isEnabled() {
        return this.adapter != null && this.adapter.isEnabled();
    }

    public String getProviderName() {
        return this.adapter != null ? this.adapter.getProviderName() : "None";
    }

    public String format(double amount) {
        return this.adapter != null ? this.adapter.format(amount) : String.format("%.2f", amount);
    }

    public String format(BigDecimal amount) {
        return this.adapter != null ? this.adapter.format(amount) : String.format("%.2f", amount.doubleValue());
    }

    public double getBalance(OfflinePlayer player) {
        if (this.adapter == null) {
            return 0.0;
        }
        return this.adapter.getBalance(player);
    }

    public double getBalance(UUID playerId) {
        if (this.adapter == null) {
            return 0.0;
        }
        return this.adapter.getBalance(playerId);
    }

    public BigDecimal getBalancePrecise(UUID playerId) {
        if (this.adapter == null) {
            return BigDecimal.ZERO;
        }
        return this.adapter.getBalancePrecise(playerId);
    }

    public boolean withdraw(OfflinePlayer player, double amount) {
        if (this.adapter == null) {
            return false;
        }
        return this.adapter.withdraw(player, amount);
    }

    public boolean withdraw(UUID playerId, double amount) {
        if (this.adapter == null) {
            return false;
        }
        return this.adapter.withdraw(playerId, amount);
    }

    public boolean withdrawPrecise(UUID playerId, BigDecimal amount) {
        if (this.adapter == null) {
            return false;
        }
        return this.adapter.withdrawPrecise(playerId, amount);
    }

    public boolean deposit(OfflinePlayer player, double amount) {
        if (this.adapter == null) {
            return false;
        }
        return this.adapter.deposit(player, amount);
    }

    public boolean deposit(UUID playerId, double amount) {
        if (this.adapter == null) {
            return false;
        }
        return this.adapter.deposit(playerId, amount);
    }

    public boolean depositPrecise(UUID playerId, BigDecimal amount) {
        if (this.adapter == null) {
            return false;
        }
        return this.adapter.depositPrecise(playerId, amount);
    }

    public boolean has(OfflinePlayer player, double amount) {
        if (this.adapter == null) {
            return false;
        }
        return this.adapter.has(player, amount);
    }

    public boolean has(UUID playerId, double amount) {
        if (this.adapter == null) {
            return false;
        }
        return this.adapter.has(playerId, amount);
    }

    public boolean hasMultiCurrencySupport() {
        return this.adapter != null && this.adapter.hasMultiCurrencySupport();
    }

    public List<String> getCurrencies() {
        if (this.adapter == null) {
            return Collections.emptyList();
        }
        return this.adapter.getCurrencies();
    }

    public String getDefaultCurrency() {
        return this.adapter != null ? this.adapter.getDefaultCurrency() : "Unknown";
    }

    public EconomyAdapter getAdapter() {
        return this.adapter;
    }

    public VaultUnlockedAdapter getVaultUnlockedAdapter() {
        if (this.adapter instanceof VaultUnlockedAdapter) {
            return (VaultUnlockedAdapter)this.adapter;
        }
        return null;
    }
}

