/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.economy;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.texboobcat.globalMarketplace.economy.EconomyAdapter;

public class VaultEconomyAdapter
implements EconomyAdapter {
    private final Economy economy;

    public VaultEconomyAdapter(Economy economy) {
        this.economy = economy;
    }

    @Override
    public boolean isEnabled() {
        return this.economy != null && this.economy.isEnabled();
    }

    @Override
    public String getProviderName() {
        return "Vault (" + (this.economy != null ? this.economy.getName() : "Unknown") + ")";
    }

    @Override
    public String format(double amount) {
        return this.economy != null ? this.economy.format(amount) : String.format("%.2f", amount);
    }

    @Override
    public String format(BigDecimal amount) {
        return this.format(amount.doubleValue());
    }

    @Override
    public double getBalance(OfflinePlayer player) {
        if (this.economy == null) {
            return 0.0;
        }
        return this.economy.getBalance(player);
    }

    @Override
    public double getBalance(UUID playerId) {
        return this.getBalance(Bukkit.getOfflinePlayer((UUID)playerId));
    }

    @Override
    public BigDecimal getBalancePrecise(UUID playerId) {
        return BigDecimal.valueOf(this.getBalance(playerId));
    }

    @Override
    public boolean withdraw(OfflinePlayer player, double amount) {
        if (this.economy == null) {
            return false;
        }
        return this.economy.withdrawPlayer(player, amount).transactionSuccess();
    }

    @Override
    public boolean withdraw(UUID playerId, double amount) {
        return this.withdraw(Bukkit.getOfflinePlayer((UUID)playerId), amount);
    }

    @Override
    public boolean withdrawPrecise(UUID playerId, BigDecimal amount) {
        return this.withdraw(playerId, amount.doubleValue());
    }

    @Override
    public boolean deposit(OfflinePlayer player, double amount) {
        if (this.economy == null) {
            return false;
        }
        return this.economy.depositPlayer(player, amount).transactionSuccess();
    }

    @Override
    public boolean deposit(UUID playerId, double amount) {
        return this.deposit(Bukkit.getOfflinePlayer((UUID)playerId), amount);
    }

    @Override
    public boolean depositPrecise(UUID playerId, BigDecimal amount) {
        return this.deposit(playerId, amount.doubleValue());
    }

    @Override
    public boolean has(OfflinePlayer player, double amount) {
        if (this.economy == null) {
            return false;
        }
        return this.economy.has(player, amount);
    }

    @Override
    public boolean has(UUID playerId, double amount) {
        return this.has(Bukkit.getOfflinePlayer((UUID)playerId), amount);
    }

    @Override
    public boolean hasMultiCurrencySupport() {
        return false;
    }

    @Override
    public List<String> getCurrencies() {
        return Collections.emptyList();
    }

    @Override
    public String getDefaultCurrency() {
        return this.economy != null ? this.economy.currencyNamePlural() : "Dollars";
    }
}

