/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.economy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault2.economy.Economy;
import net.milkbowl.vault2.economy.EconomyResponse;
import org.bukkit.OfflinePlayer;
import org.texboobcat.globalMarketplace.economy.EconomyAdapter;

public class VaultUnlockedAdapter
implements EconomyAdapter {
    private final Economy economy;
    private final String pluginName = "GlobalMarketplace";
    private final String defaultCurrency;

    public VaultUnlockedAdapter(Economy economy) {
        this.economy = economy;
        this.defaultCurrency = economy != null ? economy.getDefaultCurrency("GlobalMarketplace") : null;
    }

    @Override
    public boolean isEnabled() {
        return this.economy != null && this.economy.isEnabled();
    }

    @Override
    public String getProviderName() {
        return "VaultUnlocked (" + (this.economy != null ? this.economy.getName() : "Unknown") + ")";
    }

    @Override
    public String format(double amount) {
        if (this.economy == null || this.defaultCurrency == null) {
            return String.format("%.2f", amount);
        }
        return this.economy.format("GlobalMarketplace", BigDecimal.valueOf(amount), this.defaultCurrency);
    }

    @Override
    public String format(BigDecimal amount) {
        if (this.economy == null || this.defaultCurrency == null) {
            return String.format("%.2f", amount.doubleValue());
        }
        return this.economy.format("GlobalMarketplace", amount, this.defaultCurrency);
    }

    @Override
    public double getBalance(OfflinePlayer player) {
        return this.getBalance(player.getUniqueId());
    }

    @Override
    public double getBalance(UUID playerId) {
        if (this.economy == null || this.defaultCurrency == null) {
            return 0.0;
        }
        return this.economy.balance("GlobalMarketplace", playerId, null, this.defaultCurrency).doubleValue();
    }

    @Override
    public BigDecimal getBalancePrecise(UUID playerId) {
        if (this.economy == null || this.defaultCurrency == null) {
            return BigDecimal.ZERO;
        }
        return this.economy.balance("GlobalMarketplace", playerId, null, this.defaultCurrency);
    }

    @Override
    public boolean withdraw(OfflinePlayer player, double amount) {
        return this.withdraw(player.getUniqueId(), amount);
    }

    @Override
    public boolean withdraw(UUID playerId, double amount) {
        return this.withdrawPrecise(playerId, BigDecimal.valueOf(amount));
    }

    @Override
    public boolean withdrawPrecise(UUID playerId, BigDecimal amount) {
        if (this.economy == null || this.defaultCurrency == null) {
            return false;
        }
        EconomyResponse response = this.economy.withdraw("GlobalMarketplace", playerId, amount);
        return response.transactionSuccess();
    }

    @Override
    public boolean deposit(OfflinePlayer player, double amount) {
        return this.deposit(player.getUniqueId(), amount);
    }

    @Override
    public boolean deposit(UUID playerId, double amount) {
        return this.depositPrecise(playerId, BigDecimal.valueOf(amount));
    }

    @Override
    public boolean depositPrecise(UUID playerId, BigDecimal amount) {
        if (this.economy == null || this.defaultCurrency == null) {
            return false;
        }
        EconomyResponse response = this.economy.deposit("GlobalMarketplace", playerId, amount);
        return response.transactionSuccess();
    }

    @Override
    public boolean has(OfflinePlayer player, double amount) {
        return this.has(player.getUniqueId(), amount);
    }

    @Override
    public boolean has(UUID playerId, double amount) {
        if (this.economy == null || this.defaultCurrency == null) {
            return false;
        }
        return this.economy.has("GlobalMarketplace", playerId, BigDecimal.valueOf(amount));
    }

    @Override
    public boolean hasMultiCurrencySupport() {
        return true;
    }

    @Override
    public List<String> getCurrencies() {
        if (this.economy == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.economy.currencies());
    }

    @Override
    public String getDefaultCurrency() {
        return this.defaultCurrency != null ? this.defaultCurrency : "Unknown";
    }

    public BigDecimal getBalanceInCurrency(UUID playerId, String currencyIdentifier) {
        if (this.economy == null) {
            return BigDecimal.ZERO;
        }
        return this.economy.balance("GlobalMarketplace", playerId, null, currencyIdentifier);
    }

    public boolean withdrawFromCurrency(UUID playerId, String currencyIdentifier, BigDecimal amount) {
        if (this.economy == null) {
            return false;
        }
        EconomyResponse response = this.economy.withdraw("GlobalMarketplace", playerId, null, currencyIdentifier, amount);
        return response.transactionSuccess();
    }

    public boolean depositToCurrency(UUID playerId, String currencyIdentifier, BigDecimal amount) {
        if (this.economy == null) {
            return false;
        }
        EconomyResponse response = this.economy.deposit("GlobalMarketplace", playerId, null, currencyIdentifier, amount);
        return response.transactionSuccess();
    }

    public Economy getVaultUnlockedEconomy() {
        return this.economy;
    }
}

