/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.listeners;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.service.MarketplaceService;

public class JoinListener
implements Listener {
    private static final long COOLDOWN_MS = 30000L;
    private static final ConcurrentHashMap<UUID, Long> lastAutoClaim = new ConcurrentHashMap();

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        long now = System.currentTimeMillis();
        Long last = lastAutoClaim.get(player.getUniqueId());
        if (last != null && now - last < 30000L) {
            return;
        }
        lastAutoClaim.put(player.getUniqueId(), now);
        Bukkit.getScheduler().runTaskLater((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            if (svc == null) {
                return;
            }
            if (player.getInventory().firstEmpty() == -1) {
                return;
            }
            int delivered = svc.claimDeliveries(player, 5);
            if (delivered > 0) {
                player.sendMessage("\u00a7aClaimed " + delivered + " queued item(s). Use /gmarket claim for more.");
            }
        }, 20L);
    }
}

