/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.model;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;

public class TradeSession {
    private final UUID sessionId = UUID.randomUUID();
    private final UUID player1;
    private final UUID player2;
    private final Instant createdAt;
    private final List<ItemStack> player1Items;
    private final List<ItemStack> player2Items;
    private BigDecimal player1Money;
    private BigDecimal player2Money;
    private boolean player1Ready;
    private boolean player2Ready;
    private boolean player1Confirmed;
    private boolean player2Confirmed;
    private TradeSessionStatus status;

    public TradeSession(UUID player1, UUID player2) {
        this.player1 = player1;
        this.player2 = player2;
        this.createdAt = Instant.now();
        this.player1Items = new ArrayList<ItemStack>();
        this.player2Items = new ArrayList<ItemStack>();
        this.player1Money = BigDecimal.ZERO;
        this.player2Money = BigDecimal.ZERO;
        this.player1Ready = false;
        this.player2Ready = false;
        this.player1Confirmed = false;
        this.player2Confirmed = false;
        this.status = TradeSessionStatus.ACTIVE;
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public UUID getPlayer1() {
        return this.player1;
    }

    public UUID getPlayer2() {
        return this.player2;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public List<ItemStack> getPlayer1Items() {
        return new ArrayList<ItemStack>(this.player1Items);
    }

    public List<ItemStack> getPlayer2Items() {
        return new ArrayList<ItemStack>(this.player2Items);
    }

    public BigDecimal getPlayer1Money() {
        return this.player1Money;
    }

    public BigDecimal getPlayer2Money() {
        return this.player2Money;
    }

    public boolean isPlayer1Ready() {
        return this.player1Ready;
    }

    public boolean isPlayer2Ready() {
        return this.player2Ready;
    }

    public boolean isPlayer1Confirmed() {
        return this.player1Confirmed;
    }

    public boolean isPlayer2Confirmed() {
        return this.player2Confirmed;
    }

    public TradeSessionStatus getStatus() {
        return this.status;
    }

    public void setPlayer1Money(BigDecimal amount) {
        this.player1Money = amount;
    }

    public void setPlayer2Money(BigDecimal amount) {
        this.player2Money = amount;
    }

    public void setPlayer1Ready(boolean ready) {
        this.player1Ready = ready;
    }

    public void setPlayer2Ready(boolean ready) {
        this.player2Ready = ready;
    }

    public void setPlayer1Confirmed(boolean confirmed) {
        this.player1Confirmed = confirmed;
    }

    public void setPlayer2Confirmed(boolean confirmed) {
        this.player2Confirmed = confirmed;
    }

    public void setStatus(TradeSessionStatus status) {
        this.status = status;
    }

    public void addPlayer1Item(ItemStack item) {
        if (item != null && !item.getType().isAir()) {
            this.player1Items.add(item.clone());
        }
    }

    public void addPlayer2Item(ItemStack item) {
        if (item != null && !item.getType().isAir()) {
            this.player2Items.add(item.clone());
        }
    }

    public void removePlayer1Item(int index) {
        if (index >= 0 && index < this.player1Items.size()) {
            this.player1Items.remove(index);
        }
    }

    public void removePlayer2Item(int index) {
        if (index >= 0 && index < this.player2Items.size()) {
            this.player2Items.remove(index);
        }
    }

    public void clearPlayer1Items() {
        this.player1Items.clear();
    }

    public void clearPlayer2Items() {
        this.player2Items.clear();
    }

    public boolean bothPlayersReady() {
        return this.player1Ready && this.player2Ready;
    }

    public boolean bothPlayersConfirmed() {
        return this.player1Confirmed && this.player2Confirmed;
    }

    public UUID getOtherPlayer(UUID playerId) {
        if (this.player1.equals(playerId)) {
            return this.player2;
        }
        if (this.player2.equals(playerId)) {
            return this.player1;
        }
        return null;
    }

    public boolean isPlayer1(UUID playerId) {
        return this.player1.equals(playerId);
    }

    public boolean isPlayer2(UUID playerId) {
        return this.player2.equals(playerId);
    }

    public void resetConfirmations() {
        this.player1Confirmed = false;
        this.player2Confirmed = false;
    }

    public static enum TradeSessionStatus {
        ACTIVE,
        COMPLETED,
        CANCELLED;

    }
}

