/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.repo.adapters;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.UUID;
import org.texboobcat.globalMarketplace.dao.TransactionDao;
import org.texboobcat.globalMarketplace.repo.TransactionLog;

public class JdbcTransactionLog
implements TransactionLog {
    private final TransactionDao delegate;

    public JdbcTransactionLog(TransactionDao delegate) {
        this.delegate = delegate;
    }

    @Override
    public void log(UUID txUuid, UUID listingUuid, UUID buyerUuid, UUID sellerUuid, BigDecimal amount, String type) throws SQLException {
        this.delegate.log(txUuid, listingUuid, buyerUuid, sellerUuid, amount, type);
    }

    @Override
    public void logExtended(UUID txUuid, UUID listingUuid, UUID buyerUuid, UUID sellerUuid, BigDecimal amount, String type, String metaJson) throws SQLException {
        this.delegate.logExtended(txUuid, listingUuid, buyerUuid, sellerUuid, amount, type, metaJson);
    }

    @Override
    public TransactionLog.SaleRecord latestSaleForListing(UUID listingUuid) throws SQLException {
        TransactionDao.Record r = this.delegate.latestSaleForListing(listingUuid);
        if (r == null) {
            return null;
        }
        TransactionLog.SaleRecord s = new TransactionLog.SaleRecord();
        s.txUuid = r.txUuid;
        s.listingUuid = r.listingUuid;
        s.buyerUuid = r.buyerUuid;
        s.sellerUuid = r.sellerUuid;
        s.amount = r.amount;
        s.type = r.type;
        return s;
    }
}

