/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.ui;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.ui.GuiConfig;

public class AuctionDurationMenu {
    private static final Map<UUID, AuctionSettings> playerSettings = new ConcurrentHashMap<UUID, AuctionSettings>();

    private static GuiConfig.GuiSection getConfig() {
        return GuiConfig.getInstance().getSection("auction_duration_menu");
    }

    public static String getTitle() {
        return AuctionDurationMenu.getConfig().getTitle();
    }

    public void open(Player player) {
        this.open(player, BigDecimal.valueOf(100L), 60);
    }

    public void open(Player player, BigDecimal startingPrice, int durationMinutes) {
        if (startingPrice == null || startingPrice.compareTo(BigDecimal.ZERO) < 0) {
            startingPrice = BigDecimal.valueOf(100L);
        }
        if (durationMinutes <= 0) {
            durationMinutes = 60;
        }
        playerSettings.put(player.getUniqueId(), new AuctionSettings(startingPrice, durationMinutes));
        this.openWithCurrentSettings(player);
    }

    private void openWithCurrentSettings(Player player) {
        GuiConfig.ButtonConfig priceDisplayBtn;
        GuiConfig.ButtonConfig durationDisplayBtn;
        GuiConfig.ButtonConfig confirmBtn;
        ItemStack inHand;
        GuiConfig.ButtonConfig itemDisplayBtn;
        GuiConfig.GuiSection config = AuctionDurationMenu.getConfig();
        int rows = config.getRows();
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)(rows * 9), (String)AuctionDurationMenu.getTitle());
        AuctionSettings settings = playerSettings.getOrDefault(player.getUniqueId(), new AuctionSettings(BigDecimal.valueOf(100L), 60));
        String durationStr = this.formatDuration(settings.durationMinutes);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("price", settings.price.toString());
        placeholders.put("duration", durationStr);
        GuiConfig.FillerConfig fillerCfg = config.getFiller();
        ItemStack filler = new ItemStack(fillerCfg.getMaterial());
        ItemMeta fm = filler.getItemMeta();
        if (fm != null) {
            fm.setDisplayName(fillerCfg.getName());
            filler.setItemMeta(fm);
        }
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, filler);
        }
        GuiConfig.ButtonConfig backBtn = config.getButton("back");
        if (backBtn != null && backBtn.getSlot() >= 0) {
            inv.setItem(backBtn.getSlot(), this.createButton(backBtn.getMaterial(), backBtn.getName(), backBtn.getLore(), "back"));
        }
        if ((itemDisplayBtn = config.getButton("item_display")) != null && itemDisplayBtn.getSlot() >= 0 && (inHand = player.getInventory().getItemInMainHand()) != null && inHand.getType() != Material.AIR) {
            ItemStack display = inHand.clone();
            ItemMeta dm = display.getItemMeta();
            if (dm != null) {
                String itemName = dm.hasDisplayName() ? dm.getDisplayName() : AuctionDurationMenu.prettify(display.getType().name());
                dm.setDisplayName("\u00a7e" + itemName);
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add("\u00a77Item to auction");
                lore.add("\u00a77Amount: \u00a7f" + display.getAmount());
                dm.setLore(lore);
                display.setItemMeta(dm);
            }
            inv.setItem(itemDisplayBtn.getSlot(), display);
        }
        if ((confirmBtn = config.getButton("confirm")) != null && confirmBtn.getSlot() >= 0) {
            inv.setItem(confirmBtn.getSlot(), this.createButton(confirmBtn.getMaterial(), confirmBtn.getName(placeholders), confirmBtn.getLore(placeholders), "confirm"));
        }
        if ((durationDisplayBtn = config.getButton("duration_display")) != null && durationDisplayBtn.getSlot() >= 0) {
            ItemStack durationDisplay = new ItemStack(durationDisplayBtn.getMaterial());
            ItemMeta dm = durationDisplay.getItemMeta();
            if (dm != null) {
                dm.setDisplayName(durationDisplayBtn.getName(placeholders));
                dm.setLore(durationDisplayBtn.getLore(placeholders));
                durationDisplay.setItemMeta(dm);
            }
            inv.setItem(durationDisplayBtn.getSlot(), durationDisplay);
        }
        if ((priceDisplayBtn = config.getButton("price_display")) != null && priceDisplayBtn.getSlot() >= 0) {
            ItemStack priceDisplay = new ItemStack(priceDisplayBtn.getMaterial());
            ItemMeta pm = priceDisplay.getItemMeta();
            if (pm != null) {
                pm.setDisplayName(priceDisplayBtn.getName(placeholders));
                pm.setLore(priceDisplayBtn.getLore(placeholders));
                priceDisplay.setItemMeta(pm);
            }
            inv.setItem(priceDisplayBtn.getSlot(), priceDisplay);
        }
        this.addDurationButton(inv, "adjust_duration_minus_1w");
        this.addDurationButton(inv, "adjust_duration_minus_1d");
        this.addDurationButton(inv, "adjust_duration_minus_30min");
        this.addDurationButton(inv, "adjust_duration_minus_1m");
        this.addDurationButton(inv, "adjust_duration_plus_1m");
        this.addDurationButton(inv, "adjust_duration_plus_30min");
        this.addDurationButton(inv, "adjust_duration_plus_1d");
        this.addDurationButton(inv, "adjust_duration_plus_1w");
        this.addPriceButton(inv, "adjust_price_minus_100");
        this.addPriceButton(inv, "adjust_price_minus_10");
        this.addPriceButton(inv, "adjust_price_minus_1");
        this.addPriceButton(inv, "adjust_price_plus_1");
        this.addPriceButton(inv, "adjust_price_plus_10");
        this.addPriceButton(inv, "adjust_price_plus_100");
        player.openInventory(inv);
    }

    private void addDurationButton(Inventory inv, String buttonName) {
        GuiConfig.GuiSection config = AuctionDurationMenu.getConfig();
        GuiConfig.ButtonConfig btn = config.getButton(buttonName);
        if (btn != null && btn.getSlot() >= 0) {
            inv.setItem(btn.getSlot(), this.createAdjustButton(btn.getMaterial(), btn.getName(), btn.getLore(), "adjust_duration:" + btn.getAdjustment()));
        }
    }

    private void addPriceButton(Inventory inv, String buttonName) {
        GuiConfig.GuiSection config = AuctionDurationMenu.getConfig();
        GuiConfig.ButtonConfig btn = config.getButton(buttonName);
        if (btn != null && btn.getSlot() >= 0) {
            inv.setItem(btn.getSlot(), this.createAdjustButton(btn.getMaterial(), btn.getName(), btn.getLore(), "adjust_price:" + btn.getAdjustment()));
        }
    }

    private ItemStack createButton(Material material, String name, List<String> lore, String action) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore != null) {
                meta.setLore(lore);
            }
            NamespacedKey key = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)action);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createAdjustButton(Material material, String name, List<String> lore, String action) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore != null && !lore.isEmpty()) {
                meta.setLore(lore);
            }
            NamespacedKey key = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)action);
            item.setItemMeta(meta);
        }
        return item;
    }

    public void adjustDuration(Player player, int adjustment) {
        AuctionSettings settings = playerSettings.getOrDefault(player.getUniqueId(), new AuctionSettings(BigDecimal.valueOf(100L), 60));
        int newDuration = settings.durationMinutes + adjustment;
        if (newDuration < 1) {
            newDuration = 1;
        }
        settings.durationMinutes = newDuration;
        playerSettings.put(player.getUniqueId(), settings);
        this.openWithCurrentSettings(player);
    }

    public void adjustPrice(Player player, int adjustment) {
        AuctionSettings settings = playerSettings.getOrDefault(player.getUniqueId(), new AuctionSettings(BigDecimal.valueOf(100L), 60));
        BigDecimal newPrice = settings.price.add(BigDecimal.valueOf(adjustment));
        if (newPrice.compareTo(BigDecimal.ZERO) < 0) {
            newPrice = BigDecimal.ZERO;
        }
        settings.price = newPrice;
        playerSettings.put(player.getUniqueId(), settings);
        this.openWithCurrentSettings(player);
    }

    public AuctionSettings getCurrentSettings(UUID playerId) {
        return playerSettings.get(playerId);
    }

    public void clearSettings(UUID playerId) {
        playerSettings.remove(playerId);
    }

    private String formatDuration(int minutes) {
        if (minutes < 60) {
            return minutes + " minute" + (minutes != 1 ? "s" : "");
        }
        if (minutes < 1440) {
            int hours = minutes / 60;
            int remainingMinutes = minutes % 60;
            if (remainingMinutes == 0) {
                return hours + " hour" + (hours != 1 ? "s" : "");
            }
            return hours + "h " + remainingMinutes + "m";
        }
        int days = minutes / 1440;
        int remainingHours = minutes % 1440 / 60;
        if (remainingHours == 0) {
            return days + " day" + (days != 1 ? "s" : "");
        }
        return days + "d " + remainingHours + "h";
    }

    private static String prettify(String enumName) {
        String lower = enumName.toLowerCase(Locale.ROOT).replace('_', ' ');
        String[] parts = lower.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            sb.append(Character.toUpperCase(p.charAt(0))).append(p.substring(1)).append(' ');
        }
        return sb.toString().trim();
    }

    public static class AuctionSettings {
        public BigDecimal price;
        public int durationMinutes;

        public AuctionSettings(BigDecimal price, int durationMinutes) {
            this.price = price;
            this.durationMinutes = durationMinutes;
        }
    }
}

