/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;

public class GuiConfig {
    private static final int GUI_CONFIG_VERSION = 5;
    private static GuiConfig instance;
    private YamlConfiguration config;

    private GuiConfig() {
        this.load();
    }

    public static GuiConfig getInstance() {
        if (instance == null) {
            instance = new GuiConfig();
        }
        return instance;
    }

    public void reload() {
        this.load();
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    private void load() {
        String theme = GlobalMarketplacePlugin.getInstance().getConfig().getString("ui.theme", "default");
        File guiFile = new File(GlobalMarketplacePlugin.getInstance().getDataFolder(), "gui/" + theme + ".yml");
        GlobalMarketplacePlugin.getInstance().getLogger().info("Loading GUI theme: " + theme);
        if ("default".equals(theme)) {
            try {
                this.checkAndMergeGuiConfig();
            }
            catch (Exception e) {
                GlobalMarketplacePlugin.getInstance().getLogger().warning("GUI config merge failed: " + e.getMessage());
            }
        }
        if (!guiFile.exists()) {
            GlobalMarketplacePlugin.getInstance().getLogger().warning("GUI theme file not found: gui/" + theme + ".yml, falling back to default.yml");
            guiFile = new File(GlobalMarketplacePlugin.getInstance().getDataFolder(), "gui/default.yml");
            if (!guiFile.exists()) {
                InputStream stream = GlobalMarketplacePlugin.getInstance().getResource("gui/default.yml");
                if (stream != null) {
                    this.config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                    GlobalMarketplacePlugin.getInstance().getLogger().info("Loaded GUI configuration from plugin resources");
                } else {
                    GlobalMarketplacePlugin.getInstance().getLogger().warning("Could not load gui/default.yml - using empty config");
                    this.config = new YamlConfiguration();
                }
                return;
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)guiFile);
        GlobalMarketplacePlugin.getInstance().getLogger().info("Loaded GUI configuration from: " + guiFile.getName());
    }

    public GuiSection getSection(String name) {
        ConfigurationSection section = this.config.getConfigurationSection(name);
        if (section == null) {
            return new GuiSection((ConfigurationSection)new YamlConfiguration());
        }
        return new GuiSection(section);
    }

    public String getCurrencySymbol() {
        String symbol = this.config.getString("currency.symbol", "$");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)symbol);
    }

    public String getTooltip(String path) {
        String value = this.config.getString("listing_tooltip." + path, "");
        return ChatColor.translateAlternateColorCodes((char)'&', (String)value);
    }

    public String getTooltip(String path, String defaultValue) {
        String value = this.config.getString("listing_tooltip." + path, defaultValue);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)value);
    }

    private void checkAndMergeGuiConfig() throws Exception {
        File guiFile;
        File guiDir = new File(GlobalMarketplacePlugin.getInstance().getDataFolder(), "gui");
        if (!guiDir.exists()) {
            guiDir.mkdirs();
        }
        if (!(guiFile = new File(guiDir, "default.yml")).exists()) {
            return;
        }
        YamlConfiguration current = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)new FileInputStream(guiFile), StandardCharsets.UTF_8));
        int curVer = current.getInt("gui-config-version", 0);
        InputStream defStream = GlobalMarketplacePlugin.getInstance().getResource("gui/default.yml");
        if (defStream == null) {
            return;
        }
        YamlConfiguration defCfg = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defStream, StandardCharsets.UTF_8));
        int defVer = defCfg.getInt("gui-config-version", 5);
        if (curVer >= defVer) {
            return;
        }
        this.backupGuiConfig(guiFile, curVer);
        this.mergeSections(current, defCfg, "");
        current.set("gui-config-version", (Object)defVer);
        current.save(guiFile);
        GlobalMarketplacePlugin.getInstance().getLogger().info("GUI config updated from version " + curVer + " to " + defVer + ". A backup was created.");
    }

    private void mergeSections(YamlConfiguration target, YamlConfiguration defaults, String pathPrefix) {
        YamlConfiguration defSec;
        Object object = defSec = pathPrefix.isEmpty() ? defaults : defaults.getConfigurationSection(pathPrefix);
        if (defSec == null) {
            return;
        }
        for (String key : defSec.getKeys(false)) {
            Object full = pathPrefix.isEmpty() ? key : pathPrefix + "." + key;
            Object defVal = defaults.get((String)full);
            if (defVal instanceof ConfigurationSection) {
                if (target.get((String)full) == null) {
                    target.createSection((String)full);
                }
                this.mergeSections(target, defaults, (String)full);
                continue;
            }
            if (target.isSet((String)full)) continue;
            target.set((String)full, defVal);
        }
    }

    private void backupGuiConfig(File guiFile, int curVersion) {
        try {
            String stamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
            File backupDir = new File(GlobalMarketplacePlugin.getInstance().getDataFolder(), "gui/backup");
            if (!backupDir.exists()) {
                backupDir.mkdirs();
            }
            File backup = new File(backupDir, "default-v" + curVersion + "-" + stamp + ".yml");
            Files.copy(guiFile.toPath(), backup.toPath(), new CopyOption[0]);
            GlobalMarketplacePlugin.getInstance().getLogger().info("GUI config backed up to: " + backup.getName());
        }
        catch (Exception e) {
            GlobalMarketplacePlugin.getInstance().getLogger().warning("Failed to backup GUI config: " + e.getMessage());
        }
    }

    public static class GuiSection {
        private final ConfigurationSection section;

        public GuiSection(ConfigurationSection section) {
            this.section = section;
        }

        public String getTitle() {
            return this.colorize(this.section.getString("title", "Menu"));
        }

        public String getTitlePrefix() {
            return this.colorize(this.section.getString("title_prefix", ""));
        }

        public int getRows() {
            return this.section.getInt("rows", 6);
        }

        public GuiSection getSection(String name) {
            ConfigurationSection nested = this.section.getConfigurationSection(name);
            if (nested == null) {
                return new GuiSection((ConfigurationSection)new YamlConfiguration());
            }
            return new GuiSection(nested);
        }

        public FillerConfig getFiller() {
            ConfigurationSection fillerSec = this.section.getConfigurationSection("filler");
            if (fillerSec == null) {
                return new FillerConfig(Material.GRAY_STAINED_GLASS_PANE, " ");
            }
            Material material = this.getMaterial(fillerSec.getString("material", "GRAY_STAINED_GLASS_PANE"));
            String name = this.colorize(fillerSec.getString("name", " "));
            return new FillerConfig(material, name);
        }

        public ButtonConfig getButton(String buttonName) {
            ConfigurationSection buttonSec = this.section.getConfigurationSection("buttons." + buttonName);
            if (buttonSec == null && (buttonSec = this.section.getConfigurationSection(buttonName)) == null) {
                return null;
            }
            int slot = buttonSec.getInt("slot", -1);
            Material material = this.getMaterial(buttonSec.getString("material", "STONE"));
            String name = this.colorize(buttonSec.getString("name", ""));
            ArrayList<String> lore = new ArrayList<String>();
            if (buttonSec.isList("lore")) {
                for (String line : buttonSec.getStringList("lore")) {
                    lore.add(this.colorize(line));
                }
            }
            int adjustment = buttonSec.getInt("adjustment", 0);
            boolean enchanted = buttonSec.getBoolean("enchanted", false);
            return new ButtonConfig(slot, material, name, lore, adjustment, enchanted);
        }

        public Map<String, ButtonConfig> getAllButtons() {
            HashMap<String, ButtonConfig> buttons = new HashMap<String, ButtonConfig>();
            ConfigurationSection buttonsSec = this.section.getConfigurationSection("buttons");
            if (buttonsSec != null) {
                for (String key : buttonsSec.getKeys(false)) {
                    ButtonConfig button = this.getButton(key);
                    if (button == null) continue;
                    buttons.put(key, button);
                }
            }
            return buttons;
        }

        private Material getMaterial(String name) {
            try {
                return Material.valueOf((String)name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                GlobalMarketplacePlugin.getInstance().getLogger().warning("Invalid material: " + name + ", using STONE");
                return Material.STONE;
            }
        }

        private String colorize(String text) {
            if (text == null) {
                return "";
            }
            return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
        }
    }

    public static class ButtonConfig {
        private final int slot;
        private final Material material;
        private final String name;
        private final List<String> lore;
        private final int adjustment;
        private final boolean enchanted;

        public ButtonConfig(int slot, Material material, String name, List<String> lore, int adjustment) {
            this(slot, material, name, lore, adjustment, false);
        }

        public ButtonConfig(int slot, Material material, String name, List<String> lore, int adjustment, boolean enchanted) {
            this.slot = slot;
            this.material = material;
            this.name = name;
            this.lore = lore;
            this.adjustment = adjustment;
            this.enchanted = enchanted;
        }

        public int getSlot() {
            return this.slot;
        }

        public Material getMaterial() {
            return this.material;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getLore() {
            return this.lore;
        }

        public int getAdjustment() {
            return this.adjustment;
        }

        public boolean isEnchanted() {
            return this.enchanted;
        }

        public List<String> getLore(Map<String, String> placeholders) {
            ArrayList<String> result = new ArrayList<String>();
            Iterator<String> iterator = this.lore.iterator();
            while (iterator.hasNext()) {
                String line;
                String replaced = line = iterator.next();
                for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                    replaced = replaced.replace("${" + entry.getKey() + "}", entry.getValue());
                }
                result.add(replaced);
            }
            return result;
        }

        public String getName(Map<String, String> placeholders) {
            String result = this.name;
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                result = result.replace("${" + entry.getKey() + "}", entry.getValue());
            }
            return result;
        }
    }

    public static class FillerConfig {
        private final Material material;
        private final String name;

        public FillerConfig(Material material, String name) {
            this.material = material;
            this.name = name;
        }

        public Material getMaterial() {
            return this.material;
        }

        public String getName() {
            return this.name;
        }
    }
}

