/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.dao;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.texboobcat.globalMarketplace.storage.DatabaseManager;

public class BalanceDao {
    private final DatabaseManager db;

    public BalanceDao(DatabaseManager db) {
        this.db = db;
    }

    public void addPending(UUID player, BigDecimal amount) throws SQLException {
        String upsert = "INSERT INTO gm_balances (player_uuid, pending) VALUES (?, ?) ON DUPLICATE KEY UPDATE pending = pending + VALUES(pending)";
        try (Connection c = this.db.getConnection();
             PreparedStatement ps = c.prepareStatement(upsert);){
            ps.setString(1, player.toString());
            ps.setBigDecimal(2, amount);
            ps.executeUpdate();
        }
    }

    /*
     * Exception decompiling
     */
    public BigDecimal getPending(UUID player) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BigDecimal tryDeductPending(UUID player, BigDecimal amount) throws SQLException {
        try (Connection c = this.db.getConnection();){
            BigDecimal toDeduct;
            Object rs;
            boolean oldAuto = c.getAutoCommit();
            c.setAutoCommit(false);
            try {
                BigDecimal pending = BigDecimal.ZERO;
                String sel = "SELECT pending FROM gm_balances WHERE player_uuid = ? FOR UPDATE";
                try (Object ps = c.prepareStatement(sel);){
                    ps.setString(1, player.toString());
                    rs = ps.executeQuery();
                    try {
                        if (rs.next()) {
                            pending = rs.getBigDecimal(1);
                        }
                        if (pending == null) {
                            pending = BigDecimal.ZERO;
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                if (pending.compareTo(BigDecimal.ZERO) <= 0) {
                    c.rollback();
                    c.setAutoCommit(oldAuto);
                    ps = BigDecimal.ZERO;
                    return ps;
                }
                BigDecimal bigDecimal = toDeduct = amount == null || amount.compareTo(BigDecimal.ZERO) <= 0 || amount.compareTo(pending) > 0 ? pending : amount;
            }
            catch (SQLException ex) {
                c.rollback();
                c.setAutoCommit(oldAuto);
                throw ex;
            }
            if (toDeduct.compareTo(BigDecimal.ZERO) <= 0) {
                c.rollback();
                c.setAutoCommit(oldAuto);
                rs = BigDecimal.ZERO;
                return rs;
            }
            String upd = "UPDATE gm_balances SET pending = pending - ? WHERE player_uuid = ?";
            try (PreparedStatement ps = c.prepareStatement(upd);){
                ps.setBigDecimal(1, toDeduct);
                ps.setString(2, player.toString());
                ps.executeUpdate();
            }
            c.commit();
            c.setAutoCommit(oldAuto);
            BigDecimal bigDecimal = toDeduct;
            return bigDecimal;
        }
    }
}

