/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.integrations;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.util.ItemSerializer;

public class DiscordWebhookService {
    private final List<Webhook> webhooks;
    private final ThreadPoolExecutor pool;
    private final Map<String, Long> cooldowns = new ConcurrentHashMap<String, Long>();

    public DiscordWebhookService(List<Webhook> webhooks) {
        this.webhooks = webhooks != null ? webhooks : Collections.emptyList();
        FileConfiguration cfg = GlobalMarketplacePlugin.getInstance().getConfig();
        int threads = Math.max(1, cfg.getInt("discord.pool.size", 2));
        int queueCap = Math.max(10, cfg.getInt("discord.pool.queue", 200));
        this.pool = new ThreadPoolExecutor(threads, threads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueCap), new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    public void shutdown() {
        this.pool.shutdownNow();
    }

    public void send(EventType type, Listing listing, UUID actorUuid, BigDecimal amount) {
        if (this.webhooks.isEmpty() || listing == null) {
            return;
        }
        String content = this.buildMessageWithTemplates(type, listing, actorUuid, amount);
        String imageUrl = this.resolveImageUrl(listing);
        String embedTitle = this.resolveEmbedTitle(type, listing, actorUuid, amount);
        if (content == null || content.isEmpty()) {
            return;
        }
        for (Webhook wh : this.webhooks) {
            if (!wh.isEnabled(type) || this.isOnCooldown(type, listing, wh)) continue;
            String mentions = wh.mentions != null && !wh.mentions.isEmpty() ? String.join((CharSequence)" ", wh.mentions) : null;
            String payload = this.toJsonPayload(content, wh.username, wh.avatarUrl, imageUrl, embedTitle, type, listing, actorUuid, amount, mentions, wh);
            this.pool.submit(() -> this.post(wh, payload));
        }
    }

    /*
     * Exception decompiling
     */
    private void post(Webhook wh, String payload) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String toJsonPayload(String content, String username, String avatarUrl, String imageUrl, String embedTitle, EventType type, Listing listing, UUID actorUuid, BigDecimal amount, String mentionsPrefix, Webhook wh) {
        String contentOut;
        boolean embedEnabled = wh != null && wh.formatEmbed != null ? wh.formatEmbed.booleanValue() : GlobalMarketplacePlugin.getInstance().getConfig().getBoolean("discord.format.embed", true);
        boolean contentEnabled = wh != null && wh.formatContent != null ? wh.formatContent.booleanValue() : GlobalMarketplacePlugin.getInstance().getConfig().getBoolean("discord.format.content", true);
        int color = this.lookupColor(type, wh);
        String timestamp = Instant.now().toString();
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        String string = contentEnabled ? content : (contentOut = mentionsPrefix != null ? mentionsPrefix : "");
        if (mentionsPrefix != null && (contentOut == null || contentOut.isEmpty())) {
            contentOut = mentionsPrefix;
        }
        if (mentionsPrefix != null && contentEnabled) {
            contentOut = (mentionsPrefix + "\n" + (content != null ? content : "")).trim();
        }
        sb.append("\"content\":").append(this.quote(contentOut != null ? contentOut : ""));
        if (username != null && !username.isEmpty()) {
            sb.append(',').append("\"username\":").append(this.quote(username));
        }
        if (avatarUrl != null && !avatarUrl.isEmpty()) {
            sb.append(',').append("\"avatar_url\":").append(this.quote(avatarUrl));
        }
        this.appendAllowedMentions(sb);
        if (embedEnabled) {
            String footer;
            List<String> fields;
            String safeTitle;
            sb.append(',').append("\"embeds\":[{");
            String string2 = safeTitle = embedTitle != null ? this.truncate(embedTitle, 256) : null;
            if (safeTitle != null && !safeTitle.isEmpty()) {
                sb.append("\"title\":").append(this.quote(safeTitle)).append(',');
            }
            String safeDesc = this.truncate(content != null ? content : "", 4096);
            sb.append("\"description\":").append(this.quote(safeDesc));
            if (color != -1) {
                sb.append(',').append("\"color\":").append(String.valueOf(color));
            }
            sb.append(',').append("\"timestamp\":").append(this.quote(timestamp));
            if (imageUrl != null && !imageUrl.isEmpty()) {
                sb.append(',').append("\"thumbnail\":{\"url\":").append(this.quote(imageUrl)).append('}');
            }
            if (!(fields = this.buildEmbedFields(type, listing, actorUuid, amount)).isEmpty()) {
                sb.append(',').append("\"fields\":[");
                int max = Math.min(25, fields.size());
                for (int i = 0; i < max; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(fields.get(i));
                }
                sb.append(']');
            }
            if (!(footer = GlobalMarketplacePlugin.getInstance().getConfig().getString("discord.footer", "").trim()).isEmpty()) {
                sb.append(',').append("\"footer\":{\"text\":").append(this.quote(footer)).append('}');
            }
            sb.append("}]");
        }
        sb.append('}');
        return sb.toString();
    }

    private String quote(String s) {
        String esc = s.replace("\\", "\\\\").replace("\"", "\\\"");
        return "\"" + esc + "\"";
    }

    private String truncate(String s, int max) {
        if (s == null) {
            return null;
        }
        if (s.length() <= max) {
            return s;
        }
        if (max <= 3) {
            return s.substring(0, Math.max(0, max));
        }
        return s.substring(0, max - 3) + "...";
    }

    private String readBody(HttpURLConnection conn) {
        String string;
        block10: {
            InputStream is;
            InputStream inputStream = is = conn.getResponseCode() >= 200 && conn.getResponseCode() < 300 ? conn.getInputStream() : conn.getErrorStream();
            if (is == null) {
                return "";
            }
            InputStream inputStream2 = is;
            try {
                int r;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((r = is.read(buf)) != -1) {
                    bos.write(buf, 0, r);
                }
                string = bos.toString(StandardCharsets.UTF_8);
                if (inputStream2 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return "";
                }
            }
            inputStream2.close();
        }
        return string;
    }

    private void appendAllowedMentions(StringBuilder sb) {
        try {
            int i;
            boolean has;
            FileConfiguration cfg = GlobalMarketplacePlugin.getInstance().getConfig();
            List parse = cfg.getStringList("discord.allowed_mentions.parse");
            List roles = cfg.getStringList("discord.allowed_mentions.roles");
            List users = cfg.getStringList("discord.allowed_mentions.users");
            boolean bl = has = parse != null && !parse.isEmpty() || roles != null && !roles.isEmpty() || users != null && !users.isEmpty();
            if (!has) {
                return;
            }
            sb.append(',').append("\"allowed_mentions\":{");
            boolean wrote = false;
            if (parse != null && !parse.isEmpty()) {
                sb.append("\"parse\":[");
                for (i = 0; i < parse.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(this.quote(String.valueOf(parse.get(i))));
                }
                sb.append(']');
                wrote = true;
            }
            if (roles != null && !roles.isEmpty()) {
                if (wrote) {
                    sb.append(',');
                }
                sb.append("\"roles\":[");
                for (i = 0; i < roles.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(this.quote(String.valueOf(roles.get(i))));
                }
                sb.append(']');
                wrote = true;
            }
            if (users != null && !users.isEmpty()) {
                if (wrote) {
                    sb.append(',');
                }
                sb.append("\"users\":[");
                for (i = 0; i < users.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(this.quote(String.valueOf(users.get(i))));
                }
                sb.append(']');
            }
            sb.append('}');
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String buildMessage(EventType type, Listing l, UUID actorUuid, BigDecimal amount) {
        String itemName = this.resolveItemName(l);
        String seller = this.nameOf(l.getSellerUuid());
        String buyer = actorUuid != null ? this.nameOf(actorUuid) : null;
        String id = l.getUuid().toString().substring(0, 8);
        String price = (amount != null ? amount : l.getPrice()) != null ? (amount != null ? amount : l.getPrice()).toPlainString() : "";
        StringBuilder sb = new StringBuilder();
        switch (type.ordinal()) {
            case 0: {
                sb.append("\ud83c\udd95 New Fixed Listing: ").append(itemName).append(" for $").append(price).append(" by ").append(seller).append(" (ID ").append(id).append(")");
                break;
            }
            case 1: {
                sb.append("\ud83c\udd95 New Auction: ").append(itemName).append(" starting at $").append(price).append(" by ").append(seller).append(this.expirySuffix(l)).append(" (ID ").append(id).append(")");
                break;
            }
            case 2: {
                sb.append("\ud83d\udcc8 Bid Placed: ").append(itemName).append(" $").append(price).append(" by ").append(buyer).append(" (Seller ").append(seller).append(") ").append("(ID ").append(id).append(")");
                break;
            }
            case 3: {
                sb.append("\u2705 Sold (Fixed): ").append(itemName).append(" for $").append(price).append(" to ").append(buyer).append(" (Seller ").append(seller).append(") ").append("(ID ").append(id).append(")");
                break;
            }
            case 4: {
                sb.append("\ud83e\udd1d Sold (Direct): ").append(itemName).append(" for $").append(price).append(" to ").append(buyer).append(" (Seller ").append(seller).append(") ").append("(ID ").append(id).append(")");
                break;
            }
            case 5: {
                sb.append("\ud83c\udfc6 Auction Won: ").append(itemName).append(" for $").append(price).append(" by ").append(buyer).append(" (Seller ").append(seller).append(") ").append("(ID ").append(id).append(")");
                break;
            }
            case 6: {
                sb.append("\u231b Auction Expired: ").append(itemName).append(" (Seller ").append(seller).append(") ").append("(ID ").append(id).append(")");
            }
        }
        return sb.toString();
    }

    private String buildMessageWithTemplates(EventType type, Listing l, UUID actorUuid, BigDecimal amount) {
        String template = null;
        try {
            String key = "discord.templates." + type.name();
            template = GlobalMarketplacePlugin.getInstance().getConfig().getString(key);
        }
        catch (Throwable key) {
            // empty catch block
        }
        if (template == null || template.isEmpty()) {
            return this.buildMessage(type, l, actorUuid, amount);
        }
        String item = this.resolveItemName(l);
        String seller = this.nameOf(l.getSellerUuid());
        String buyer = actorUuid != null ? this.nameOf(actorUuid) : "";
        String id = l.getUuid().toString().substring(0, 8);
        String price = (amount != null ? amount : l.getPrice()) != null ? (amount != null ? amount : l.getPrice()).toPlainString() : "";
        String endsIn = this.endsInString(l);
        return template.replace("{item}", item).replace("{seller}", seller).replace("{buyer}", buyer).replace("{id}", id).replace("{price}", price).replace("{ends_in}", endsIn);
    }

    private String buildEmbedTitle(EventType type, Listing l) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "New Fixed Listing";
            case 1 -> "New Auction";
            case 2 -> "Bid Placed";
            case 3 -> "Sold (Fixed)";
            case 4 -> "Sold (Direct)";
            case 5 -> "Auction Won";
            case 6 -> "Auction Expired";
        };
    }

    private String resolveEmbedTitle(EventType type, Listing l, UUID actorUuid, BigDecimal amount) {
        String key = "discord.titles." + type.name();
        String t = null;
        try {
            t = GlobalMarketplacePlugin.getInstance().getConfig().getString(key);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (t == null || t.isEmpty()) {
            return this.buildEmbedTitle(type, l);
        }
        String item = this.resolveItemName(l);
        String seller = this.nameOf(l.getSellerUuid());
        String buyer = actorUuid != null ? this.nameOf(actorUuid) : "";
        String id = l.getUuid().toString().substring(0, 8);
        String price = (amount != null ? amount : l.getPrice()) != null ? (amount != null ? amount : l.getPrice()).toPlainString() : "";
        String endsIn = this.endsInString(l);
        return t.replace("{item}", item).replace("{seller}", seller).replace("{buyer}", buyer).replace("{id}", id).replace("{price}", price).replace("{ends_in}", endsIn);
    }

    private String endsInString(Listing l) {
        Instant ex = l.getExpiresAt();
        if (ex == null) {
            return "";
        }
        long secs = Math.max(0L, ex.getEpochSecond() - Instant.now().getEpochSecond());
        long h = secs / 3600L;
        long m = secs % 3600L / 60L;
        String s = (String)(h > 0L ? h + "h " : "") + (String)(m > 0L ? m + "m" : "");
        return s.trim();
    }

    private String expirySuffix(Listing l) {
        String s = this.endsInString(l);
        if (s == null || s.isEmpty()) {
            return "";
        }
        return " ending in " + s;
    }

    private String resolveItemName(Listing l) {
        try {
            ItemStack stack = ItemSerializer.fromBase64(l.getItemSerialized());
            if (stack == null || stack.getType() == Material.AIR) {
                return "Unknown Item";
            }
            ItemMeta meta = stack.getItemMeta();
            if (meta != null && meta.hasDisplayName()) {
                return meta.getDisplayName();
            }
            String n = stack.getType().name().toLowerCase(Locale.ROOT).replace('_', ' ');
            String[] parts = n.split(" ");
            StringBuilder sb = new StringBuilder();
            for (String p : parts) {
                if (p.isEmpty()) continue;
                sb.append(Character.toUpperCase(p.charAt(0))).append(p.substring(1)).append(' ');
            }
            return sb.toString().trim();
        }
        catch (Exception e) {
            return "Unknown Item";
        }
    }

    private String resolveImageUrl(Listing l) {
        try {
            String stripped;
            String folder;
            String mat;
            String base;
            FileConfiguration cfg;
            block27: {
                cfg = GlobalMarketplacePlugin.getInstance().getConfig();
                boolean enabled = cfg.getBoolean("discord.images.enabled", cfg.getBoolean("geyser.images.enabled", false));
                if (!enabled) {
                    return null;
                }
                base = cfg.getString("discord.images.base-url", cfg.getString("geyser.images.base-url", ""));
                mat = null;
                folder = "item";
                try {
                    Material t;
                    ItemStack is = ItemSerializer.fromBase64(l.getItemSerialized());
                    if (is == null || (t = is.getType()) == null) break block27;
                    mat = t.name();
                    try {
                        if (!t.isItem()) {
                            folder = "block";
                        }
                    }
                    catch (Throwable throwable) {}
                }
                catch (Throwable is) {
                    // empty catch block
                }
            }
            if (mat == null) {
                return null;
            }
            String key = mat.toLowerCase(Locale.ROOT).replace(' ', '_');
            List<String> templates = cfg.getStringList("discord.images.templates");
            if (templates == null || templates.isEmpty()) {
                templates = cfg.getStringList("geyser.images.templates");
            }
            if (templates == null || templates.isEmpty()) {
                templates = Arrays.asList("https://raw.githubusercontent.com/PrismarineJS/minecraft-assets/1.21.1/assets/minecraft/textures/{folder}/{material}.png", "https://raw.githubusercontent.com/PrismarineJS/minecraft-assets/master/assets/minecraft/textures/{folder}/{material}.png", "https://assets.mcasset.cloud/1.21.1/assets/minecraft/textures/{folder}/{material}.png");
            }
            boolean probe = cfg.getBoolean("discord.images.probe", cfg.getBoolean("geyser.images.probe", false));
            List<String> suffixes = cfg.getStringList("discord.images.fallback-suffixes");
            if (suffixes == null || suffixes.isEmpty()) {
                suffixes = cfg.getStringList("geyser.images.fallback-suffixes");
            }
            if (suffixes == null || suffixes.isEmpty()) {
                suffixes = Arrays.asList("", "_top", "_side", "_front");
            }
            HashMap<String, String> aliases = new HashMap<String, String>();
            try {
                ConfigurationSection sec = cfg.getConfigurationSection("discord.images.aliases");
                if (sec == null) {
                    sec = cfg.getConfigurationSection("geyser.images.aliases");
                }
                if (sec != null) {
                    for (String k : sec.getKeys(false)) {
                        Object v = sec.get(k);
                        if (v == null) continue;
                        aliases.put(k.toLowerCase(Locale.ROOT), v.toString());
                    }
                }
            }
            catch (Throwable sec) {
                // empty catch block
            }
            LinkedHashSet<Object> keys = new LinkedHashSet<Object>();
            String alias = (String)aliases.get(key);
            if (alias != null && !alias.isEmpty()) {
                keys.add(alias);
            }
            keys.add(key);
            String wood = DiscordWebhookService.woodBase(key);
            if (wood != null) {
                keys.add(wood + "_planks");
            }
            if ((stripped = DiscordWebhookService.stripCommonVariant(key)) != null) {
                keys.add(stripped);
            }
            ArrayList<CallSite> candidates = new ArrayList<CallSite>();
            for (String string : keys) {
                for (String string2 : suffixes) {
                    candidates.add((CallSite)((Object)(string + string2)));
                }
            }
            if (base != null && !base.isEmpty()) {
                for (String string : candidates) {
                    String url = base.replace("{material}", string).replace("{folder}", folder);
                    if (probe && !DiscordWebhookService.urlExists(url)) continue;
                    return url;
                }
                return null;
            }
            for (String string : templates) {
                if (string == null || string.isEmpty()) continue;
                for (String string3 : candidates) {
                    String url = string.replace("{material}", string3).replace("{folder}", folder);
                    if (probe && !DiscordWebhookService.urlExists(url)) continue;
                    return url;
                }
            }
            return null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean urlExists(String urlStr) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            conn.setConnectTimeout(1500);
            conn.setReadTimeout(1500);
            int code = conn.getResponseCode();
            boolean bl = code >= 200 && code < 300;
            return bl;
        }
        catch (Throwable ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static String woodBase(String key) {
        String[] woods;
        for (String w : woods = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry", "bamboo", "crimson", "warped"}) {
            String tail;
            if (!key.startsWith(w + "_") || !(tail = key.substring(w.length() + 1)).matches("(stairs|slab|fence(_gate)?|door|trapdoor|button|pressure_plate|sign|hanging_sign)")) continue;
            return w;
        }
        return null;
    }

    private static String stripCommonVariant(String key) {
        String[] vars;
        for (String v : vars = new String[]{"_stairs", "_slab", "_wall", "_pane", "_door", "_trapdoor", "_fence_gate", "_fence", "_pressure_plate", "_button", "_carpet", "_banner", "_candle", "_sign", "_hanging_sign"}) {
            if (!key.endsWith(v)) continue;
            return key.substring(0, key.length() - v.length());
        }
        return null;
    }

    private String nameOf(UUID uuid) {
        try {
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)uuid);
            if (op != null && op.getName() != null) {
                return op.getName();
            }
        }
        catch (Throwable op) {
            // empty catch block
        }
        String u = uuid != null ? uuid.toString() : "?";
        return u.substring(0, Math.min(8, u.length()));
    }

    private int lookupColor(EventType type) {
        return this.lookupColor(type, null);
    }

    private int lookupColor(EventType type, Webhook wh) {
        try {
            Integer c;
            if (wh != null && wh.colors != null && (c = wh.colors.get((Object)type)) != null) {
                return c;
            }
            String key = "discord.colors." + type.name();
            String v = GlobalMarketplacePlugin.getInstance().getConfig().getString(key, "");
            if (v == null || v.isEmpty()) {
                return -1;
            }
            if ((v = v.trim()).startsWith("#")) {
                v = v.substring(1);
            }
            int rgb = v.matches("[0-9A-Fa-f]{6}") ? Integer.parseInt(v, 16) : Integer.parseInt(v);
            return rgb;
        }
        catch (Throwable ignored) {
            return -1;
        }
    }

    private boolean isOnCooldown(EventType type, Listing l) {
        return this.isOnCooldown(type, l, null);
    }

    private boolean isOnCooldown(EventType type, Listing l, Webhook wh) {
        try {
            String v = null;
            if (wh != null && wh.cooldowns != null) {
                v = wh.cooldowns.get((Object)type);
            }
            if (v == null || v.isEmpty()) {
                String key = "discord.cooldowns." + type.name();
                v = GlobalMarketplacePlugin.getInstance().getConfig().getString(key, "");
            }
            if (v == null || v.isEmpty()) {
                return false;
            }
            long interval = this.parseDurationMs(v.trim());
            if (interval <= 0L) {
                return false;
            }
            String ck = (wh != null ? wh.name : "*") + ":" + type.name() + ":" + String.valueOf(l != null ? l.getUuid() : "");
            long now = System.currentTimeMillis();
            Long last = this.cooldowns.get(ck);
            if (last != null && now - last < interval) {
                return true;
            }
            this.cooldowns.put(ck, now);
            return false;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private long parseDurationMs(String s) {
        try {
            if (s.endsWith("ms")) {
                return Long.parseLong(s.substring(0, s.length() - 2));
            }
            if (s.endsWith("s")) {
                return Long.parseLong(s.substring(0, s.length() - 1)) * 1000L;
            }
            if (s.endsWith("m")) {
                return Long.parseLong(s.substring(0, s.length() - 1)) * 60000L;
            }
            if (s.endsWith("h")) {
                return Long.parseLong(s.substring(0, s.length() - 1)) * 3600000L;
            }
            return Long.parseLong(s);
        }
        catch (Throwable ignored) {
            return 0L;
        }
    }

    private List<String> buildEmbedFields(EventType type, Listing l, UUID actorUuid, BigDecimal amount) {
        ArrayList<String> out = new ArrayList<String>();
        try {
            String item = this.resolveItemName(l);
            String id = l.getUuid().toString().substring(0, 8);
            String seller = this.nameOf(l.getSellerUuid());
            String buyer = actorUuid != null ? this.nameOf(actorUuid) : "";
            String endsIn = this.endsInString(l);
            String price = (amount != null ? amount : l.getPrice()) != null ? (amount != null ? amount : l.getPrice()).toPlainString() : "";
            String typeStr = l.getType().name();
            out.add(this.jsonField("Item", item, false));
            if (price != null && !price.isEmpty()) {
                out.add(this.jsonField(type == EventType.BID_PLACED ? "Bid" : "Price", "$" + price, true));
            }
            out.add(this.jsonField("Seller", seller, true));
            if (buyer != null && !buyer.isEmpty()) {
                out.add(this.jsonField("Buyer", buyer, true));
            }
            if (endsIn != null && !endsIn.isEmpty()) {
                out.add(this.jsonField("Ends In", endsIn, true));
            }
            out.add(this.jsonField("Type", typeStr, true));
            out.add(this.jsonField("ID", id, true));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return out;
    }

    private String jsonField(String name, String value, boolean inline) {
        String n = this.truncate(name, 256);
        String v = this.truncate(value, 1024);
        StringBuilder b = new StringBuilder();
        b.append('{').append("\"name\":").append(this.quote(n)).append(',').append("\"value\":").append(this.quote(v)).append(',').append("\"inline\":").append(inline ? "true" : "false").append('}');
        return b.toString();
    }

    public static enum EventType {
        NEW_FIXED,
        NEW_AUCTION,
        BID_PLACED,
        FIXED_SOLD,
        DIRECT_SOLD,
        AUCTION_SOLD,
        AUCTION_EXPIRED;

    }

    public static class Webhook {
        public final String name;
        public final String url;
        public final Set<EventType> enabled;
        public final String username;
        public final String avatarUrl;
        public final List<String> mentions;
        public final String threadId;
        public final Boolean formatEmbed;
        public final Boolean formatContent;
        public final Map<EventType, Integer> colors;
        public final Map<EventType, String> cooldowns;

        public Webhook(String name, String url, Set<EventType> enabled, String username, String avatarUrl, List<String> mentions, String threadId) {
            this.name = name;
            this.url = url;
            this.enabled = enabled;
            this.username = username;
            this.avatarUrl = avatarUrl;
            this.mentions = mentions != null ? mentions : Collections.emptyList();
            this.threadId = threadId;
            this.formatEmbed = null;
            this.formatContent = null;
            this.colors = null;
            this.cooldowns = null;
        }

        public Webhook(String name, String url, Set<EventType> enabled, String username, String avatarUrl, List<String> mentions, String threadId, Boolean formatEmbed, Boolean formatContent, Map<EventType, Integer> colors, Map<EventType, String> cooldowns) {
            this.name = name;
            this.url = url;
            this.enabled = enabled;
            this.username = username;
            this.avatarUrl = avatarUrl;
            this.mentions = mentions != null ? mentions : Collections.emptyList();
            this.threadId = threadId;
            this.formatEmbed = formatEmbed;
            this.formatContent = formatContent;
            this.colors = colors;
            this.cooldowns = cooldowns;
        }

        public boolean isEnabled(EventType type) {
            return this.enabled == null || this.enabled.isEmpty() || this.enabled.contains((Object)type);
        }
    }
}

