/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.storage;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.texboobcat.globalMarketplace.storage.DatabaseManager;

public class MigrationRunner {
    public static void runMigrations(DatabaseManager db) throws SQLException {
        try (Connection conn = db.getConnection();
             Statement st = conn.createStatement();){
            st.executeUpdate("CREATE TABLE IF NOT EXISTS gm_listings (id BIGINT PRIMARY KEY AUTO_INCREMENT,uuid CHAR(36) NOT NULL UNIQUE,seller_uuid CHAR(36) NOT NULL,item LONGTEXT NOT NULL,type ENUM('FIXED','AUCTION','DIRECT') NOT NULL,price DECIMAL(19,2) NOT NULL,current_bid DECIMAL(19,2) NULL,bidder_uuid CHAR(36) NULL,created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,expires_at TIMESTAMP NULL,status ENUM('ACTIVE','SOLD','CANCELLED','EXPIRED') NOT NULL DEFAULT 'ACTIVE') ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
            st.executeUpdate("CREATE TABLE IF NOT EXISTS gm_balances (player_uuid CHAR(36) PRIMARY KEY,pending DECIMAL(19,2) NOT NULL DEFAULT 0) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
            st.executeUpdate("CREATE TABLE IF NOT EXISTS gm_transactions (id BIGINT PRIMARY KEY AUTO_INCREMENT,tx_uuid CHAR(36) NOT NULL UNIQUE,listing_uuid CHAR(36) NOT NULL,buyer_uuid CHAR(36) NULL,seller_uuid CHAR(36) NULL,amount DECIMAL(19,2) NOT NULL,type ENUM('BUY','DIRECT_BUY','AUCTION_SELL','BID','REFUND','PAYOUT','CANCEL','ROLLBACK') NOT NULL,created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
            try {
                st.executeUpdate("ALTER TABLE gm_transactions ADD COLUMN IF NOT EXISTS meta LONGTEXT NULL");
            }
            catch (SQLException ignored) {
                try {
                    st.executeUpdate("ALTER TABLE gm_transactions ADD COLUMN meta LONGTEXT NULL");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            st.executeUpdate("CREATE TABLE IF NOT EXISTS gm_locks (resource_key VARCHAR(128) PRIMARY KEY,locked_until TIMESTAMP NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
            st.executeUpdate("CREATE TABLE IF NOT EXISTS gm_deliveries (id BIGINT PRIMARY KEY AUTO_INCREMENT,player_uuid CHAR(36) NOT NULL,item LONGTEXT NOT NULL,listing_uuid CHAR(36) NULL,created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
        }
    }
}

