/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class ItemSerializer {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String toBase64(ItemStack item) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String string;
            try (BukkitObjectOutputStream oos = new BukkitObjectOutputStream((OutputStream)baos);){
                oos.writeObject((Object)item);
                oos.flush();
                string = Base64.getEncoder().encodeToString(baos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize ItemStack", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ItemStack fromBase64(String data) {
        byte[] bytes = Base64.getDecoder().decode(data);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            ItemStack itemStack;
            try (BukkitObjectInputStream ois = new BukkitObjectInputStream((InputStream)bais);){
                itemStack = (ItemStack)ois.readObject();
            }
            return itemStack;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Failed to deserialize ItemStack", e);
        }
    }
}

