/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.commands;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.integrations.BedrockMenuAdapter;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.model.TradeRequest;
import org.texboobcat.globalMarketplace.service.MarketplaceService;
import org.texboobcat.globalMarketplace.service.TradeService;
import org.texboobcat.globalMarketplace.ui.DiscordDiagnosticsMenu;
import org.texboobcat.globalMarketplace.util.ItemSerializer;

public class GMarketCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.only-players"));
            return true;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("globalmarketplace.use")) {
            sender.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.no-permission"));
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("claim")) {
            int delivered;
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            if (svc == null) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.market-unavailable"));
                return true;
            }
            int max = 36;
            if (args.length >= 2) {
                try {
                    max = Math.max(1, Integer.parseInt(args[1]));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((delivered = svc.claimDeliveries(player, max)) > 0) {
                HashMap<String, String> ph = new HashMap<String, String>();
                ph.put("count", String.valueOf(delivered));
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("success.claimed-items", ph));
            } else {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("claim.none-or-full"));
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("help")) {
            this.showHelp(player, label);
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("cancel")) {
            UUID listingId;
            if (!player.hasPermission("globalmarketplace.cancel")) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.no-permission"));
                return true;
            }
            if (args.length < 2) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("cancel.usage", Collections.singletonMap("label", label)));
                return true;
            }
            try {
                listingId = UUID.fromString(args[1]);
            }
            catch (Exception e) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.invalid-uuid"));
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            boolean ok = svc != null && svc.cancelListing(player.getUniqueId(), listingId);
            player.sendMessage(ok ? GlobalMarketplacePlugin.getInstance().msg("cancel.success") : GlobalMarketplacePlugin.getInstance().msg("cancel.failed"));
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("shop")) {
            boolean enabled = GlobalMarketplacePlugin.getInstance().getConfig().getBoolean("server-shop.enabled", false);
            if (!enabled) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.disabled"));
                return true;
            }
            BedrockMenuAdapter.openServerShopMenu(player);
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("admin")) {
            if (args.length < 2) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("admin.usage", Collections.singletonMap("label", label)));
                return true;
            }
            String sub = args[1].toLowerCase();
            if (sub.equals("servershop")) {
                if (!player.hasPermission("globalmarketplace.admin.servershop")) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.no-permission"));
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("admin.servershop-usage", Collections.singletonMap("label", label)));
                    return true;
                }
                String action = args[2].toLowerCase();
                MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                if (svc == null) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("sell.market-unavailable"));
                    return true;
                }
                if (action.equals("add")) {
                    String serialized;
                    BigDecimal price;
                    if (args.length < 4) {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.add-usage", Collections.singletonMap("label", label)));
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.add-hold-item"));
                        return true;
                    }
                    try {
                        price = new BigDecimal(args[3]);
                        if (price.compareTo(BigDecimal.ZERO) <= 0) {
                            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.add-price-gt-zero"));
                            return true;
                        }
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.add-invalid-price"));
                        return true;
                    }
                    ItemStack inHand = player.getInventory().getItemInMainHand();
                    if (inHand == null || inHand.getType() == Material.AIR) {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.add-hold-item"));
                        return true;
                    }
                    try {
                        serialized = ItemSerializer.toBase64(inHand);
                    }
                    catch (Exception ex) {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.add-serialize-failed"));
                        return true;
                    }
                    Optional<UUID> created = svc.addServerListing(serialized, price);
                    if (created.isPresent()) {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("success.servershop-added", Collections.singletonMap("id", created.get().toString())));
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.add-not-removed-note"));
                    } else {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.add-failed"));
                    }
                    return true;
                }
                if (action.equals("remove")) {
                    if (args.length < 4) {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.remove-usage", Collections.singletonMap("label", label)));
                        return true;
                    }
                    try {
                        UUID id = UUID.fromString(args[3]);
                        boolean ok = svc.removeServerListing(id);
                        player.sendMessage(ok ? GlobalMarketplacePlugin.getInstance().msg("success.servershop-removed") : GlobalMarketplacePlugin.getInstance().msg("errors.listing-not-found"));
                    }
                    catch (IllegalArgumentException ex) {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.invalid-uuid"));
                    }
                    return true;
                }
                if (action.equals("list")) {
                    List<Listing> listings = svc.getServerListings();
                    if (listings.isEmpty()) {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.list-empty"));
                    } else {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.list-header"));
                        for (Listing l : listings) {
                            try {
                                ItemStack item = ItemSerializer.fromBase64(l.getItemSerialized());
                                String name = item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() ? item.getItemMeta().getDisplayName() : (item != null ? item.getType().name() : "Unknown");
                                HashMap<String, String> ph = new HashMap<String, String>();
                                ph.put("name", name);
                                ph.put("price", String.valueOf(l.getPrice()));
                                ph.put("id", l.getUuid().toString());
                                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.list-entry", ph));
                            }
                            catch (Exception ignored) {
                                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.list-malformed", Collections.singletonMap("id", l.getUuid().toString())));
                            }
                        }
                    }
                    return true;
                }
                if (action.equals("setprice")) {
                    if (args.length < 5) {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.setprice-usage", Collections.singletonMap("label", label)));
                        return true;
                    }
                    try {
                        UUID id = UUID.fromString(args[3]);
                        BigDecimal newPrice = new BigDecimal(args[4]);
                        if (newPrice.compareTo(BigDecimal.ZERO) <= 0) {
                            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.setprice-price-gt-zero"));
                            return true;
                        }
                        boolean ok = svc.updateServerListingPrice(id, newPrice);
                        player.sendMessage(ok ? GlobalMarketplacePlugin.getInstance().msg("success.servershop-price-updated", Collections.singletonMap("price", newPrice.toString())) : GlobalMarketplacePlugin.getInstance().msg("errors.listing-not-found"));
                    }
                    catch (IllegalArgumentException ex) {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.setprice-invalid"));
                    }
                    return true;
                }
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("admin.servershop-usage", Collections.singletonMap("label", label)));
                return true;
            }
            if (sub.equals("discord")) {
                if (!player.hasPermission("globalmarketplace.admin.discord") && !player.hasPermission("globalmarketplace.admin.reload")) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.no-permission"));
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage("\u00a7eUsage: /" + label + " admin discord <open|test|add|remove|debug|reload> [...]");
                    return true;
                }
                String dAction = args[2].toLowerCase();
                GlobalMarketplacePlugin plugin = GlobalMarketplacePlugin.getInstance();
                switch (dAction) {
                    case "open": {
                        new DiscordDiagnosticsMenu().open(player);
                        return true;
                    }
                    case "test": {
                        String target;
                        if (plugin.getDiscordService() == null) {
                            player.sendMessage("\u00a7cNo webhooks configured.");
                            return true;
                        }
                        String string = target = args.length >= 4 ? args[3] : null;
                        if (target != null && target.equalsIgnoreCase("all")) {
                            target = null;
                        }
                        plugin.getDiscordService().ping(target, "Test ping from " + player.getName());
                        player.sendMessage("\u00a7aSent test ping" + (String)(target == null ? "s to all webhooks." : " to \u00a7f" + args[3]));
                        return true;
                    }
                    case "add": {
                        if (args.length < 5) {
                            player.sendMessage("\u00a7eUsage: /" + label + " admin discord add <name> <url>");
                            return true;
                        }
                        String name = args[3];
                        String url = args[4];
                        FileConfiguration cfg = plugin.getConfig();
                        ArrayList list = new ArrayList();
                        List old = cfg.getList("discord.webhooks");
                        if (old != null) {
                            for (Object o : old) {
                                if (!(o instanceof Map)) continue;
                                Map m = (Map)o;
                                LinkedHashMap copy = new LinkedHashMap();
                                for (Map.Entry en : m.entrySet()) {
                                    if (en.getKey() == null) continue;
                                    copy.put(String.valueOf(en.getKey()), en.getValue());
                                }
                                list.add(copy);
                            }
                        }
                        LinkedHashMap<String, Object> entry = new LinkedHashMap<String, Object>();
                        entry.put("name", name);
                        entry.put("url", url);
                        entry.put("events", List.of());
                        list.add(entry);
                        cfg.set("discord.webhooks", list);
                        try {
                            plugin.saveConfig();
                        }
                        catch (Exception o) {
                            // empty catch block
                        }
                        plugin.rebuildDiscordServiceFromConfig();
                        player.sendMessage("\u00a7aAdded webhook \u00a7f" + name + "\u00a7a and reloaded.");
                        return true;
                    }
                    case "remove": {
                        if (args.length < 4) {
                            player.sendMessage("\u00a7eUsage: /" + label + " admin discord remove <name>");
                            return true;
                        }
                        String name = args[3];
                        FileConfiguration cfg = plugin.getConfig();
                        List list = cfg.getList("discord.webhooks");
                        ArrayList newList = new ArrayList();
                        boolean removed = false;
                        if (list != null) {
                            for (Object o : list) {
                                Object nm;
                                if (o instanceof Map && (nm = ((Map)o).get("name")) != null && nm.toString().equalsIgnoreCase(name)) {
                                    removed = true;
                                    continue;
                                }
                                newList.add(o);
                            }
                        }
                        cfg.set("discord.webhooks", newList);
                        try {
                            plugin.saveConfig();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        plugin.rebuildDiscordServiceFromConfig();
                        player.sendMessage(removed ? "\u00a7aRemoved webhook \u00a7f" + name : "\u00a7cWebhook not found: \u00a7f" + name);
                        return true;
                    }
                    case "debug": {
                        boolean cur;
                        if (args.length < 4) {
                            player.sendMessage("\u00a7eUsage: /" + label + " admin discord debug <on|off|toggle>");
                            return true;
                        }
                        String mode = args[3].toLowerCase();
                        FileConfiguration cfg = plugin.getConfig();
                        boolean next = cur = cfg.getBoolean("discord.debug", false);
                        if (mode.equals("toggle")) {
                            next = !cur;
                        } else if (mode.equals("on")) {
                            next = true;
                        } else if (mode.equals("off")) {
                            next = false;
                        } else {
                            player.sendMessage("\u00a7cInvalid mode. Use on/off/toggle.");
                            return true;
                        }
                        cfg.set("discord.debug", (Object)next);
                        try {
                            plugin.saveConfig();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        player.sendMessage("\u00a76Discord debug is now \u00a7e" + (next ? "ON" : "OFF"));
                        return true;
                    }
                    case "reload": {
                        plugin.rebuildDiscordServiceFromConfig();
                        player.sendMessage("\u00a7eDiscord webhook service reloaded from config.");
                        return true;
                    }
                }
                player.sendMessage("\u00a7eUsage: /" + label + " admin discord <open|test|add|remove|debug|reload> [...]");
                return true;
            }
            if (sub.equals("remove")) {
                if (!player.hasPermission("globalmarketplace.admin.remove")) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.no-permission"));
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("admin.remove-usage", Collections.singletonMap("label", label)));
                    return true;
                }
                try {
                    UUID id = UUID.fromString(args[2]);
                    MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                    boolean ok = svc != null && svc.adminRemoveListing(id);
                    player.sendMessage(ok ? GlobalMarketplacePlugin.getInstance().msg("success.admin-removed") : GlobalMarketplacePlugin.getInstance().msg("errors.listing-not-found"));
                }
                catch (IllegalArgumentException ex) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.invalid-uuid"));
                }
                return true;
            }
            if (sub.equals("reload")) {
                if (!player.hasPermission("globalmarketplace.admin.reload")) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("admin.reload-no-permission"));
                    return true;
                }
                GlobalMarketplacePlugin plugin = GlobalMarketplacePlugin.getInstance();
                plugin.reloadConfig();
                try {
                    plugin.checkAndMergeMessages();
                }
                catch (Exception e) {
                    plugin.getLogger().warning("Messages merge failed: " + e.getMessage());
                }
                plugin.reloadMessages();
                MarketplaceService svc = plugin.getMarketplaceService();
                if (svc != null) {
                    svc.loadServerListings(plugin.getConfig());
                    svc.setAutoPayout(plugin.getConfig().getBoolean("payout.auto", false));
                }
                plugin.rebuildDiscordServiceFromConfig();
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("success.admin-reloaded"));
                return true;
            }
            if (sub.equals("rollback")) {
                if (!player.hasPermission("globalmarketplace.admin.rollback")) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.no-permission"));
                    return true;
                }
                if (args.length < 3) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("admin.rollback-usage", Collections.singletonMap("label", label)));
                    return true;
                }
                try {
                    UUID id = UUID.fromString(args[2]);
                    MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                    boolean ok = svc != null && svc.adminRollbackListing(id);
                    player.sendMessage(ok ? GlobalMarketplacePlugin.getInstance().msg("success.rollback-success") : GlobalMarketplacePlugin.getInstance().msg("admin.rollback-failed"));
                }
                catch (IllegalArgumentException ex) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.invalid-uuid"));
                }
                return true;
            }
            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("admin.usage", Collections.singletonMap("label", label)));
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("payout")) {
            Optional<BigDecimal> pendingOpt;
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            if (svc == null) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.market-unavailable"));
                return true;
            }
            BigDecimal amount = null;
            if (args.length == 0) {
                BedrockMenuAdapter.openMainMenu(player);
                return true;
            }
            if (args.length >= 2 && !args[1].equalsIgnoreCase("all")) {
                try {
                    amount = new BigDecimal(args[1]);
                    if (amount.compareTo(BigDecimal.ZERO) <= 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("payout.invalid-amount"));
                    return true;
                }
            }
            if ((pendingOpt = svc.getPendingBalance(player.getUniqueId())).isEmpty()) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("payout.could-not-fetch"));
                return true;
            }
            BigDecimal pending = pendingOpt.get();
            if (pending.compareTo(BigDecimal.ZERO) <= 0) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("payout.none-pending"));
                return true;
            }
            boolean ok = svc.payout(player.getUniqueId(), amount);
            if (ok) {
                BigDecimal after = svc.getPendingBalance(player.getUniqueId()).orElse(BigDecimal.ZERO);
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("payout.success", Collections.singletonMap("remaining", after.toString())));
            } else {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("payout.failed"));
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("sell")) {
            String serialized;
            BigDecimal price;
            if (args.length < 2) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.unknown-command-use-help", Collections.singletonMap("label", label)));
                return true;
            }
            try {
                price = new BigDecimal(args[1]);
                if (price.compareTo(BigDecimal.ZERO) <= 0) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("sell.price-gt-zero"));
                    return true;
                }
            }
            catch (NumberFormatException e) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("sell.invalid-price"));
                return true;
            }
            ItemStack inHand = player.getInventory().getItemInMainHand();
            if (inHand == null || inHand.getType() == Material.AIR) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("sell.hold-item"));
                return true;
            }
            try {
                serialized = ItemSerializer.toBase64(inHand);
            }
            catch (Exception ex) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("sell.serialize-failed"));
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            if (svc == null) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("sell.market-unavailable"));
                return true;
            }
            Optional<UUID> created = svc.createFixedListing(player.getUniqueId(), serialized, price);
            if (created.isPresent()) {
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("success.sell-created", Collections.singletonMap("id", created.get().toString())));
            } else {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("sell.failed"));
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("auction")) {
            String serialized;
            int minutes;
            BigDecimal start;
            if (args.length < 3) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("auction.usage", Collections.singletonMap("label", label)));
                return true;
            }
            try {
                start = new BigDecimal(args[1]);
                minutes = Integer.parseInt(args[2]);
                if (start.compareTo(BigDecimal.ZERO) <= 0 || minutes <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("auction.invalid-args", Collections.singletonMap("label", label)));
                return true;
            }
            ItemStack inHand = player.getInventory().getItemInMainHand();
            if (inHand == null || inHand.getType() == Material.AIR) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("auction.hold-item"));
                return true;
            }
            try {
                serialized = ItemSerializer.toBase64(inHand);
            }
            catch (Exception ex) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("auction.serialize-failed"));
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            Optional<UUID> created = svc.createAuctionListing(player.getUniqueId(), serialized, start, Instant.now().plus(Duration.ofMinutes(minutes)));
            if (created.isPresent()) {
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("success.auction-created", Collections.singletonMap("id", created.get().toString())));
            } else {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("auction.failed"));
            }
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("bid")) {
            BigDecimal amount;
            UUID listingId;
            if (args.length < 3) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("bid.usage", Collections.singletonMap("label", label)));
                return true;
            }
            try {
                listingId = UUID.fromString(args[1]);
                amount = new BigDecimal(args[2]);
                if (amount.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (Exception e) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("bid.invalid-args"));
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            boolean ok = svc.placeBid(listingId, player.getUniqueId(), amount);
            player.sendMessage(ok ? GlobalMarketplacePlugin.getInstance().msg("bid.placed") : GlobalMarketplacePlugin.getInstance().msg("bid.rejected"));
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("trade")) {
            if (args.length < 3) {
                player.sendMessage("\u00a7eUsage: /" + label + " trade <request|accept|decline> <playerName>");
                return true;
            }
            String action = args[1].toLowerCase();
            String targetName = args[2];
            TradeService tradeService = GlobalMarketplacePlugin.getInstance().getTradeService();
            if (action.equals("request")) {
                Player targetPlayer = Bukkit.getPlayer((String)targetName);
                if (targetPlayer == null) {
                    player.sendMessage("\u00a7cPlayer not found or not online.");
                    return true;
                }
                if (targetPlayer.getUniqueId().equals(player.getUniqueId())) {
                    player.sendMessage("\u00a7cYou cannot trade with yourself.");
                    return true;
                }
                TradeRequest request = tradeService.createTradeRequest(player.getUniqueId(), targetPlayer.getUniqueId());
                if (request == null) {
                    player.sendMessage("\u00a7cCould not create trade request. One of you may already be in a trade.");
                } else {
                    player.sendMessage("\u00a7aTrade request sent to " + targetPlayer.getName() + "!");
                }
                return true;
            }
            if (action.equals("accept")) {
                Player initiatorPlayer = Bukkit.getPlayer((String)targetName);
                if (initiatorPlayer == null) {
                    player.sendMessage("\u00a7cPlayer not found or not online.");
                    return true;
                }
                if (tradeService.acceptTradeRequest(player.getUniqueId(), initiatorPlayer.getUniqueId())) {
                    player.sendMessage("\u00a7aTrade request accepted! Opening trade window...");
                } else {
                    player.sendMessage("\u00a7cNo valid trade request found from " + targetName + ".");
                }
                return true;
            }
            if (action.equals("decline")) {
                Player initiatorPlayer = Bukkit.getPlayer((String)targetName);
                if (initiatorPlayer == null) {
                    player.sendMessage("\u00a7cPlayer not found or not online.");
                    return true;
                }
                if (tradeService.declineTradeRequest(player.getUniqueId(), initiatorPlayer.getUniqueId())) {
                    player.sendMessage("\u00a77Trade request declined.");
                } else {
                    player.sendMessage("\u00a7cNo valid trade request found from " + targetName + ".");
                }
                return true;
            }
            player.sendMessage("\u00a7eUsage: /" + label + " trade <request|accept|decline> <playerName>");
            return true;
        }
        if (args.length > 0 && args[0].equalsIgnoreCase("directbuy")) {
            UUID listingId;
            if (args.length < 2) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("directbuy.usage", Collections.singletonMap("label", label)));
                return true;
            }
            try {
                listingId = UUID.fromString(args[1]);
            }
            catch (Exception e) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("directbuy.invalid-uuid"));
                return true;
            }
            MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
            boolean ok = svc.purchaseDirect(player.getUniqueId(), listingId);
            if (ok) {
                int delivered = svc.claimDeliveries(player, 36);
                if (delivered > 0) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("success.directbuy-delivered"));
                } else {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("directbuy.success-claim"));
                }
            } else {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("directbuy.failed"));
            }
            return true;
        }
        BedrockMenuAdapter.openMainMenu(player);
        GlobalMarketplacePlugin.getInstance().getLogger().info("/gmarket opened MainMenu for " + sender.getName());
        return true;
    }

    private void showHelp(Player player, String label) {
        player.sendMessage("\u00a76=== Global Marketplace Help ===");
        player.sendMessage("\u00a7e/" + label + " \u00a77- Open marketplace GUI");
        player.sendMessage("\u00a7e/" + label + " help \u00a77- Show this help");
        player.sendMessage("\u00a7e/" + label + " claim [amount] \u00a77- Claim delivered items");
        player.sendMessage("\u00a7e/" + label + " payout [amount|all] \u00a77- Withdraw earnings");
        player.sendMessage("\u00a7e/" + label + " cancel <listingId> \u00a77- Cancel your listing");
        player.sendMessage("\u00a7e/" + label + " directbuy <listingId> \u00a77- Buy direct listing");
        player.sendMessage("\u00a7e/" + label + " trade request <player> \u00a77- Send trade request");
        player.sendMessage("\u00a7e/" + label + " trade accept \u00a77- Accept trade request");
        player.sendMessage("\u00a7e/" + label + " trade decline \u00a77- Decline trade request");
        boolean serverShopEnabled = GlobalMarketplacePlugin.getInstance().getConfig().getBoolean("server-shop.enabled", false);
        if (serverShopEnabled) {
            player.sendMessage("\u00a7e/" + label + " shop \u00a77- Open server shop");
        }
        if (player.hasPermission("globalmarketplace.admin")) {
            player.sendMessage("\u00a7c/" + label + " admin remove <listingId> \u00a77- Remove listing");
            player.sendMessage("\u00a7c/" + label + " admin reload \u00a77- Reload plugin");
            player.sendMessage("\u00a7c/" + label + " admin rollback <listingId> \u00a77- Rollback a sold listing");
        }
        if (player.hasPermission("globalmarketplace.admin.servershop")) {
            player.sendMessage("\u00a76/" + label + " admin servershop add <price> \u00a77- Add server listing");
            player.sendMessage("\u00a76/" + label + " admin servershop remove <id> \u00a77- Remove server listing");
            player.sendMessage("\u00a76/" + label + " admin servershop list \u00a77- List all server listings");
            player.sendMessage("\u00a76/" + label + " admin servershop setprice <id> <price> \u00a77- Update price");
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> out = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return out;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            String p = args[0].toLowerCase();
            ArrayList<String> base = new ArrayList<String>();
            base.add("help");
            base.add("claim");
            base.add("payout");
            base.add("sell");
            base.add("auction");
            base.add("bid");
            base.add("trade");
            base.add("directbuy");
            base.add("cancel");
            base.add("admin");
            boolean serverShopEnabled = GlobalMarketplacePlugin.getInstance().getConfig().getBoolean("server-shop.enabled", false);
            if (serverShopEnabled) {
                base.add("shop");
            }
            for (String s : base) {
                if (!s.startsWith(p)) continue;
                out.add(s);
            }
            return out;
        }
        if (args.length >= 1 && args[0].equalsIgnoreCase("admin")) {
            if (!player.hasPermission("globalmarketplace.admin") && !player.hasPermission("globalmarketplace.admin.servershop")) {
                return out;
            }
            if (args.length == 2) {
                String p = args[1].toLowerCase();
                ArrayList<String> subs = new ArrayList<String>();
                if (player.hasPermission("globalmarketplace.admin")) {
                    subs.add("remove");
                    subs.add("reload");
                    subs.add("rollback");
                    subs.add("discord");
                }
                if (player.hasPermission("globalmarketplace.admin.servershop")) {
                    subs.add("servershop");
                }
                for (String s : subs) {
                    if (!s.startsWith(p)) continue;
                    out.add(s);
                }
                return out;
            }
            if (args.length == 3) {
                String sub = args[1].toLowerCase();
                if (sub.equals("servershop") && player.hasPermission("globalmarketplace.admin.servershop")) {
                    String[] actions;
                    String p = args[2].toLowerCase();
                    for (String s : actions = new String[]{"add", "remove", "list", "setprice"}) {
                        if (!s.startsWith(p)) continue;
                        out.add(s);
                    }
                    return out;
                }
                if (sub.equals("discord") && player.hasPermission("globalmarketplace.admin")) {
                    String[] actions;
                    String p = args[2].toLowerCase();
                    for (String s : actions = new String[]{"open", "test", "add", "remove", "debug", "reload"}) {
                        if (!s.startsWith(p)) continue;
                        out.add(s);
                    }
                    return out;
                }
                if (sub.equals("remove") || sub.equals("rollback")) {
                    String p = args[2];
                    if (p.isEmpty()) {
                        out.add("<listingUuid>");
                    }
                    if (p.matches("[0-9a-fA-F-]{1,36}")) {
                        out.add(p);
                    }
                    return out;
                }
            }
        }
        return out;
    }
}

