/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class GMarketTabCompleter
implements TabCompleter {
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        String sub;
        boolean isPlayer = sender instanceof Player;
        if (args.length == 1) {
            ArrayList<String> base = new ArrayList<String>(Arrays.asList("help", "sell", "auction", "bid", "directsell", "directbuy", "payout", "claim", "cancel", "admin"));
            if (!(sender.hasPermission("globalmarketplace.admin.remove") || sender.hasPermission("globalmarketplace.admin.reload") || sender.hasPermission("globalmarketplace.admin.rollback"))) {
                base.remove("admin");
            }
            if (!sender.hasPermission("globalmarketplace.cancel")) {
                base.remove("cancel");
            }
            return this.prefixFilter(base, args[0]);
        }
        switch (sub = args[0].toLowerCase(Locale.ROOT)) {
            case "help": {
                return Collections.emptyList();
            }
            case "sell": {
                if (args.length == 2) {
                    return this.prefixFilter(Arrays.asList("100", "99.99", "250"), args[1]);
                }
                return Collections.emptyList();
            }
            case "auction": {
                if (args.length == 2) {
                    return this.prefixFilter(Arrays.asList("100", "1000"), args[1]);
                }
                if (args.length == 3) {
                    return this.prefixFilter(Arrays.asList("60", "120", "180", "1440"), args[2]);
                }
                return Collections.emptyList();
            }
            case "bid": {
                if (args.length == 2) {
                    return Collections.singletonList("<listingUuid>");
                }
                if (args.length == 3) {
                    return this.prefixFilter(Arrays.asList("100", "250", "500"), args[2]);
                }
                return Collections.emptyList();
            }
            case "directsell": {
                if (args.length == 2) {
                    return this.prefixFilter(Arrays.asList("100", "250"), args[1]);
                }
                if (args.length == 3) {
                    List<String> uuids = Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getUniqueId).map(UUID::toString).collect(Collectors.toList());
                    return this.prefixFilter(uuids, args[2]);
                }
                return Collections.emptyList();
            }
            case "directbuy": {
                if (args.length == 2) {
                    return Collections.singletonList("<listingUuid>");
                }
                return Collections.emptyList();
            }
            case "payout": {
                if (args.length == 2) {
                    return this.prefixFilter(Arrays.asList("all"), args[1]);
                }
                return Collections.emptyList();
            }
            case "claim": {
                if (args.length == 2) {
                    return this.prefixFilter(Arrays.asList("36", "27", "18", "9"), args[1]);
                }
                return Collections.emptyList();
            }
            case "cancel": {
                if (args.length == 2) {
                    return Collections.singletonList("<listingUuid>");
                }
                return Collections.emptyList();
            }
            case "admin": {
                if (args.length == 2) {
                    return this.prefixFilter(Arrays.asList("remove", "reload", "rollback"), args[1]);
                }
                if (args.length == 3 && (args[1].equalsIgnoreCase("remove") || args[1].equalsIgnoreCase("rollback"))) {
                    return Collections.singletonList("<listingUuid>");
                }
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private List<String> prefixFilter(List<String> options, String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return options;
        }
        String p = prefix.toLowerCase(Locale.ROOT);
        return options.stream().filter(s -> s.toLowerCase(Locale.ROOT).startsWith(p)).collect(Collectors.toList());
    }
}

