/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.model.TradeRequest;
import org.texboobcat.globalMarketplace.service.TradeService;

public class TradeCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String action;
        if (!(sender instanceof Player)) {
            sender.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.only-players"));
            return true;
        }
        Player player = (Player)sender;
        TradeService tradeService = GlobalMarketplacePlugin.getInstance().getTradeService();
        if (tradeService == null) {
            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.trade-unavailable"));
            return true;
        }
        if (args.length == 0) {
            this.showHelp(player, label);
            return true;
        }
        switch (action = args[0].toLowerCase()) {
            case "request": {
                if (args.length < 2) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.request-usage", Collections.singletonMap("label", label)));
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.player-not-found"));
                    return true;
                }
                if (target.equals((Object)player)) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.cannot-self"));
                    return true;
                }
                TradeRequest request = tradeService.createTradeRequest(player.getUniqueId(), target.getUniqueId());
                if (request != null) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.request-sent", Collections.singletonMap("target", target.getName())));
                    target.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.request-received", Collections.singletonMap("initiator", player.getName())));
                } else {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.request-failed"));
                }
                return true;
            }
            case "accept": {
                if (args.length >= 2) {
                    Player initiatorPlayer = Bukkit.getPlayer((String)args[1]);
                    if (initiatorPlayer == null) {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.player-not-found"));
                        return true;
                    }
                    boolean accepted = tradeService.acceptTradeRequest(player.getUniqueId(), initiatorPlayer.getUniqueId());
                    if (!accepted) {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.accept-none-from", Collections.singletonMap("player", initiatorPlayer.getName())));
                    }
                } else {
                    TradeRequest pendingRequest = tradeService.getPendingRequestForTarget(player.getUniqueId());
                    if (pendingRequest != null) {
                        boolean accepted = tradeService.acceptTradeRequest(player.getUniqueId(), pendingRequest.getInitiator());
                        if (!accepted) {
                            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.accept-failed"));
                        }
                    } else {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.accept-none"));
                    }
                }
                return true;
            }
            case "decline": {
                if (args.length >= 2) {
                    Player initiatorPlayer = Bukkit.getPlayer((String)args[1]);
                    if (initiatorPlayer == null) {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.player-not-found"));
                        return true;
                    }
                    boolean declined = tradeService.declineTradeRequest(player.getUniqueId(), initiatorPlayer.getUniqueId());
                    if (!declined) {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.decline-none-from", Collections.singletonMap("player", initiatorPlayer.getName())));
                    }
                } else {
                    TradeRequest pendingDeclineRequest = tradeService.getPendingRequestForTarget(player.getUniqueId());
                    if (pendingDeclineRequest != null) {
                        boolean declined = tradeService.declineTradeRequest(player.getUniqueId(), pendingDeclineRequest.getInitiator());
                        if (!declined) {
                            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.decline-failed"));
                        }
                    } else {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.decline-none"));
                    }
                }
                return true;
            }
            case "help": {
                this.showHelp(player, label);
                return true;
            }
        }
        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.unknown-action", Collections.singletonMap("label", label)));
        return true;
    }

    private void showHelp(Player player, String label) {
        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("help.trade.title"));
        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("help.trade.request", Collections.singletonMap("label", label)));
        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("help.trade.accept", Collections.singletonMap("label", label)));
        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("help.trade.decline", Collections.singletonMap("label", label)));
        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("help.trade.help", Collections.singletonMap("label", label)));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        TradeService tradeService = GlobalMarketplacePlugin.getInstance().getTradeService();
        if (tradeService == null) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            List<String> actions = Arrays.asList("request", "accept", "decline", "help");
            return actions.stream().filter(action -> action.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2) {
            String action2 = args[0].toLowerCase();
            if (action2.equals("request")) {
                return Bukkit.getOnlinePlayers().stream().filter(p -> !p.equals((Object)player)).map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (action2.equals("accept") || action2.equals("decline")) {
                Player initiator;
                ArrayList<String> requesters = new ArrayList<String>();
                TradeRequest pendingRequest = tradeService.getPendingRequestForTarget(player.getUniqueId());
                if (pendingRequest != null && (initiator = Bukkit.getPlayer((UUID)pendingRequest.getInitiator())) != null) {
                    requesters.add(initiator.getName());
                }
                return requesters.stream().filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
        }
        return new ArrayList<String>();
    }
}

