/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.integrations;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;

public class ImageCacheServer {
    private HttpServer server;
    private final int port;
    private final File cacheDir;

    public ImageCacheServer(int port) {
        this.port = port;
        this.cacheDir = new File(GlobalMarketplacePlugin.getInstance().getDataFolder(), "image-cache");
    }

    public void start() throws IOException {
        if (!this.cacheDir.exists()) {
            this.cacheDir.mkdirs();
        }
        this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
        this.server.createContext("/images/", new ImageHandler());
        this.server.setExecutor(null);
        this.server.start();
        GlobalMarketplacePlugin.getInstance().getLogger().info("Image cache server started on port " + this.port);
        GlobalMarketplacePlugin.getInstance().getLogger().info("Images accessible at: http://localhost:" + this.port + "/images/");
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
            GlobalMarketplacePlugin.getInstance().getLogger().info("Image cache server stopped");
        }
    }

    public String getBaseUrl() {
        return "http://localhost:" + this.port + "/images";
    }

    private class ImageHandler
    implements HttpHandler {
        private ImageHandler() {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String path = exchange.getRequestURI().getPath();
            String filename = path.substring("/images/".length());
            if (filename.contains("..") || filename.contains("/") || filename.contains("\\")) {
                this.send404(exchange);
                return;
            }
            File imageFile = new File(ImageCacheServer.this.cacheDir, filename);
            if (!imageFile.exists() || !imageFile.isFile()) {
                this.send404(exchange);
                return;
            }
            String contentType = "image/png";
            if (filename.endsWith(".jpg") || filename.endsWith(".jpeg")) {
                contentType = "image/jpeg";
            } else if (filename.endsWith(".gif")) {
                contentType = "image/gif";
            }
            exchange.getResponseHeaders().set("Content-Type", contentType);
            exchange.getResponseHeaders().set("Cache-Control", "public, max-age=86400");
            exchange.sendResponseHeaders(200, imageFile.length());
            try (FileInputStream fis = new FileInputStream(imageFile);
                 OutputStream os = exchange.getResponseBody();){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
            }
        }

        private void send404(HttpExchange exchange) throws IOException {
            String response = "404 Not Found";
            exchange.sendResponseHeaders(404, response.length());
            try (OutputStream os = exchange.getResponseBody();){
                os.write(response.getBytes());
            }
        }
    }
}

