/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.repo.adapters;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;
import org.texboobcat.globalMarketplace.dao.BalanceDao;
import org.texboobcat.globalMarketplace.repo.BalanceRepository;

public class JdbcBalanceRepository
implements BalanceRepository {
    private final BalanceDao delegate;

    public JdbcBalanceRepository(BalanceDao delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addPending(UUID player, BigDecimal amount) throws SQLException {
        this.delegate.addPending(player, amount);
    }

    @Override
    public BigDecimal getPending(UUID player) throws SQLException {
        return this.delegate.getPending(player);
    }

    @Override
    public BigDecimal tryDeductPending(UUID player, BigDecimal amount) throws SQLException {
        return this.delegate.tryDeductPending(player, amount);
    }

    @Override
    public Optional<BigDecimal> getBalance(UUID player) {
        try {
            return Optional.of(this.getPending(player));
        }
        catch (SQLException e) {
            return Optional.empty();
        }
    }

    @Override
    public boolean transferBalance(UUID from, UUID to, BigDecimal amount) {
        try {
            BigDecimal deducted = this.tryDeductPending(from, amount);
            if (deducted.compareTo(amount) >= 0) {
                this.addPending(to, amount);
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            return false;
        }
    }
}

