/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.repo.adapters;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.texboobcat.globalMarketplace.dao.DeliveryDao;
import org.texboobcat.globalMarketplace.repo.DeliveryQueue;

public class JdbcDeliveryQueue
implements DeliveryQueue {
    private final DeliveryDao delegate;

    public JdbcDeliveryQueue(DeliveryDao delegate) {
        this.delegate = delegate;
    }

    @Override
    public void enqueue(UUID playerUuid, String itemBase64, UUID listingUuid) throws SQLException {
        this.delegate.enqueue(playerUuid, itemBase64, listingUuid);
    }

    @Override
    public List<DeliveryQueue.Record> fetch(UUID playerUuid, int limit) throws SQLException {
        List<DeliveryDao.Record> rows = this.delegate.fetch(playerUuid, limit);
        ArrayList<DeliveryQueue.Record> out = new ArrayList<DeliveryQueue.Record>(rows.size());
        for (DeliveryDao.Record r : rows) {
            DeliveryQueue.Record m = new DeliveryQueue.Record();
            m.id = r.id;
            m.playerUuid = r.playerUuid;
            m.itemBase64 = r.itemBase64;
            m.listingUuid = r.listingUuid;
            out.add(m);
        }
        return out;
    }

    @Override
    public void deleteById(long id) throws SQLException {
        this.delegate.deleteById(id);
    }
}

