/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.repo.adapters;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.texboobcat.globalMarketplace.dao.ListingDao;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.model.ListingStatus;
import org.texboobcat.globalMarketplace.repo.ListingRepository;

public class JdbcListingRepository
implements ListingRepository {
    private final ListingDao delegate;

    public JdbcListingRepository(ListingDao delegate) {
        this.delegate = delegate;
    }

    @Override
    public void createListing(Listing listing) throws SQLException {
        this.delegate.createListing(listing);
    }

    @Override
    public Optional<Listing> getByUuid(UUID uuid) throws SQLException {
        return this.delegate.getByUuid(uuid);
    }

    @Override
    public boolean updateStatus(UUID uuid, ListingStatus status) throws SQLException {
        return this.delegate.updateStatus(uuid, status);
    }

    @Override
    public boolean tryUpdateStatusIf(UUID uuid, ListingStatus expectedCurrent, ListingStatus newStatus) throws SQLException {
        return this.delegate.tryUpdateStatusIf(uuid, expectedCurrent, newStatus);
    }

    @Override
    public boolean updateBid(UUID uuid, BigDecimal bid, UUID bidder) throws SQLException {
        return this.delegate.updateBid(uuid, bid, bidder);
    }

    @Override
    public List<Listing> findActive(int limit, int offset) throws SQLException {
        return this.delegate.findActive(limit, offset);
    }

    @Override
    public List<Listing> findExpiredActiveAuctions(Instant now, int limit) throws SQLException {
        return this.delegate.findExpiredActiveAuctions(now, limit);
    }

    @Override
    public List<Listing> findExpiredActiveAny(Instant now, int limit) throws SQLException {
        return this.delegate.findExpiredActiveAny(now, limit);
    }

    @Override
    public boolean deleteByUuid(UUID uuid) throws SQLException {
        return this.delegate.deleteByUuid(uuid);
    }

    @Override
    public List<Listing> findRecentSoldListings(int limit) throws SQLException {
        return this.delegate.findRecentSoldListings(limit);
    }
}

