/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.economy.EconomyService;
import org.texboobcat.globalMarketplace.model.TradeRequest;
import org.texboobcat.globalMarketplace.model.TradeSession;
import org.texboobcat.globalMarketplace.repo.BalanceRepository;
import org.texboobcat.globalMarketplace.ui.TradeMenu;

public class TradeService {
    private final Map<UUID, TradeRequest> pendingRequests = new ConcurrentHashMap<UUID, TradeRequest>();
    private final Map<UUID, TradeSession> activeSessions = new ConcurrentHashMap<UUID, TradeSession>();
    private final Map<UUID, UUID> playerToSession = new ConcurrentHashMap<UUID, UUID>();
    private final BalanceRepository balanceRepo;
    private final EconomyService economyService;

    public TradeService(BalanceRepository balanceRepo) {
        this(balanceRepo, null);
    }

    public TradeService(BalanceRepository balanceRepo, EconomyService economyService) {
        this.balanceRepo = balanceRepo;
        this.economyService = economyService;
    }

    public TradeRequest createTradeRequest(UUID initiator, UUID target) {
        Player initiatorPlayer = Bukkit.getPlayer((UUID)initiator);
        Player targetPlayer = Bukkit.getPlayer((UUID)target);
        if (initiatorPlayer == null || targetPlayer == null) {
            return null;
        }
        if (this.isPlayerInTrade(initiator) || this.isPlayerInTrade(target)) {
            return null;
        }
        this.pendingRequests.entrySet().removeIf(entry -> ((TradeRequest)entry.getValue()).getInitiator().equals(initiator));
        TradeRequest request = new TradeRequest(initiator, target);
        this.pendingRequests.put(request.getRequestId(), request);
        targetPlayer.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.request-received", Collections.singletonMap("initiator", initiatorPlayer.getName())));
        targetPlayer.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.request-expires"));
        initiatorPlayer.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.request-sent", Collections.singletonMap("target", targetPlayer.getName())));
        return request;
    }

    public boolean acceptTradeRequest(UUID target, UUID initiator) {
        TradeRequest request = this.findPendingRequest(initiator, target);
        if (request == null || request.isExpired()) {
            return false;
        }
        request.setStatus(TradeRequest.TradeRequestStatus.ACCEPTED);
        this.pendingRequests.remove(request.getRequestId());
        TradeSession session = new TradeSession(initiator, target);
        this.activeSessions.put(session.getSessionId(), session);
        this.playerToSession.put(initiator, session.getSessionId());
        this.playerToSession.put(target, session.getSessionId());
        Player initiatorPlayer = Bukkit.getPlayer((UUID)initiator);
        Player targetPlayer = Bukkit.getPlayer((UUID)target);
        if (initiatorPlayer != null && targetPlayer != null) {
            initiatorPlayer.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.accept-notify-initiator", Collections.singletonMap("player", targetPlayer.getName())));
            targetPlayer.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.accept-notify-target", Collections.singletonMap("player", initiatorPlayer.getName())));
            GlobalMarketplacePlugin.getInstance().getServer().getScheduler().runTask((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                new TradeMenu().open(initiatorPlayer, session.getSessionId());
                new TradeMenu().open(targetPlayer, session.getSessionId());
            });
        }
        return true;
    }

    public boolean declineTradeRequest(UUID target, UUID initiator) {
        String name;
        TradeRequest request = this.findPendingRequest(initiator, target);
        if (request == null) {
            return false;
        }
        request.setStatus(TradeRequest.TradeRequestStatus.DECLINED);
        this.pendingRequests.remove(request.getRequestId());
        Player initiatorPlayer = Bukkit.getPlayer((UUID)initiator);
        Player targetPlayer = Bukkit.getPlayer((UUID)target);
        if (initiatorPlayer != null) {
            name = targetPlayer != null ? targetPlayer.getName() : "player";
            initiatorPlayer.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.declined-by-other", Collections.singletonMap("player", name)));
        }
        if (targetPlayer != null) {
            name = initiatorPlayer != null ? initiatorPlayer.getName() : "player";
            targetPlayer.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.declined-self", Collections.singletonMap("player", name)));
        }
        return true;
    }

    public TradeSession getPlayerTradeSession(UUID playerId) {
        UUID sessionId = this.playerToSession.get(playerId);
        if (sessionId == null) {
            return null;
        }
        return this.activeSessions.get(sessionId);
    }

    public TradeRequest getPendingRequestForTarget(UUID targetId) {
        return this.pendingRequests.values().stream().filter(request -> request.getTarget().equals(targetId) && request.getStatus() == TradeRequest.TradeRequestStatus.PENDING).findFirst().orElse(null);
    }

    public TradeSession getTradeSession(UUID sessionId) {
        return this.activeSessions.get(sessionId);
    }

    public boolean isPlayerInTrade(UUID playerId) {
        return this.playerToSession.containsKey(playerId);
    }

    public Optional<BigDecimal> getBalance(UUID playerId) {
        try {
            if (this.economyService != null && this.economyService.isEnabled()) {
                double bal = this.economyService.getBalance(playerId);
                return Optional.of(BigDecimal.valueOf(bal).setScale(2, RoundingMode.DOWN));
            }
            return this.balanceRepo.getBalance(playerId);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public boolean addItemToTrade(UUID playerId, ItemStack item) {
        TradeSession session = this.getPlayerTradeSession(playerId);
        if (session == null || session.getStatus() != TradeSession.TradeSessionStatus.ACTIVE) {
            return false;
        }
        if (session.isPlayer1(playerId)) {
            session.addPlayer1Item(item);
        } else {
            session.addPlayer2Item(item);
        }
        session.resetConfirmations();
        return true;
    }

    public boolean removeItemFromTrade(UUID playerId, int index) {
        TradeSession session = this.getPlayerTradeSession(playerId);
        if (session == null || session.getStatus() != TradeSession.TradeSessionStatus.ACTIVE) {
            return false;
        }
        if (session.isPlayer1(playerId)) {
            session.removePlayer1Item(index);
        } else {
            session.removePlayer2Item(index);
        }
        session.resetConfirmations();
        return true;
    }

    public boolean setPlayerMoney(UUID playerId, BigDecimal amount) {
        TradeSession session = this.getPlayerTradeSession(playerId);
        if (session == null || session.getStatus() != TradeSession.TradeSessionStatus.ACTIVE) {
            return false;
        }
        if (amount == null) {
            return false;
        }
        if ((amount = amount.setScale(2, RoundingMode.DOWN)).compareTo(BigDecimal.ZERO) < 0) {
            return false;
        }
        BigDecimal current = this.getBalance(playerId).orElse(null);
        if (current != null && amount.compareTo(current) > 0) {
            return false;
        }
        if (session.isPlayer1(playerId)) {
            session.setPlayer1Money(amount);
        } else {
            session.setPlayer2Money(amount);
        }
        session.resetConfirmations();
        return true;
    }

    public boolean setPlayerReady(UUID playerId, boolean ready) {
        TradeSession session = this.getPlayerTradeSession(playerId);
        if (session == null || session.getStatus() != TradeSession.TradeSessionStatus.ACTIVE) {
            return false;
        }
        if (session.isPlayer1(playerId)) {
            session.setPlayer1Ready(ready);
        } else {
            session.setPlayer2Ready(ready);
        }
        return true;
    }

    public boolean confirmTrade(UUID playerId) {
        TradeSession session = this.getPlayerTradeSession(playerId);
        if (session == null || session.getStatus() != TradeSession.TradeSessionStatus.ACTIVE) {
            return false;
        }
        if (!session.bothPlayersReady()) {
            return false;
        }
        if (session.isPlayer1(playerId)) {
            session.setPlayer1Confirmed(true);
        } else {
            session.setPlayer2Confirmed(true);
        }
        if (session.bothPlayersConfirmed()) {
            return this.executeTrade(session);
        }
        return true;
    }

    public boolean cancelTrade(UUID playerId) {
        TradeSession session = this.getPlayerTradeSession(playerId);
        if (session == null) {
            return false;
        }
        session.setStatus(TradeSession.TradeSessionStatus.CANCELLED);
        this.activeSessions.remove(session.getSessionId());
        this.playerToSession.remove(session.getPlayer1());
        this.playerToSession.remove(session.getPlayer2());
        Player player1 = Bukkit.getPlayer((UUID)session.getPlayer1());
        Player player2 = Bukkit.getPlayer((UUID)session.getPlayer2());
        if (player1 != null) {
            player1.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.cancelled"));
            player1.closeInventory();
            this.returnItems(player1, session.getPlayer1Items());
        }
        if (player2 != null) {
            player2.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.cancelled"));
            player2.closeInventory();
            this.returnItems(player2, session.getPlayer2Items());
        }
        return true;
    }

    private boolean executeTrade(TradeSession session) {
        Player player1 = Bukkit.getPlayer((UUID)session.getPlayer1());
        Player player2 = Bukkit.getPlayer((UUID)session.getPlayer2());
        if (player1 == null || player2 == null) {
            this.cancelTrade(session.getPlayer1());
            return false;
        }
        try {
            boolean useVault;
            boolean p2CanReceive = this.canReceiveAll(player2, session.getPlayer1Items());
            boolean p1CanReceive = this.canReceiveAll(player1, session.getPlayer2Items());
            if (!p2CanReceive || !p1CanReceive) {
                if (!p2CanReceive) {
                    player2.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.invspace-self"));
                    player1.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.invspace-other"));
                }
                if (!p1CanReceive) {
                    player1.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.invspace-self"));
                    player2.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.invspace-other"));
                }
                session.resetConfirmations();
                if (player1.isOnline()) {
                    new TradeMenu().open(player1, session.getSessionId());
                }
                if (player2.isOnline()) {
                    new TradeMenu().open(player2, session.getSessionId());
                }
                return false;
            }
            BigDecimal p1Pay = session.getPlayer1Money();
            BigDecimal p2Pay = session.getPlayer2Money();
            boolean bl = useVault = this.economyService != null && this.economyService.isEnabled();
            if (useVault) {
                boolean p1Withdrew = true;
                boolean p2Withdrew = true;
                if (p1Pay.compareTo(BigDecimal.ZERO) > 0 && !(p1Withdrew = this.economyService.withdraw(session.getPlayer1(), p1Pay.doubleValue()))) {
                    player1.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.failed-you-balance"));
                    player2.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.failed-other-balance"));
                    return false;
                }
                if (p2Pay.compareTo(BigDecimal.ZERO) > 0 && !(p2Withdrew = this.economyService.withdraw(session.getPlayer2(), p2Pay.doubleValue()))) {
                    if (p1Pay.compareTo(BigDecimal.ZERO) > 0 && p1Withdrew) {
                        this.economyService.deposit(session.getPlayer1(), p1Pay.doubleValue());
                    }
                    player1.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.failed-other-balance"));
                    player2.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.failed-you-balance"));
                    return false;
                }
                if (p1Pay.compareTo(BigDecimal.ZERO) > 0) {
                    this.economyService.deposit(session.getPlayer2(), p1Pay.doubleValue());
                }
                if (p2Pay.compareTo(BigDecimal.ZERO) > 0) {
                    this.economyService.deposit(session.getPlayer1(), p2Pay.doubleValue());
                }
            } else {
                if (p1Pay.compareTo(BigDecimal.ZERO) > 0 && !this.balanceRepo.transferBalance(session.getPlayer1(), session.getPlayer2(), p1Pay)) {
                    player1.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.failed-you-balance"));
                    player2.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.failed-other-balance"));
                    return false;
                }
                if (p2Pay.compareTo(BigDecimal.ZERO) > 0 && !this.balanceRepo.transferBalance(session.getPlayer2(), session.getPlayer1(), p2Pay)) {
                    if (p1Pay.compareTo(BigDecimal.ZERO) > 0) {
                        this.balanceRepo.transferBalance(session.getPlayer2(), session.getPlayer1(), p1Pay);
                    }
                    player1.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.failed-other-balance"));
                    player2.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.failed-you-balance"));
                    return false;
                }
            }
            this.giveItems(player2, session.getPlayer1Items());
            this.giveItems(player1, session.getPlayer2Items());
            session.setStatus(TradeSession.TradeSessionStatus.COMPLETED);
            this.cleanupSession(session.getSessionId());
            player1.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.completed"));
            player2.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.completed"));
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.cancelTrade(session.getPlayer1());
            return false;
        }
    }

    private boolean canReceiveAll(Player player, List<ItemStack> items) {
        try {
            PlayerInventory playerInv = player.getInventory();
            Inventory temp = Bukkit.createInventory(null, (int)playerInv.getSize());
            ItemStack[] contents = playerInv.getContents();
            ItemStack[] copy = new ItemStack[contents.length];
            for (int i = 0; i < contents.length; ++i) {
                copy[i] = contents[i] == null ? null : contents[i].clone();
            }
            temp.setContents(copy);
            for (ItemStack it : items) {
                if (it == null) continue;
                ItemStack toAdd = it.clone();
                HashMap left = temp.addItem(new ItemStack[]{toAdd});
                if (left.isEmpty()) continue;
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            return true;
        }
    }

    private void returnItems(Player player, List<ItemStack> items) {
        this.giveItems(player, items);
    }

    private void giveItems(Player player, List<ItemStack> items) {
        for (ItemStack item : items) {
            HashMap leftovers = player.getInventory().addItem(new ItemStack[]{item});
            for (ItemStack leftover : leftovers.values()) {
                player.getWorld().dropItemNaturally(player.getLocation(), leftover);
            }
        }
    }

    private void cleanupSession(UUID sessionId) {
        TradeSession session = this.activeSessions.remove(sessionId);
        if (session != null) {
            this.playerToSession.remove(session.getPlayer1());
            this.playerToSession.remove(session.getPlayer2());
        }
    }

    private TradeRequest findPendingRequest(UUID initiator, UUID target) {
        return this.pendingRequests.values().stream().filter(request -> request.getInitiator().equals(initiator) && request.getTarget().equals(target) && request.getStatus() == TradeRequest.TradeRequestStatus.PENDING).findFirst().orElse(null);
    }

    public void cleanupExpiredRequests() {
        this.pendingRequests.entrySet().removeIf(entry -> {
            TradeRequest request = (TradeRequest)entry.getValue();
            if (request.isExpired()) {
                request.setStatus(TradeRequest.TradeRequestStatus.EXPIRED);
                Player initiator = Bukkit.getPlayer((UUID)request.getInitiator());
                if (initiator != null) {
                    Player target = Bukkit.getPlayer((UUID)request.getTarget());
                    String name = target != null ? target.getName() : "player";
                    initiator.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.request-expired", Collections.singletonMap("player", name)));
                }
                return true;
            }
            return false;
        });
    }
}

