/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.session;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class CreationSessionManager {
    private static final CreationSessionManager INSTANCE = new CreationSessionManager();
    private final Map<UUID, Session> sessions = new ConcurrentHashMap<UUID, Session>();

    public static CreationSessionManager get() {
        return INSTANCE;
    }

    public void start(UUID player, Mode mode) {
        this.sessions.put(player, new Session(player, mode));
    }

    public Session get(UUID player) {
        return this.sessions.get(player);
    }

    public void clear(UUID player) {
        this.sessions.remove(player);
    }

    public static class Session {
        public final UUID player;
        public final Mode mode;

        public Session(UUID player, Mode mode) {
            this.player = player;
            this.mode = mode;
        }
    }

    public static enum Mode {
        FIXED,
        AUCTION;

    }
}

