/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.session;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.model.TradeSession;
import org.texboobcat.globalMarketplace.service.TradeService;
import org.texboobcat.globalMarketplace.ui.TradeMenu;

public class MoneyInputSessionManager
implements Listener {
    private static MoneyInputSessionManager instance;
    private final Map<UUID, UUID> playerToSessionId = new ConcurrentHashMap<UUID, UUID>();

    private MoneyInputSessionManager() {
    }

    public static MoneyInputSessionManager get() {
        if (instance == null) {
            instance = new MoneyInputSessionManager();
        }
        return instance;
    }

    public void start(UUID playerId, UUID sessionId) {
        this.playerToSessionId.put(playerId, sessionId);
    }

    public void stop(UUID playerId) {
        this.playerToSessionId.remove(playerId);
    }

    public boolean isInSession(UUID playerId) {
        return this.playerToSessionId.containsKey(playerId);
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        BigDecimal amount;
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (!this.isInSession(playerId)) {
            return;
        }
        event.setCancelled(true);
        UUID sessionId = this.playerToSessionId.get(playerId);
        String input = event.getMessage().trim();
        if (input.equalsIgnoreCase("cancel")) {
            this.stop(playerId);
            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.money-cancelled"));
            GlobalMarketplacePlugin.getInstance().getServer().getScheduler().runTask((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                Player other;
                TradeService tradeService = GlobalMarketplacePlugin.getInstance().getTradeService();
                TradeSession session = tradeService.getTradeSession(sessionId);
                if (session != null && (other = GlobalMarketplacePlugin.getInstance().getServer().getPlayer(session.getOtherPlayer(playerId))) != null) {
                    new TradeMenu().open(other, sessionId);
                }
                new TradeMenu().open(player, sessionId);
            });
            return;
        }
        try {
            amount = new BigDecimal(input);
            if (amount.compareTo(BigDecimal.ZERO) < 0) {
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.money-negative"));
                return;
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.money-invalid"));
            return;
        }
        TradeService tradeService = GlobalMarketplacePlugin.getInstance().getTradeService();
        if (tradeService.setPlayerMoney(playerId, amount)) {
            this.stop(playerId);
            String amt = amount.setScale(2, RoundingMode.DOWN).toPlainString();
            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.money-set", Collections.singletonMap("amount", amt)));
            GlobalMarketplacePlugin.getInstance().getServer().getScheduler().runTask((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                Player other;
                TradeSession session = tradeService.getTradeSession(sessionId);
                if (session != null && (other = GlobalMarketplacePlugin.getInstance().getServer().getPlayer(session.getOtherPlayer(playerId))) != null) {
                    new TradeMenu().open(other, sessionId);
                }
                new TradeMenu().open(player, sessionId);
            });
        } else {
            Optional<BigDecimal> balOpt = tradeService.getBalance(playerId);
            String balStr = balOpt.map(b -> b.setScale(2, RoundingMode.DOWN).toPlainString()).orElse("unknown");
            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.money-set-failed", Collections.singletonMap("available", balStr)));
        }
    }
}

