/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.storage.file;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.texboobcat.globalMarketplace.repo.BalanceRepository;
import org.texboobcat.globalMarketplace.storage.JsonStore;

public class FileBalanceRepository
implements BalanceRepository {
    private final Path file;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<UUID, BigDecimal> pending;

    public FileBalanceRepository(Path file) throws IOException {
        this.file = file;
        Snapshot snap = JsonStore.read(file, Snapshot.class, new Snapshot());
        this.pending = snap.map != null ? snap.map : new HashMap<UUID, BigDecimal>();
    }

    private void persist() throws SQLException {
        this.lock.writeLock().lock();
        try {
            Snapshot snap = new Snapshot();
            snap.map = this.pending;
            try {
                JsonStore.writeAtomic(this.file, snap);
            }
            catch (IOException e) {
                throw new SQLException("Failed to write balances file", e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPending(UUID player, BigDecimal amount) throws SQLException {
        this.lock.writeLock().lock();
        try {
            BigDecimal cur = this.pending.getOrDefault(player, BigDecimal.ZERO);
            this.pending.put(player, cur.add(amount));
            this.persist();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public BigDecimal getPending(UUID player) throws SQLException {
        this.lock.readLock().lock();
        try {
            BigDecimal bigDecimal = this.pending.getOrDefault(player, BigDecimal.ZERO);
            return bigDecimal;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal tryDeductPending(UUID player, BigDecimal amount) throws SQLException {
        this.lock.writeLock().lock();
        try {
            BigDecimal toDeduct;
            BigDecimal cur = this.pending.getOrDefault(player, BigDecimal.ZERO);
            if (cur.compareTo(BigDecimal.ZERO) <= 0) {
                BigDecimal bigDecimal = BigDecimal.ZERO;
                return bigDecimal;
            }
            BigDecimal bigDecimal = toDeduct = amount == null || amount.compareTo(BigDecimal.ZERO) <= 0 || amount.compareTo(cur) > 0 ? cur : amount;
            if (toDeduct.compareTo(BigDecimal.ZERO) <= 0) {
                BigDecimal bigDecimal2 = BigDecimal.ZERO;
                return bigDecimal2;
            }
            this.pending.put(player, cur.subtract(toDeduct));
            this.persist();
            BigDecimal bigDecimal3 = toDeduct;
            return bigDecimal3;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public Optional<BigDecimal> getBalance(UUID player) {
        try {
            return Optional.of(this.getPending(player));
        }
        catch (SQLException e) {
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean transferBalance(UUID from, UUID to, BigDecimal amount) {
        this.lock.writeLock().lock();
        try {
            BigDecimal fromBalance = this.pending.getOrDefault(from, BigDecimal.ZERO);
            if (fromBalance.compareTo(amount) < 0) {
                boolean bl = false;
                return bl;
            }
            BigDecimal toBalance = this.pending.getOrDefault(to, BigDecimal.ZERO);
            this.pending.put(from, fromBalance.subtract(amount));
            this.pending.put(to, toBalance.add(amount));
            this.persist();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static class Snapshot {
        Map<UUID, BigDecimal> map = new HashMap<UUID, BigDecimal>();

        private Snapshot() {
        }
    }
}

