/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;

public class DiscordDiagnosticsMenu {
    public static String getTitle() {
        return "Discord Diagnostics";
    }

    public void open(Player player) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)45, (String)DiscordDiagnosticsMenu.getTitle());
        NamespacedKey keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fm = filler.getItemMeta();
        if (fm != null) {
            fm.setDisplayName(" ");
            filler.setItemMeta(fm);
        }
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, filler);
        }
        List list = GlobalMarketplacePlugin.getInstance().getConfig().getList("discord.webhooks");
        int slot = 0;
        if (list != null) {
            for (Object o : list) {
                List e;
                if (!(o instanceof Map)) continue;
                Map m = (Map)o;
                String name = m.get("name") != null ? String.valueOf(m.get("name")) : "webhook";
                String url = m.get("url") != null ? String.valueOf(m.get("url")) : "(missing url)";
                String events = "all";
                Object ev = m.get("events");
                if (ev instanceof List && !(e = (List)ev).isEmpty()) {
                    events = String.join((CharSequence)", ", e.stream().map(String::valueOf).toList());
                }
                String threadId = m.get("thread_id") != null ? String.valueOf(m.get("thread_id")) : "";
                ItemStack it = new ItemStack(Material.PAPER);
                ItemMeta im = it.getItemMeta();
                if (im != null) {
                    im.setDisplayName("\u00a7fWebhook: \u00a7a" + name);
                    ArrayList<Object> lore = new ArrayList<Object>();
                    lore.add("\u00a77URL: \u00a78" + this.redact(url));
                    lore.add("\u00a77Events: \u00a7f" + events);
                    if (!threadId.isEmpty()) {
                        lore.add("\u00a77Thread: \u00a7f" + threadId);
                    }
                    lore.add(" ");
                    lore.add("\u00a7aLeft-click: \u00a7fModify (edit events or delete)");
                    lore.add("\u00a7bRight-click: \u00a7fTest this webhook");
                    im.setLore(lore);
                    im.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)("discord_entry:" + name));
                    it.setItemMeta(im);
                }
                if (slot >= inv.getSize() - 9) continue;
                inv.setItem(slot++, it);
            }
        }
        int base = inv.getSize() - 9;
        ItemStack testAll = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta tM = testAll.getItemMeta();
        if (tM != null) {
            tM.setDisplayName("\u00a7aTest All Webhooks");
            tM.setLore(List.of("\u00a77Sends a test message to every configured webhook."));
            tM.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)"discord_test_all");
            testAll.setItemMeta(tM);
        }
        inv.setItem(base + 1, testAll);
        boolean dbg = false;
        try {
            dbg = GlobalMarketplacePlugin.getInstance().getConfig().getBoolean("discord.debug", false);
        }
        catch (Throwable url) {
            // empty catch block
        }
        ItemStack debug = new ItemStack(dbg ? Material.REDSTONE_TORCH : Material.LEVER);
        ItemMeta dM = debug.getItemMeta();
        if (dM != null) {
            dM.setDisplayName("\u00a76Debug: " + (dbg ? "ON" : "OFF"));
            dM.setLore(List.of("\u00a77When ON, webhook HTTP attempts and errors", "\u00a77are logged to console for troubleshooting."));
            dM.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)"discord_debug_toggle");
            debug.setItemMeta(dM);
        }
        inv.setItem(base + 3, debug);
        ItemStack reload = new ItemStack(Material.COMPARATOR);
        ItemMeta rM = reload.getItemMeta();
        if (rM != null) {
            rM.setDisplayName("\u00a7eReload Webhooks");
            rM.setLore(List.of("\u00a77Rebuilds the webhook service from config.yaml"));
            rM.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)"discord_reload");
            reload.setItemMeta(rM);
        }
        inv.setItem(base + 5, reload);
        ItemStack add = new ItemStack(Material.WRITABLE_BOOK);
        ItemMeta aM = add.getItemMeta();
        if (aM != null) {
            aM.setDisplayName("\u00a7bAdd Webhook");
            aM.setLore(List.of("\u00a77You will be prompted to use:", "\u00a7f/gmarket admin discord add <name> <url>"));
            aM.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)"discord_add");
            add.setItemMeta(aM);
        }
        inv.setItem(base + 7, add);
        ItemStack back = new ItemStack(Material.BARRIER);
        ItemMeta bM = back.getItemMeta();
        if (bM != null) {
            bM.setDisplayName("\u00a7cBack to Main");
            bM.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)"back_to_main");
            back.setItemMeta(bM);
        }
        inv.setItem(base + 8, back);
        player.openInventory(inv);
    }

    private String redact(String url) {
        if (url == null) {
            return "";
        }
        try {
            URL u = new URL(url);
            String host = u.getHost();
            Object path = u.getPath();
            if (path != null && ((String)path).length() > 16) {
                path = ((String)path).substring(0, ((String)path).length() - 16) + "********";
            }
            String q = u.getQuery();
            return host + (String)(path != null ? path : "") + (String)(q != null && !q.isEmpty() ? "?" + q : "");
        }
        catch (Throwable ignored) {
            return "(redacted)";
        }
    }
}

