/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.ui;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.integrations.DiscordWebhookService;

public class DiscordEventsMenu {
    public static final String TITLE_PREFIX = "Discord Events - ";

    public void open(Player player, String webhookName) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)36, (String)(TITLE_PREFIX + webhookName));
        NamespacedKey keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fm = filler.getItemMeta();
        if (fm != null) {
            fm.setDisplayName(" ");
            filler.setItemMeta(fm);
        }
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, filler);
        }
        Set<String> enabled = this.currentEnabledEvents(webhookName);
        boolean allEnabled = enabled == null || enabled.isEmpty() || enabled.size() == DiscordWebhookService.EventType.values().length;
        int[] slots = new int[]{10, 11, 12, 13, 14, 15, 16};
        DiscordWebhookService.EventType[] values = DiscordWebhookService.EventType.values();
        for (int i = 0; i < values.length && i < slots.length; ++i) {
            DiscordWebhookService.EventType t = values[i];
            boolean isOn = allEnabled || enabled.contains(t.name());
            ItemStack it = new ItemStack(isOn ? Material.LIME_DYE : Material.GRAY_DYE);
            ItemMeta im = it.getItemMeta();
            if (im != null) {
                String pretty = this.toTitle(t.name());
                im.setDisplayName((isOn ? "\u00a7a" : "\u00a77") + pretty);
                ArrayList<CallSite> lore = new ArrayList<CallSite>();
                lore.add((CallSite)((Object)("\u00a77Click to " + (isOn ? "\u00a7cdisable" : "\u00a7aenable"))));
                im.setLore(lore);
                im.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)("discord_ev_toggle:" + webhookName + ":" + t.name()));
                it.setItemMeta(im);
            }
            inv.setItem(slots[i], it);
        }
        ItemStack all = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta am = all.getItemMeta();
        if (am != null) {
            am.setDisplayName("\u00a7aEnable All");
            am.setLore(List.of("\u00a77Click to enable all events for this webhook"));
            am.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)("discord_ev_allon:" + webhookName));
            all.setItemMeta(am);
        }
        inv.setItem(28, all);
        ItemStack back = new ItemStack(Material.BARRIER);
        ItemMeta bm = back.getItemMeta();
        if (bm != null) {
            bm.setDisplayName("\u00a7cBack");
            bm.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)("discord_ev_back:" + webhookName));
            back.setItemMeta(bm);
        }
        inv.setItem(34, back);
        player.openInventory(inv);
    }

    private Set<String> currentEnabledEvents(String name) {
        FileConfiguration cfg = GlobalMarketplacePlugin.getInstance().getConfig();
        List list = cfg.getList("discord.webhooks");
        if (list == null) {
            return null;
        }
        for (Object o : list) {
            Map m;
            String nm;
            if (!(o instanceof Map) || (nm = (m = (Map)o).get("name") != null ? String.valueOf(m.get("name")) : null) == null || !nm.equalsIgnoreCase(name)) continue;
            Object raw = m.get("events");
            if (!(raw instanceof List)) {
                return new LinkedHashSet<String>();
            }
            List ev = (List)raw;
            if (ev.isEmpty()) {
                return new LinkedHashSet<String>();
            }
            LinkedHashSet<String> out = new LinkedHashSet<String>();
            for (Object e : ev) {
                if (e == null) continue;
                out.add(String.valueOf(e).toUpperCase(Locale.ROOT));
            }
            return out;
        }
        return null;
    }

    private String toTitle(String enumName) {
        String lower = enumName.toLowerCase(Locale.ROOT).replace('_', ' ');
        String[] parts = lower.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            sb.append(Character.toUpperCase(p.charAt(0))).append(p.substring(1)).append(' ');
        }
        return sb.toString().trim();
    }
}

