/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.ui;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.integrations.BedrockMenuAdapter;
import org.texboobcat.globalMarketplace.integrations.DiscordWebhookService;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.model.ListingType;
import org.texboobcat.globalMarketplace.model.TradeSession;
import org.texboobcat.globalMarketplace.service.MarketplaceService;
import org.texboobcat.globalMarketplace.service.TradeService;
import org.texboobcat.globalMarketplace.session.MoneyInputSessionManager;
import org.texboobcat.globalMarketplace.session.SearchSessionManager;
import org.texboobcat.globalMarketplace.ui.AuctionDurationMenu;
import org.texboobcat.globalMarketplace.ui.AuctionMenu;
import org.texboobcat.globalMarketplace.ui.DiscordDiagnosticsMenu;
import org.texboobcat.globalMarketplace.ui.DiscordEventsMenu;
import org.texboobcat.globalMarketplace.ui.DiscordWebhookModifyMenu;
import org.texboobcat.globalMarketplace.ui.GuiConfig;
import org.texboobcat.globalMarketplace.ui.ListMenu;
import org.texboobcat.globalMarketplace.ui.MainMenu;
import org.texboobcat.globalMarketplace.ui.PriceSelectionMenu;
import org.texboobcat.globalMarketplace.ui.ServerShopMenu;
import org.texboobcat.globalMarketplace.ui.TradeMenu;
import org.texboobcat.globalMarketplace.util.ItemSerializer;

public class GuiListener
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        MarketplaceService svc;
        String action;
        List list;
        FileConfiguration cfg;
        String name;
        GlobalMarketplacePlugin plugin;
        String action2;
        NamespacedKey keyAction;
        boolean ok;
        NamespacedKey keyAction2;
        ItemMeta meta;
        ItemStack item;
        Player player;
        if (event.getView() == null) {
            return;
        }
        String title = event.getView().getTitle();
        if (MainMenu.getTitle().equals(title)) {
            event.setCancelled(true);
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                return;
            }
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            NamespacedKey key = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_listing");
            keyAction2 = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            NamespacedKey keyPage = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_page");
            NamespacedKey keyQuery = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_query");
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            String action3 = (String)pdc.get(keyAction2, PersistentDataType.STRING);
            if ("open_list_menu".equals(action3)) {
                BedrockMenuAdapter.openListMenu(player);
                return;
            }
            if ("page_prev".equals(action3) || "page_next".equals(action3)) {
                Integer page = (Integer)pdc.get(keyPage, PersistentDataType.INTEGER);
                String query = (String)pdc.get(keyQuery, PersistentDataType.STRING);
                if (page == null) {
                    page = 0;
                }
                BedrockMenuAdapter.openMainMenu(player, Math.max(0, page), query);
                return;
            }
            if ("open_search".equals(action3)) {
                SearchSessionManager.get().start(player.getUniqueId());
                player.closeInventory();
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("ui.search-prompt"));
                return;
            }
            if ("open_servershop".equals(action3)) {
                BedrockMenuAdapter.openServerShopMenu(player);
                return;
            }
            String uuidStr = (String)pdc.get(key, PersistentDataType.STRING);
            if (uuidStr == null) {
                return;
            }
            try {
                UUID listingUuid = UUID.fromString(uuidStr);
                MarketplaceService svc2 = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                if (svc2 == null) {
                    return;
                }
                Optional<Listing> serverOpt = svc2.getServerListing(listingUuid);
                if (serverOpt.isPresent()) {
                    Listing serverListing = serverOpt.get();
                    if (event.getClick() == ClickType.RIGHT) {
                        if (player.hasPermission("globalmarketplace.admin.servershop")) {
                            boolean removed = svc2.removeServerListing(listingUuid);
                            if (removed) {
                                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.removed-ok"));
                            } else {
                                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.remove-failed"));
                            }
                            BedrockMenuAdapter.openMainMenu(player);
                        } else {
                            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.remove-no-permission"));
                        }
                        return;
                    }
                    boolean ok2 = svc2.purchaseServerListing(player.getUniqueId(), listingUuid);
                    if (ok2) {
                        int delivered = svc2.claimDeliveries(player, 36);
                        if (delivered > 0) {
                            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("purchase.success-delivered"));
                        } else {
                            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("purchase.success-claim"));
                        }
                        player.closeInventory();
                    } else {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("purchase.failed-funds"));
                    }
                    return;
                }
                Optional<Listing> opt = svc2.getListing(listingUuid);
                if (opt.isEmpty()) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("listing.unavailable"));
                    return;
                }
                Listing l = opt.get();
                if (event.getClick() == ClickType.RIGHT) {
                    if (l.getSellerUuid().equals(player.getUniqueId())) {
                        if (!player.hasPermission("globalmarketplace.cancel")) {
                            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("listing.cancel-no-permission"));
                            return;
                        }
                        boolean cancelled = svc2.cancelListing(player.getUniqueId(), listingUuid);
                        if (cancelled) {
                            int delivered = svc2.claimDeliveries(player, 36);
                            if (delivered > 0) {
                                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("listing.cancel-returned"));
                            } else {
                                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("listing.cancel-claim"));
                            }
                            BedrockMenuAdapter.openMainMenu(player);
                        } else {
                            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("listing.cancel-failed"));
                        }
                        return;
                    }
                    if (player.hasPermission("globalmarketplace.admin.remove")) {
                        boolean removed = svc2.adminRemoveListingReturn(listingUuid);
                        if (removed) {
                            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("listing.admin-removed-returned"));
                        } else {
                            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("listing.admin-remove-failed"));
                        }
                        BedrockMenuAdapter.openMainMenu(player);
                        return;
                    }
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("listing.remove-denied"));
                    return;
                }
                if (l.getType() == ListingType.FIXED) {
                    ok = svc2.purchaseFixed(player.getUniqueId(), listingUuid);
                    if (ok) {
                        int delivered = svc2.claimDeliveries(player, 36);
                        if (delivered > 0) {
                            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("purchase.success-delivered"));
                        } else {
                            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("purchase.success-claim"));
                        }
                        player.closeInventory();
                    } else {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("purchase.failed-funds"));
                    }
                } else if (l.getType() == ListingType.AUCTION) {
                    new AuctionMenu().open(player, listingUuid);
                } else {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("listing.cannot-purchase-here"));
                }
            }
            catch (IllegalArgumentException listingUuid) {
                // empty catch block
            }
        }
        if (DiscordDiagnosticsMenu.getTitle().equals(title)) {
            event.setCancelled(true);
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            action2 = (String)meta.getPersistentDataContainer().get(keyAction, PersistentDataType.STRING);
            if (action2 == null) {
                return;
            }
            plugin = GlobalMarketplacePlugin.getInstance();
            if (action2.startsWith("discord_entry:")) {
                name = action2.substring("discord_entry:".length());
                if (event.getClick() == ClickType.RIGHT) {
                    DiscordWebhookService svc3 = plugin.getDiscordService();
                    if (svc3 == null) {
                        player.sendMessage("\u00a7cNo webhooks configured.");
                        return;
                    }
                    svc3.ping(name, "Test ping from " + player.getName());
                    player.sendMessage("\u00a7aSent test ping to \u00a7f" + name);
                    return;
                }
                new DiscordWebhookModifyMenu().open(player, name);
                return;
            }
            if ("discord_test_all".equals(action2)) {
                DiscordWebhookService svc4 = plugin.getDiscordService();
                if (svc4 == null) {
                    player.sendMessage("\u00a7cNo webhooks configured.");
                    return;
                }
                svc4.ping(null, "Test ping (all) from " + player.getName());
                player.sendMessage("\u00a7aSent test pings to all configured webhooks.");
                return;
            }
            if ("discord_debug_toggle".equals(action2)) {
                FileConfiguration cfg2 = plugin.getConfig();
                boolean cur = false;
                try {
                    cur = cfg2.getBoolean("discord.debug", false);
                }
                catch (Throwable action3) {
                    // empty catch block
                }
                cfg2.set("discord.debug", (Object)(!cur ? 1 : 0));
                try {
                    plugin.saveConfig();
                }
                catch (Exception action3) {
                    // empty catch block
                }
                player.sendMessage("\u00a76Discord debug is now \u00a7e" + (!cur ? "ON" : "OFF"));
                new DiscordDiagnosticsMenu().open(player);
                return;
            }
            if ("discord_reload".equals(action2)) {
                plugin.rebuildDiscordServiceFromConfig();
                player.sendMessage("\u00a7eDiscord webhook service reloaded from config.");
                new DiscordDiagnosticsMenu().open(player);
                return;
            }
            if ("discord_add".equals(action2)) {
                player.closeInventory();
                player.sendMessage("\u00a7bUse: \u00a7f/gmarket admin discord add <name> <url>");
                return;
            }
            if ("back_to_main".equals(action2)) {
                BedrockMenuAdapter.openMainMenu(player);
                return;
            }
        }
        if (title != null && title.startsWith("Discord Webhook - ")) {
            event.setCancelled(true);
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            action2 = (String)meta.getPersistentDataContainer().get(keyAction, PersistentDataType.STRING);
            if (action2 == null) {
                return;
            }
            plugin = GlobalMarketplacePlugin.getInstance();
            if (action2.startsWith("discord_mod_edit:")) {
                name = action2.substring("discord_mod_edit:".length());
                new DiscordEventsMenu().open(player, name);
                return;
            }
            if (action2.startsWith("discord_mod_delete:")) {
                name = action2.substring("discord_mod_delete:".length());
                cfg = plugin.getConfig();
                list = cfg.getList("discord.webhooks");
                ArrayList newList = new ArrayList();
                boolean removed = false;
                if (list != null) {
                    for (Object o : list) {
                        Object nm;
                        if (o instanceof Map && (nm = ((Map)o).get("name")) != null && nm.toString().equalsIgnoreCase(name)) {
                            removed = true;
                            continue;
                        }
                        newList.add(o);
                    }
                }
                cfg.set("discord.webhooks", newList);
                try {
                    plugin.saveConfig();
                }
                catch (Exception svc2) {
                    // empty catch block
                }
                plugin.rebuildDiscordServiceFromConfig();
                player.sendMessage(removed ? "\u00a7aRemoved webhook \u00a7f" + name : "\u00a7cWebhook not found: \u00a7f" + name);
                new DiscordDiagnosticsMenu().open(player);
                return;
            }
            if (action2.equals("discord_mod_back")) {
                new DiscordDiagnosticsMenu().open(player);
                return;
            }
        }
        if (title != null && title.startsWith("Discord Events - ")) {
            event.setCancelled(true);
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            action2 = (String)meta.getPersistentDataContainer().get(keyAction, PersistentDataType.STRING);
            if (action2 == null) {
                return;
            }
            plugin = GlobalMarketplacePlugin.getInstance();
            if (action2.startsWith("discord_ev_toggle:")) {
                String[] parts = action2.split(":", 3);
                if (parts.length == 3) {
                    String name2 = parts[1];
                    String ev = parts[2];
                    FileConfiguration cfg3 = plugin.getConfig();
                    List list2 = cfg3.getList("discord.webhooks");
                    if (list2 == null) {
                        return;
                    }
                    for (int i = 0; i < list2.size(); ++i) {
                        String key;
                        String nm2;
                        Object o;
                        o = list2.get(i);
                        if (!(o instanceof Map)) continue;
                        LinkedHashMap m = new LinkedHashMap((Map)o);
                        String string = nm2 = m.get("name") != null ? String.valueOf(m.get("name")) : null;
                        if (nm2 == null || !nm2.equalsIgnoreCase(name2)) continue;
                        LinkedHashSet<String> enabled = new LinkedHashSet<String>();
                        List evList = null;
                        Object raw = m.get("events");
                        if (raw instanceof List) {
                            evList = (List)raw;
                        }
                        for (DiscordWebhookService.EventType t : DiscordWebhookService.EventType.values()) {
                            enabled.add(t.name());
                        }
                        if (evList != null && !evList.isEmpty()) {
                            enabled.clear();
                            for (Object e : evList) {
                                if (e == null) continue;
                                enabled.add(String.valueOf(e).toUpperCase(Locale.ROOT));
                            }
                        }
                        if (enabled.contains(key = ev.toUpperCase(Locale.ROOT))) {
                            enabled.remove(key);
                        } else {
                            enabled.add(key);
                        }
                        if (enabled.size() == DiscordWebhookService.EventType.values().length) {
                            m.put("events", new ArrayList());
                        } else {
                            m.put("events", new ArrayList(enabled));
                        }
                        ArrayList newList = new ArrayList(list2);
                        newList.set(i, m);
                        cfg3.set("discord.webhooks", newList);
                        try {
                            plugin.saveConfig();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        plugin.rebuildDiscordServiceFromConfig();
                        player.sendMessage("\u00a77Updated events for \u00a7f" + name2);
                        new DiscordEventsMenu().open(player, name2);
                        return;
                    }
                }
                return;
            }
            if (action2.startsWith("discord_ev_allon:")) {
                name = action2.substring("discord_ev_allon:".length());
                cfg = plugin.getConfig();
                list = cfg.getList("discord.webhooks");
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        String nm;
                        Object o = list.get(i);
                        if (!(o instanceof Map)) continue;
                        LinkedHashMap m = new LinkedHashMap((Map)o);
                        String string = nm = m.get("name") != null ? String.valueOf(m.get("name")) : null;
                        if (nm == null || !nm.equalsIgnoreCase(name)) continue;
                        m.put("events", new ArrayList());
                        ArrayList newList = new ArrayList(list);
                        newList.set(i, m);
                        cfg.set("discord.webhooks", newList);
                        try {
                            plugin.saveConfig();
                        }
                        catch (Exception nm2) {
                            // empty catch block
                        }
                        plugin.rebuildDiscordServiceFromConfig();
                        player.sendMessage("\u00a77Enabled all events for \u00a7f" + name);
                        new DiscordEventsMenu().open(player, name);
                        return;
                    }
                }
                return;
            }
            if (action2.startsWith("discord_ev_back:")) {
                new DiscordDiagnosticsMenu().open(player);
                return;
            }
        }
        if (title != null && title.startsWith("Auction: ")) {
            event.setCancelled(true);
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                return;
            }
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            NamespacedKey keyListing = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_listing");
            keyAction2 = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            String uuidStr = (String)pdc.get(keyListing, PersistentDataType.STRING);
            action = (String)pdc.get(keyAction2, PersistentDataType.STRING);
            if (uuidStr == null || action == null) {
                return;
            }
            try {
                UUID listingUuid = UUID.fromString(uuidStr);
                int inc = 0;
                if (action.startsWith("bid:+")) {
                    try {
                        inc = Integer.parseInt(action.substring(5));
                    }
                    catch (NumberFormatException o) {
                        // empty catch block
                    }
                }
                if (inc <= 0) {
                    return;
                }
                svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                if (svc == null) {
                    return;
                }
                Optional<Listing> opt = svc.getListing(listingUuid);
                if (opt.isEmpty()) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("errors.listing-not-found"));
                    return;
                }
                Listing l = opt.get();
                BigDecimal base = l.getCurrentBid() != null ? l.getCurrentBid() : l.getPrice();
                BigDecimal amount = base.add(new BigDecimal(inc));
                ok = svc.placeBid(listingUuid, player.getUniqueId(), amount);
                String currencySymbol = GuiConfig.getInstance().getCurrencySymbol();
                if (ok) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("bid.placed-for", Collections.singletonMap("amount", currencySymbol + String.valueOf(amount))));
                } else {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("bid.rejected"));
                }
                new AuctionMenu().open(player, listingUuid);
            }
            catch (IllegalArgumentException listingUuid) {
                // empty catch block
            }
        }
        if (ListMenu.getTitle().equals(title)) {
            event.setCancelled(true);
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                return;
            }
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            action2 = (String)meta.getPersistentDataContainer().get(keyAction, PersistentDataType.STRING);
            if (action2 == null) {
                return;
            }
            if (action2.equals("list_fixed")) {
                inHand = player.getInventory().getItemInMainHand();
                if (inHand == null || inHand.getType() == Material.AIR) {
                    player.closeInventory();
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("sell.hold-item"));
                    return;
                }
                new PriceSelectionMenu().open(player);
            } else if (action2.equals("list_auction")) {
                inHand = player.getInventory().getItemInMainHand();
                if (inHand == null || inHand.getType() == Material.AIR) {
                    player.closeInventory();
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("auction.hold-item"));
                    return;
                }
                new AuctionDurationMenu().open(player);
            }
        }
        if (ServerShopMenu.getTitle().equals(title)) {
            event.setCancelled(true);
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                return;
            }
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            NamespacedKey keyPage = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_page");
            NamespacedKey keyListing = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_listing");
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            action = (String)pdc.get(keyAction, PersistentDataType.STRING);
            if ("servershop_prev".equals(action) || "servershop_next".equals(action)) {
                Integer page = (Integer)pdc.get(keyPage, PersistentDataType.INTEGER);
                if (page == null) {
                    page = 0;
                }
                BedrockMenuAdapter.openServerShopMenu(player, Math.max(0, page));
                return;
            }
            if ("back_to_main".equals(action)) {
                BedrockMenuAdapter.openMainMenu(player);
                return;
            }
            String uuidStr = (String)pdc.get(keyListing, PersistentDataType.STRING);
            if (uuidStr == null) {
                return;
            }
            try {
                UUID listingUuid = UUID.fromString(uuidStr);
                svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                if (svc == null) {
                    return;
                }
                Optional<Listing> serverOpt = svc.getServerListing(listingUuid);
                if (serverOpt.isEmpty()) {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.unavailable"));
                    return;
                }
                if (event.getClick() == ClickType.RIGHT) {
                    if (player.hasPermission("globalmarketplace.admin.servershop")) {
                        boolean removed = svc.removeServerListing(listingUuid);
                        if (removed) {
                            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.removed-ok"));
                        } else {
                            player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.remove-failed"));
                        }
                        new ServerShopMenu().open(player, 0);
                    } else {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("servershop.remove-no-permission"));
                    }
                    return;
                }
                boolean ok3 = svc.purchaseServerListing(player.getUniqueId(), listingUuid);
                if (ok3) {
                    int delivered = svc.claimDeliveries(player, 36);
                    if (delivered > 0) {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("purchase.success-delivered"));
                    } else {
                        player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("purchase.success-claim"));
                    }
                    player.closeInventory();
                } else {
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("purchase.failed-funds"));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (PriceSelectionMenu.getTitle().equals(title)) {
            event.setCancelled(true);
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                return;
            }
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            action2 = (String)meta.getPersistentDataContainer().get(keyAction, PersistentDataType.STRING);
            if (action2 == null) {
                return;
            }
            if (action2.equals("back")) {
                new PriceSelectionMenu().clearPrice(player.getUniqueId());
                new ListMenu().open(player);
                return;
            }
            if (action2.equals("confirm")) {
                this.handlePriceConfirm(player);
                return;
            }
            if (action2.startsWith("adjust_price:")) {
                try {
                    int adjustment = Integer.parseInt(action2.substring(13));
                    new PriceSelectionMenu().adjustPrice(player, adjustment);
                }
                catch (NumberFormatException adjustment) {
                    // empty catch block
                }
                return;
            }
        }
        if (AuctionDurationMenu.getTitle().equals(title)) {
            event.setCancelled(true);
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                return;
            }
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            action2 = (String)meta.getPersistentDataContainer().get(keyAction, PersistentDataType.STRING);
            if (action2 == null) {
                return;
            }
            if (action2.equals("back")) {
                new AuctionDurationMenu().clearSettings(player.getUniqueId());
                new ListMenu().open(player);
                return;
            }
            if (action2.equals("confirm")) {
                this.handleAuctionConfirm(player);
                return;
            }
            if (action2.startsWith("adjust_duration:")) {
                try {
                    int adjustment = Integer.parseInt(action2.substring(16));
                    new AuctionDurationMenu().adjustDuration(player, adjustment);
                }
                catch (NumberFormatException adjustment) {
                    // empty catch block
                }
                return;
            }
            if (action2.startsWith("adjust_price:")) {
                try {
                    int adjustment = Integer.parseInt(action2.substring(13));
                    new AuctionDurationMenu().adjustPrice(player, adjustment);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return;
            }
        }
        if (title != null && title.startsWith("Trade: ")) {
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            player = (Player)event.getWhoClicked();
            int topSize = event.getView().getTopInventory().getSize();
            if (event.isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction() || event.getClick() == ClickType.DOUBLE_CLICK || event.getHotbarButton() >= 0) {
                event.setCancelled(true);
                return;
            }
            if (event.getRawSlot() < topSize) {
                event.setCancelled(true);
                this.handleTradeMenuClick(event, player);
                return;
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.getView() == null) {
            return;
        }
        String title = event.getView().getTitle();
        if (MainMenu.getTitle().equals(title)) {
            event.setCancelled(true);
        }
        if (title != null && title.startsWith("Auction: ")) {
            event.setCancelled(true);
        }
        if (PriceSelectionMenu.getTitle().equals(title)) {
            event.setCancelled(true);
        }
        if (AuctionDurationMenu.getTitle().equals(title)) {
            event.setCancelled(true);
        }
        if (ListMenu.getTitle().equals(title)) {
            event.setCancelled(true);
        }
        if (title != null && title.startsWith("Trade: ")) {
            int[] nArray;
            boolean targetsTop = false;
            int topSize = event.getView().getTopInventory().getSize();
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int raw = (Integer)iterator.next();
                if (raw >= topSize) continue;
                targetsTop = true;
                break;
            }
            if (!targetsTop) {
                return;
            }
            event.setCancelled(true);
            if (!(event.getWhoClicked() instanceof Player)) {
                return;
            }
            Player player = (Player)event.getWhoClicked();
            TradeService tradeService = GlobalMarketplacePlugin.getInstance().getTradeService();
            TradeSession session = tradeService.getPlayerTradeSession(player.getUniqueId());
            if (session == null) {
                return;
            }
            if (session.isPlayer1(player.getUniqueId())) {
                int[] nArray2 = new int[16];
                nArray2[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray2[3] = 3;
                nArray2[4] = 9;
                nArray2[5] = 10;
                nArray2[6] = 11;
                nArray2[7] = 12;
                nArray2[8] = 18;
                nArray2[9] = 19;
                nArray2[10] = 20;
                nArray2[11] = 21;
                nArray2[12] = 27;
                nArray2[13] = 28;
                nArray2[14] = 29;
                nArray = nArray2;
                nArray2[15] = 30;
            } else {
                int[] nArray3 = new int[16];
                nArray3[0] = 5;
                nArray3[1] = 6;
                nArray3[2] = 7;
                nArray3[3] = 8;
                nArray3[4] = 14;
                nArray3[5] = 15;
                nArray3[6] = 16;
                nArray3[7] = 17;
                nArray3[8] = 23;
                nArray3[9] = 24;
                nArray3[10] = 25;
                nArray3[11] = 26;
                nArray3[12] = 32;
                nArray3[13] = 33;
                nArray3[14] = 34;
                nArray = nArray3;
                nArray3[15] = 35;
            }
            int[] playerSlots = nArray;
            HashSet<Integer> allowed = new HashSet<Integer>();
            for (int s : playerSlots) {
                allowed.add(s);
            }
            boolean valid = true;
            Iterator iterator2 = event.getRawSlots().iterator();
            while (iterator2.hasNext()) {
                int raw = (Integer)iterator2.next();
                if (raw >= event.getView().getTopInventory().getSize()) {
                    valid = false;
                    break;
                }
                if (allowed.contains(raw)) continue;
                valid = false;
                break;
            }
            if (!valid) {
                return;
            }
            ItemStack cursor = event.getOldCursor();
            if (cursor != null && !cursor.getType().isAir()) {
                ItemStack toAdd = cursor.clone();
                if (tradeService.addItemToTrade(player.getUniqueId(), toAdd)) {
                    event.getView().setCursor(null);
                    this.refreshTradeForBoth(session, player.getUniqueId());
                }
            }
        }
    }

    private void handleTradeMenuClick(InventoryClickEvent event, Player player) {
        ItemStack item;
        int[] nArray;
        TradeService tradeService = GlobalMarketplacePlugin.getInstance().getTradeService();
        TradeSession session = tradeService.getPlayerTradeSession(player.getUniqueId());
        if (session == null) {
            return;
        }
        if (session.isPlayer1(player.getUniqueId())) {
            int[] nArray2 = new int[16];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray2[2] = 2;
            nArray2[3] = 3;
            nArray2[4] = 9;
            nArray2[5] = 10;
            nArray2[6] = 11;
            nArray2[7] = 12;
            nArray2[8] = 18;
            nArray2[9] = 19;
            nArray2[10] = 20;
            nArray2[11] = 21;
            nArray2[12] = 27;
            nArray2[13] = 28;
            nArray2[14] = 29;
            nArray = nArray2;
            nArray2[15] = 30;
        } else {
            int[] nArray3 = new int[16];
            nArray3[0] = 5;
            nArray3[1] = 6;
            nArray3[2] = 7;
            nArray3[3] = 8;
            nArray3[4] = 14;
            nArray3[5] = 15;
            nArray3[6] = 16;
            nArray3[7] = 17;
            nArray3[8] = 23;
            nArray3[9] = 24;
            nArray3[10] = 25;
            nArray3[11] = 26;
            nArray3[12] = 32;
            nArray3[13] = 33;
            nArray3[14] = 34;
            nArray = nArray3;
            nArray3[15] = 35;
        }
        int[] playerSlots = nArray;
        HashSet<Integer> allowed = new HashSet<Integer>();
        for (int s : playerSlots) {
            allowed.add(s);
        }
        int rawSlot = event.getRawSlot();
        if (rawSlot < event.getView().getTopInventory().getSize() && allowed.contains(rawSlot)) {
            ItemStack cursor = event.getCursor();
            ItemStack current = event.getCurrentItem();
            if ((current == null || current.getType().isAir()) && cursor != null && !cursor.getType().isAir()) {
                event.setCancelled(true);
                ItemStack toAdd = cursor.clone();
                if (tradeService.addItemToTrade(player.getUniqueId(), toAdd)) {
                    event.getView().setCursor(null);
                    this.refreshTradeForBoth(session, player.getUniqueId());
                }
                return;
            }
        }
        if ((item = event.getCurrentItem()) == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        NamespacedKey actionKey = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "trade_action");
        String action = (String)meta.getPersistentDataContainer().get(actionKey, PersistentDataType.STRING);
        if (action == null) {
            return;
        }
        switch (action) {
            case "ready": {
                tradeService.setPlayerReady(player.getUniqueId(), true);
                this.refreshTradeForBoth(session, player.getUniqueId());
                break;
            }
            case "unready": {
                tradeService.setPlayerReady(player.getUniqueId(), false);
                this.refreshTradeForBoth(session, player.getUniqueId());
                break;
            }
            case "confirm": {
                if (!tradeService.confirmTrade(player.getUniqueId())) break;
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.confirmed"));
                this.refreshTradeForBoth(session, player.getUniqueId());
                break;
            }
            case "unconfirm": {
                if (session.isPlayer1(player.getUniqueId())) {
                    session.setPlayer1Confirmed(false);
                } else {
                    session.setPlayer2Confirmed(false);
                }
                this.refreshTradeForBoth(session, player.getUniqueId());
                break;
            }
            case "cancel": {
                tradeService.cancelTrade(player.getUniqueId());
                break;
            }
            case "set_money": {
                MoneyInputSessionManager.get().start(player.getUniqueId(), session.getSessionId());
                player.closeInventory();
                player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.enter-money-prompt"));
                break;
            }
            default: {
                if (!action.startsWith("remove_item:")) break;
                try {
                    ItemStack toReturn;
                    int index = Integer.parseInt(action.substring(12));
                    List<ItemStack> list = session.isPlayer1(player.getUniqueId()) ? session.getPlayer1Items() : session.getPlayer2Items();
                    ItemStack itemStack = toReturn = index >= 0 && index < list.size() ? list.get(index).clone() : null;
                    if (!tradeService.removeItemFromTrade(player.getUniqueId(), index)) break;
                    if (toReturn != null) {
                        HashMap leftovers = player.getInventory().addItem(new ItemStack[]{toReturn});
                        for (ItemStack left : leftovers.values()) {
                            player.getWorld().dropItemNaturally(player.getLocation(), left);
                        }
                    }
                    player.sendMessage(GlobalMarketplacePlugin.getInstance().msg("trade.item-removed"));
                    this.refreshTradeForBoth(session, player.getUniqueId());
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void refreshTradeForBoth(TradeSession session, UUID actor) {
        Player self;
        Player other = Bukkit.getPlayer((UUID)session.getOtherPlayer(actor));
        if (other != null && other.isOnline()) {
            new TradeMenu().open(other, session.getSessionId());
        }
        if ((self = Bukkit.getPlayer((UUID)actor)) != null && self.isOnline()) {
            new TradeMenu().open(self, session.getSessionId());
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player;
        String title;
        String string = title = event.getView() == null ? null : event.getView().getTitle();
        if (title != null && title.startsWith("Trade: ") && event.getPlayer() instanceof Player) {
            player = (Player)event.getPlayer();
            GlobalMarketplacePlugin.getInstance().getServer().getScheduler().runTaskLater((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                String current;
                String string = current = player.getOpenInventory() != null ? player.getOpenInventory().getTitle() : null;
                if (current != null && current.startsWith("Trade: ")) {
                    return;
                }
                if (MoneyInputSessionManager.get().isInSession(player.getUniqueId())) {
                    return;
                }
                TradeService tradeService = GlobalMarketplacePlugin.getInstance().getTradeService();
                TradeSession session = tradeService.getPlayerTradeSession(player.getUniqueId());
                if (session != null && session.getStatus() == TradeSession.TradeSessionStatus.ACTIVE) {
                    tradeService.cancelTrade(player.getUniqueId());
                }
            }, 1L);
        }
        if (PriceSelectionMenu.getTitle().equals(title) && event.getPlayer() instanceof Player) {
            player = (Player)event.getPlayer();
            GlobalMarketplacePlugin.getInstance().getServer().getScheduler().runTaskLater((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                String current;
                String string = current = player.getOpenInventory() != null ? player.getOpenInventory().getTitle() : null;
                if (!PriceSelectionMenu.getTitle().equals(current)) {
                    new PriceSelectionMenu().clearPrice(player.getUniqueId());
                }
            }, 1L);
        }
        if (AuctionDurationMenu.getTitle().equals(title) && event.getPlayer() instanceof Player) {
            player = (Player)event.getPlayer();
            GlobalMarketplacePlugin.getInstance().getServer().getScheduler().runTaskLater((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
                String current;
                String string = current = player.getOpenInventory() != null ? player.getOpenInventory().getTitle() : null;
                if (!AuctionDurationMenu.getTitle().equals(current)) {
                    new AuctionDurationMenu().clearSettings(player.getUniqueId());
                }
            }, 1L);
        }
    }

    private void handlePriceConfirm(Player player) {
        PriceSelectionMenu menu = new PriceSelectionMenu();
        BigDecimal price = menu.getCurrentPrice(player.getUniqueId());
        if (price == null || price.compareTo(BigDecimal.ZERO) <= 0) {
            player.sendMessage("\u00a7cInvalid price. Please set a price greater than 0.");
            return;
        }
        ItemStack inHand = player.getInventory().getItemInMainHand();
        if (inHand == null || inHand.getType() == Material.AIR) {
            player.closeInventory();
            player.sendMessage("\u00a7cYou must hold an item in your main hand to list it.");
            menu.clearPrice(player.getUniqueId());
            return;
        }
        MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
        if (svc == null) {
            player.sendMessage("\u00a7cMarketplace unavailable.");
            player.closeInventory();
            menu.clearPrice(player.getUniqueId());
            return;
        }
        try {
            ItemMeta liveMeta;
            NamespacedKey tokenKey = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_item_id");
            UUID listingId = UUID.randomUUID();
            ItemStack toSerialize = inHand.clone();
            ItemMeta cloneMeta = toSerialize.getItemMeta();
            if (cloneMeta != null) {
                cloneMeta.getPersistentDataContainer().set(tokenKey, PersistentDataType.STRING, (Object)listingId.toString());
                toSerialize.setItemMeta(cloneMeta);
            }
            if ((liveMeta = inHand.getItemMeta()) != null) {
                liveMeta.getPersistentDataContainer().set(tokenKey, PersistentDataType.STRING, (Object)listingId.toString());
                inHand.setItemMeta(liveMeta);
            }
            String serialized = ItemSerializer.toBase64(toSerialize);
            Optional<UUID> created = svc.createFixedListing(listingId, player.getUniqueId(), serialized, price);
            if (created.isPresent()) {
                ItemMeta cm;
                ItemStack current = player.getInventory().getItemInMainHand();
                boolean tokenOk = false;
                if (current != null && (cm = current.getItemMeta()) != null) {
                    String val = (String)cm.getPersistentDataContainer().get(tokenKey, PersistentDataType.STRING);
                    tokenOk = listingId.toString().equals(val);
                }
                if (!tokenOk) {
                    player.sendMessage("\u00a7cListing aborted: held item changed during creation.");
                    player.closeInventory();
                    menu.clearPrice(player.getUniqueId());
                    return;
                }
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                String currencySymbol = GuiConfig.getInstance().getCurrencySymbol();
                player.sendMessage("\u00a7aFixed listing created for " + currencySymbol + String.valueOf(price) + "!");
                player.closeInventory();
                menu.clearPrice(player.getUniqueId());
            } else {
                player.sendMessage("\u00a7cFailed to create listing. Please try again.");
                ItemMeta lm = inHand.getItemMeta();
                if (lm != null) {
                    lm.getPersistentDataContainer().remove(tokenKey);
                    inHand.setItemMeta(lm);
                }
            }
        }
        catch (Exception ex) {
            player.sendMessage("\u00a7cAn error occurred while creating the listing.");
            GlobalMarketplacePlugin.getInstance().getLogger().warning("Failed to create listing: " + ex.getMessage());
            ex.printStackTrace();
        }
        menu.clearPrice(player.getUniqueId());
    }

    private void handleAuctionConfirm(Player player) {
        AuctionDurationMenu menu = new AuctionDurationMenu();
        AuctionDurationMenu.AuctionSettings settings = menu.getCurrentSettings(player.getUniqueId());
        if (settings == null) {
            player.sendMessage("\u00a7cAuction settings not found. Please try again.");
            player.closeInventory();
            return;
        }
        if (settings.price == null || settings.price.compareTo(BigDecimal.ZERO) <= 0) {
            player.sendMessage("\u00a7cInvalid starting price. Please set a price greater than 0.");
            return;
        }
        if (settings.durationMinutes <= 0) {
            player.sendMessage("\u00a7cInvalid duration. Please set a duration greater than 0 minutes.");
            return;
        }
        ItemStack inHand = player.getInventory().getItemInMainHand();
        if (inHand == null || inHand.getType() == Material.AIR) {
            player.closeInventory();
            player.sendMessage("\u00a7cYou must hold an item in your main hand to auction it.");
            menu.clearSettings(player.getUniqueId());
            return;
        }
        MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
        if (svc == null) {
            player.sendMessage("\u00a7cMarketplace unavailable.");
            player.closeInventory();
            menu.clearSettings(player.getUniqueId());
            return;
        }
        try {
            ItemMeta liveMeta;
            NamespacedKey tokenKey = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_item_id");
            UUID listingId = UUID.randomUUID();
            ItemStack toSerialize = inHand.clone();
            ItemMeta cloneMeta = toSerialize.getItemMeta();
            if (cloneMeta != null) {
                cloneMeta.getPersistentDataContainer().set(tokenKey, PersistentDataType.STRING, (Object)listingId.toString());
                toSerialize.setItemMeta(cloneMeta);
            }
            if ((liveMeta = inHand.getItemMeta()) != null) {
                liveMeta.getPersistentDataContainer().set(tokenKey, PersistentDataType.STRING, (Object)listingId.toString());
                inHand.setItemMeta(liveMeta);
            }
            Instant endTime = Instant.now().plus(Duration.ofMinutes(settings.durationMinutes));
            String serialized = ItemSerializer.toBase64(toSerialize);
            Optional<UUID> created = svc.createAuctionListing(listingId, player.getUniqueId(), serialized, settings.price, endTime);
            if (created.isPresent()) {
                int days;
                int hours;
                ItemMeta cm;
                ItemStack current = player.getInventory().getItemInMainHand();
                boolean tokenOk = false;
                if (current != null && (cm = current.getItemMeta()) != null) {
                    String val = (String)cm.getPersistentDataContainer().get(tokenKey, PersistentDataType.STRING);
                    tokenOk = listingId.toString().equals(val);
                }
                if (!tokenOk) {
                    player.sendMessage("\u00a7cAuction aborted: held item changed during creation.");
                    player.closeInventory();
                    menu.clearSettings(player.getUniqueId());
                    return;
                }
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                String durationStr = settings.durationMinutes < 60 ? settings.durationMinutes + " minute" + (settings.durationMinutes != 1 ? "s" : "") : (settings.durationMinutes < 1440 ? hours + " hour" + ((hours = settings.durationMinutes / 60) != 1 ? "s" : "") : days + " day" + ((days = settings.durationMinutes / 1440) != 1 ? "s" : ""));
                String currencySymbol = GuiConfig.getInstance().getCurrencySymbol();
                player.sendMessage("\u00a7aAuction created! Starting price: " + currencySymbol + String.valueOf(settings.price) + ", Duration: " + durationStr);
                player.closeInventory();
                menu.clearSettings(player.getUniqueId());
            } else {
                player.sendMessage("\u00a7cFailed to create auction. Please try again.");
                ItemMeta lm = inHand.getItemMeta();
                if (lm != null) {
                    lm.getPersistentDataContainer().remove(tokenKey);
                    inHand.setItemMeta(lm);
                }
            }
        }
        catch (Exception ex) {
            player.sendMessage("\u00a7cAn error occurred while creating the auction.");
            GlobalMarketplacePlugin.getInstance().getLogger().warning("Failed to create auction: " + ex.getMessage());
            ex.printStackTrace();
        }
        menu.clearSettings(player.getUniqueId());
    }
}

