/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.ui;

import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.ui.GuiConfig;

public class ListMenu {
    private static GuiConfig.GuiSection getConfig() {
        return GuiConfig.getInstance().getSection("list_menu");
    }

    public static String getTitle() {
        return ListMenu.getConfig().getTitle();
    }

    public void open(Player player) {
        GuiConfig.ButtonConfig auctionBtn;
        GuiConfig.GuiSection config = ListMenu.getConfig();
        int rows = config.getRows();
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)(rows * 9), (String)ListMenu.getTitle());
        GuiConfig.ButtonConfig fixedBtn = config.getButton("fixed");
        if (fixedBtn != null && fixedBtn.getSlot() >= 0) {
            inv.setItem(fixedBtn.getSlot(), this.createButton(fixedBtn.getMaterial(), fixedBtn.getName(), "list_fixed"));
        }
        if ((auctionBtn = config.getButton("auction")) != null && auctionBtn.getSlot() >= 0) {
            inv.setItem(auctionBtn.getSlot(), this.createButton(auctionBtn.getMaterial(), auctionBtn.getName(), "list_auction"));
        }
        player.openInventory(inv);
    }

    private ItemStack createButton(Material material, String name, String action) {
        ItemStack it = new ItemStack(material);
        ItemMeta meta = it.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            NamespacedKey keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            pdc.set(keyAction, PersistentDataType.STRING, (Object)action);
            it.setItemMeta(meta);
        }
        return it;
    }
}

