/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.service.MarketplaceService;
import org.texboobcat.globalMarketplace.ui.GuiConfig;
import org.texboobcat.globalMarketplace.util.ItemSerializer;

public class ServerShopMenu {
    public static String getTitle() {
        GuiConfig.GuiSection menu;
        GuiConfig.GuiSection menuCfg = GuiConfig.getInstance().getSection("server_shop");
        if (menuCfg != null && (menu = menuCfg.getSection("menu")) != null) {
            return menu.getTitle();
        }
        return "\u00a76\u00a7lServer Shop";
    }

    public void open(Player player) {
        this.open(player, 0);
    }

    public void open(Player player, int page) {
        int totalListings;
        int maxPerPage;
        GuiConfig.ButtonConfig backBtn;
        ItemStack back;
        ItemMeta bm;
        int rows = 6;
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)(rows * 9), (String)ServerShopMenu.getTitle());
        GuiConfig.GuiSection menuCfg = GuiConfig.getInstance().getSection("server_shop").getSection("menu");
        GuiConfig.FillerConfig fillerCfg = menuCfg.getFiller();
        ItemStack filler = new ItemStack(fillerCfg.getMaterial());
        ItemMeta meta = filler.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(fillerCfg.getName());
            filler.setItemMeta(meta);
        }
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, filler);
        }
        MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
        if (svc != null) {
            List<Listing> serverListings = svc.getServerListings();
            int maxPerPage2 = inv.getSize() - 9;
            int offset = page * maxPerPage2;
            int slot = 0;
            for (int i = offset; i < serverListings.size() && slot < maxPerPage2; ++slot, ++i) {
                ItemStack display;
                Listing l = serverListings.get(i);
                try {
                    display = ItemSerializer.fromBase64(l.getItemSerialized());
                    if (display == null || display.getType() == Material.AIR) {
                        display = new ItemStack(Material.CHEST);
                    }
                }
                catch (Exception ex) {
                    display = new ItemStack(Material.CHEST);
                }
                ItemMeta im = display.getItemMeta();
                if (im != null) {
                    GuiConfig guiCfg = GuiConfig.getInstance();
                    String currencySymbol = guiCfg.getCurrencySymbol();
                    String baseItemName = im.hasDisplayName() ? im.getDisplayName() : ServerShopMenu.prettify(display.getType().name());
                    String titlePrefix = guiCfg.getConfig().getString("server_shop.listing.title_prefix", "&6&lServer Shop: &f");
                    titlePrefix = ChatColor.translateAlternateColorCodes((char)'&', (String)titlePrefix);
                    im.setDisplayName(titlePrefix + baseItemName);
                    ArrayList<String> lore = new ArrayList<String>();
                    String typeLabel = guiCfg.getConfig().getString("server_shop.listing.labels.type", "&7Type: &6Server Listing");
                    String priceLabel = guiCfg.getConfig().getString("server_shop.listing.labels.price", "&7Price: ");
                    String stockLabel = guiCfg.getConfig().getString("server_shop.listing.labels.stock", "&7Stock: &e\u221e Unlimited");
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)typeLabel));
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)priceLabel) + guiCfg.getTooltip("colors.price_color", "\u00a7a") + currencySymbol + String.valueOf(l.getPrice()));
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)stockLabel));
                    ServerShopMenu.appendEnchantLore(display, lore, guiCfg);
                    lore.add(" ");
                    lore.add(guiCfg.getTooltip("controls.header", "\u00a78\u2014\u2014 \u00a77Controls \u00a78\u2014\u2014"));
                    String buyControl = guiCfg.getConfig().getString("server_shop.listing.controls.buy", "&aLeft-click: &fBuy from server");
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)buyControl));
                    if (player.hasPermission("globalmarketplace.admin.servershop")) {
                        String adminControl = guiCfg.getConfig().getString("server_shop.listing.controls.admin_remove", "&cRight-click: &fRemove (admin)");
                        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)adminControl));
                    }
                    lore.add(" ");
                    lore.add("\u00a78ID: " + String.valueOf(l.getUuid()));
                    im.setLore(lore);
                    try {
                        im.addEnchant(Enchantment.UNBREAKING, 1, true);
                        im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    }
                    catch (Throwable adminControl) {
                        // empty catch block
                    }
                    NamespacedKey key = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_listing");
                    im.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)l.getUuid().toString());
                    display.setItemMeta(im);
                }
                inv.setItem(slot, display);
            }
        }
        NamespacedKey keyAction = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_action");
        NamespacedKey keyPage = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_page");
        int lastRow = (rows - 1) * 9;
        if (page > 0) {
            GuiConfig.ButtonConfig prevBtn = menuCfg.getButton("previous_page");
            ItemStack prev = new ItemStack(prevBtn.getMaterial());
            ItemMeta pm = prev.getItemMeta();
            if (pm != null) {
                pm.setDisplayName(prevBtn.getName());
                pm.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)"servershop_prev");
                pm.getPersistentDataContainer().set(keyPage, PersistentDataType.INTEGER, (Object)(page - 1));
                prev.setItemMeta(pm);
            }
            inv.setItem(lastRow, prev);
        }
        if ((bm = (back = new ItemStack((backBtn = menuCfg.getButton("back")).getMaterial())).getItemMeta()) != null) {
            bm.setDisplayName(backBtn.getName());
            bm.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)"back_to_main");
            back.setItemMeta(bm);
        }
        inv.setItem(lastRow + 4, back);
        if (svc != null && (page + 1) * (maxPerPage = inv.getSize() - 9) < (totalListings = svc.getServerListings().size())) {
            GuiConfig.ButtonConfig nextBtn = menuCfg.getButton("next_page");
            ItemStack next = new ItemStack(nextBtn.getMaterial());
            ItemMeta nm = next.getItemMeta();
            if (nm != null) {
                nm.setDisplayName(nextBtn.getName());
                nm.getPersistentDataContainer().set(keyAction, PersistentDataType.STRING, (Object)"servershop_next");
                nm.getPersistentDataContainer().set(keyPage, PersistentDataType.INTEGER, (Object)(page + 1));
                next.setItemMeta(nm);
            }
            inv.setItem(lastRow + 8, next);
        }
        player.openInventory(inv);
    }

    private static String prettify(String enumName) {
        String lower = enumName.toLowerCase(Locale.ROOT).replace('_', ' ');
        String[] parts = lower.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            if (p.isEmpty()) continue;
            sb.append(Character.toUpperCase(p.charAt(0))).append(p.substring(1)).append(' ');
        }
        return sb.toString().trim();
    }

    private static void appendEnchantLore(ItemStack item, List<String> lore, GuiConfig guiCfg) {
        Map ench = item.getEnchantments();
        if (ench != null && !ench.isEmpty()) {
            lore.add(guiCfg.getTooltip("labels.enchantments", "\u00a77Enchantments:"));
            for (Map.Entry e : ench.entrySet()) {
                String name = ServerShopMenu.prettify(((Enchantment)e.getKey()).getKey().getKey());
                lore.add("\u00a78- \u00a7f" + name + " " + ServerShopMenu.roman((Integer)e.getValue()));
            }
        }
    }

    private static String roman(int n) {
        String[] romans = new String[]{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        if (n >= 0 && n < romans.length) {
            return romans[n];
        }
        return Integer.toString(n);
    }
}

