/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.dao;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.model.ListingStatus;
import org.texboobcat.globalMarketplace.model.ListingType;
import org.texboobcat.globalMarketplace.storage.DatabaseManager;

public class ListingDao {
    private final DatabaseManager db;

    public ListingDao(DatabaseManager db) {
        this.db = db;
    }

    public void createListing(Listing listing) throws SQLException {
        String sql = "INSERT INTO gm_listings (uuid, seller_uuid, item, type, price, current_bid, bidder_uuid, created_at, expires_at, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (Connection c = this.db.getConnection();
             PreparedStatement ps = c.prepareStatement(sql, 1);){
            ps.setString(1, listing.getUuid().toString());
            ps.setString(2, listing.getSellerUuid().toString());
            ps.setString(3, listing.getItemSerialized());
            ps.setString(4, listing.getType().name());
            ps.setBigDecimal(5, listing.getPrice());
            if (listing.getCurrentBid() != null) {
                ps.setBigDecimal(6, listing.getCurrentBid());
            } else {
                ps.setNull(6, 3);
            }
            if (listing.getBidderUuid() != null) {
                ps.setString(7, listing.getBidderUuid().toString());
            } else {
                ps.setNull(7, 1);
            }
            ps.setTimestamp(8, Timestamp.from(listing.getCreatedAt() != null ? listing.getCreatedAt() : Instant.now()));
            if (listing.getExpiresAt() != null) {
                ps.setTimestamp(9, Timestamp.from(listing.getExpiresAt()));
            } else {
                ps.setNull(9, 93);
            }
            ps.setString(10, listing.getStatus().name());
            ps.executeUpdate();
            try (ResultSet rs = ps.getGeneratedKeys();){
                if (rs.next()) {
                    listing.setId(rs.getLong(1));
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public Optional<Listing> getByUuid(UUID uuid) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean updateStatus(UUID uuid, ListingStatus status) throws SQLException {
        String sql = "UPDATE gm_listings SET status=? WHERE uuid=?";
        try (Connection c = this.db.getConnection();){
            boolean bl;
            block12: {
                PreparedStatement ps = c.prepareStatement(sql);
                try {
                    ps.setString(1, status.name());
                    ps.setString(2, uuid.toString());
                    boolean bl2 = bl = ps.executeUpdate() > 0;
                    if (ps == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
    }

    public boolean tryUpdateStatusIf(UUID uuid, ListingStatus expectedCurrent, ListingStatus newStatus) throws SQLException {
        String sql = "UPDATE gm_listings SET status=? WHERE uuid=? AND status=?";
        try (Connection c = this.db.getConnection();){
            boolean bl;
            block12: {
                PreparedStatement ps = c.prepareStatement(sql);
                try {
                    ps.setString(1, newStatus.name());
                    ps.setString(2, uuid.toString());
                    ps.setString(3, expectedCurrent.name());
                    boolean bl2 = bl = ps.executeUpdate() > 0;
                    if (ps == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
    }

    public boolean updateBid(UUID uuid, BigDecimal bid, UUID bidder) throws SQLException {
        String sql = "UPDATE gm_listings SET current_bid=?, bidder_uuid=? WHERE uuid=?";
        try (Connection c = this.db.getConnection();){
            boolean bl;
            block16: {
                PreparedStatement ps = c.prepareStatement(sql);
                try {
                    if (bid != null) {
                        ps.setBigDecimal(1, bid);
                    } else {
                        ps.setNull(1, 3);
                    }
                    if (bidder != null) {
                        ps.setString(2, bidder.toString());
                    } else {
                        ps.setNull(2, 1);
                    }
                    ps.setString(3, uuid.toString());
                    boolean bl2 = bl = ps.executeUpdate() > 0;
                    if (ps == null) break block16;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    public List<Listing> findActive(int limit, int offset) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<Listing> findExpiredActiveAuctions(Instant now, int limit) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<Listing> findExpiredActiveAny(Instant now, int limit) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean deleteByUuid(UUID uuid) throws SQLException {
        String sql = "DELETE FROM gm_listings WHERE uuid=?";
        try (Connection c = this.db.getConnection();){
            boolean bl;
            block12: {
                PreparedStatement ps = c.prepareStatement(sql);
                try {
                    ps.setString(1, uuid.toString());
                    boolean bl2 = bl = ps.executeUpdate() > 0;
                    if (ps == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return bl;
        }
    }

    private Listing map(ResultSet rs) throws SQLException {
        Listing l = new Listing();
        l.setId(rs.getLong("id"));
        l.setUuid(UUID.fromString(rs.getString("uuid")));
        l.setSellerUuid(UUID.fromString(rs.getString("seller_uuid")));
        l.setItemSerialized(rs.getString("item"));
        l.setType(ListingType.valueOf(rs.getString("type")));
        l.setPrice(rs.getBigDecimal("price"));
        BigDecimal cb = rs.getBigDecimal("current_bid");
        l.setCurrentBid(rs.wasNull() ? null : cb);
        String bidder = rs.getString("bidder_uuid");
        l.setBidderUuid(bidder == null ? null : UUID.fromString(bidder));
        Timestamp created = rs.getTimestamp("created_at");
        l.setCreatedAt(created != null ? created.toInstant() : null);
        Timestamp expires = rs.getTimestamp("expires_at");
        l.setExpiresAt(expires != null ? expires.toInstant() : null);
        l.setStatus(ListingStatus.valueOf(rs.getString("status")));
        return l;
    }
}

