/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import org.texboobcat.globalMarketplace.dao.LockProvider;
import org.texboobcat.globalMarketplace.storage.DatabaseManager;

public class LockDao
implements LockProvider {
    private final DatabaseManager db;

    public LockDao(DatabaseManager db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean tryAcquire(String key, Duration ttl) throws SQLException {
        Instant until = Instant.now().plus(ttl);
        try (Connection c = this.db.getConnection();){
            boolean ps3332;
            c.setAutoCommit(false);
            try {
                try (PreparedStatement ps = c.prepareStatement("DELETE FROM gm_locks WHERE resource_key=? AND (locked_until IS NULL OR locked_until < CURRENT_TIMESTAMP)");){
                    ps.setString(1, key);
                    ps.executeUpdate();
                }
                ps = c.prepareStatement("INSERT INTO gm_locks(resource_key, locked_until) VALUES (?, ?)");
                try {
                    ps.setString(1, key);
                    ps.setTimestamp(2, Timestamp.from(until));
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                c.commit();
                ps3332 = true;
            }
            catch (SQLException ex) {
                boolean bl;
                block26: {
                    c.rollback();
                    bl = false;
                    c.setAutoCommit(true);
                    if (c == null) break block26;
                    c.close();
                }
                return bl;
                {
                    catch (Throwable throwable) {
                        c.setAutoCommit(true);
                        throw throwable;
                    }
                }
            }
            c.setAutoCommit(true);
            return ps3332;
        }
    }

    @Override
    public void release(String key) throws SQLException {
        try (Connection c = this.db.getConnection();
             PreparedStatement ps = c.prepareStatement("DELETE FROM gm_locks WHERE resource_key=?");){
            ps.setString(1, key);
            ps.executeUpdate();
        }
    }
}

