/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.economy;

import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class EconomyService {
    private final Economy economy;

    public EconomyService(Economy economy) {
        this.economy = economy;
    }

    public boolean isEnabled() {
        return this.economy != null && this.economy.isEnabled();
    }

    public String format(double amount) {
        return this.economy != null ? this.economy.format(amount) : String.format("%.2f", amount);
    }

    public double getBalance(OfflinePlayer player) {
        if (this.economy == null) {
            return 0.0;
        }
        return this.economy.getBalance(player);
    }

    public boolean withdraw(OfflinePlayer player, double amount) {
        if (this.economy == null) {
            return false;
        }
        return this.economy.withdrawPlayer(player, amount).transactionSuccess();
    }

    public boolean deposit(OfflinePlayer player, double amount) {
        if (this.economy == null) {
            return false;
        }
        return this.economy.depositPlayer(player, amount).transactionSuccess();
    }

    public double getBalance(UUID playerId) {
        return this.getBalance(Bukkit.getOfflinePlayer((UUID)playerId));
    }

    public boolean withdraw(UUID playerId, double amount) {
        return this.withdraw(Bukkit.getOfflinePlayer((UUID)playerId), amount);
    }

    public boolean deposit(UUID playerId, double amount) {
        return this.deposit(Bukkit.getOfflinePlayer((UUID)playerId), amount);
    }
}

