/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.listeners;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.service.MarketplaceService;
import org.texboobcat.globalMarketplace.session.CreationSessionManager;
import org.texboobcat.globalMarketplace.util.ItemSerializer;

public class CreationListener
implements Listener {
    private static final ConcurrentHashMap<UUID, ReentrantLock> CREATE_LOCKS = new ConcurrentHashMap();

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        CreationSessionManager mgr = CreationSessionManager.get();
        CreationSessionManager.Session session = mgr.get(player.getUniqueId());
        if (session == null) {
            return;
        }
        event.setCancelled(true);
        String msg = event.getMessage().trim();
        CreationSessionManager.Mode mode = session.mode;
        Bukkit.getScheduler().runTask((Plugin)GlobalMarketplacePlugin.getInstance(), () -> {
            block41: {
                MarketplaceService svc = GlobalMarketplacePlugin.getInstance().getMarketplaceService();
                if (svc == null) {
                    player.sendMessage("\u00a7cMarketplace unavailable.");
                    mgr.clear(player.getUniqueId());
                    return;
                }
                ItemStack inHand = player.getInventory().getItemInMainHand();
                if (inHand == null || inHand.getType() == Material.AIR) {
                    player.sendMessage("\u00a7cHold the item in your main hand to list it.");
                    mgr.clear(player.getUniqueId());
                    return;
                }
                ReentrantLock lock = CREATE_LOCKS.computeIfAbsent(player.getUniqueId(), k -> new ReentrantLock());
                boolean acquired = false;
                try {
                    acquired = lock.tryLock(2L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                if (!acquired) {
                    player.sendMessage("\u00a7eAnother listing action is in progress. Please try again in a moment.");
                    mgr.clear(player.getUniqueId());
                    return;
                }
                try {
                    ItemMeta liveMeta;
                    NamespacedKey tokenKey = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_item_id");
                    UUID listingId = UUID.randomUUID();
                    ItemStack toSerialize = inHand.clone();
                    ItemMeta cloneMeta = toSerialize.getItemMeta();
                    if (cloneMeta != null) {
                        cloneMeta.getPersistentDataContainer().set(tokenKey, PersistentDataType.STRING, (Object)listingId.toString());
                        toSerialize.setItemMeta(cloneMeta);
                    }
                    if ((liveMeta = inHand.getItemMeta()) != null) {
                        liveMeta.getPersistentDataContainer().set(tokenKey, PersistentDataType.STRING, (Object)listingId.toString());
                        inHand.setItemMeta(liveMeta);
                    }
                    if (mode == CreationSessionManager.Mode.FIXED) {
                        BigDecimal price = new BigDecimal(msg);
                        if (price.compareTo(BigDecimal.ZERO) <= 0) {
                            throw new IllegalArgumentException();
                        }
                        String serialized = ItemSerializer.toBase64(toSerialize);
                        Optional<UUID> created = svc.createFixedListing(listingId, player.getUniqueId(), serialized, price);
                        if (created.isPresent()) {
                            ItemMeta cm;
                            ItemStack current = player.getInventory().getItemInMainHand();
                            boolean tokenOk = false;
                            if (current != null && (cm = current.getItemMeta()) != null) {
                                String val = (String)cm.getPersistentDataContainer().get(tokenKey, PersistentDataType.STRING);
                                tokenOk = listingId.toString().equals(val);
                            }
                            if (!tokenOk) {
                                player.sendMessage("\u00a7cListing aborted: held item changed during creation.");
                                throw new RuntimeException("Item token mismatch");
                            }
                            player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                            player.sendMessage("\u00a7aFixed listing created. ID: " + String.valueOf(created.get()));
                            break block41;
                        }
                        player.sendMessage("\u00a7cFailed to create fixed listing.");
                        try {
                            ItemMeta lm = inHand.getItemMeta();
                            if (lm != null) {
                                lm.getPersistentDataContainer().remove(tokenKey);
                                inHand.setItemMeta(lm);
                            }
                            break block41;
                        }
                        catch (Exception lm) {}
                        break block41;
                    }
                    if (mode != CreationSessionManager.Mode.AUCTION) break block41;
                    String[] parts = msg.split("\\s+");
                    if (parts.length < 2) {
                        throw new IllegalArgumentException();
                    }
                    BigDecimal start = new BigDecimal(parts[0]);
                    int minutes = Integer.parseInt(parts[1]);
                    if (start.compareTo(BigDecimal.ZERO) <= 0 || minutes <= 0) {
                        throw new IllegalArgumentException();
                    }
                    String serialized = ItemSerializer.toBase64(toSerialize);
                    Optional<UUID> created = svc.createAuctionListing(listingId, player.getUniqueId(), serialized, start, Instant.now().plus(Duration.ofMinutes(minutes)));
                    if (created.isPresent()) {
                        ItemMeta cm;
                        ItemStack current = player.getInventory().getItemInMainHand();
                        boolean tokenOk = false;
                        if (current != null && (cm = current.getItemMeta()) != null) {
                            String val = (String)cm.getPersistentDataContainer().get(tokenKey, PersistentDataType.STRING);
                            tokenOk = listingId.toString().equals(val);
                        }
                        if (!tokenOk) {
                            player.sendMessage("\u00a7cAuction aborted: held item changed during creation.");
                            throw new RuntimeException("Item token mismatch");
                        }
                        player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
                        player.sendMessage("\u00a7aAuction created. ID: " + String.valueOf(created.get()));
                        break block41;
                    }
                    player.sendMessage("\u00a7cFailed to create auction.");
                    try {
                        ItemMeta lm = inHand.getItemMeta();
                        if (lm != null) {
                            lm.getPersistentDataContainer().remove(tokenKey);
                            inHand.setItemMeta(lm);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                catch (IllegalArgumentException ex) {
                    if (mode == CreationSessionManager.Mode.FIXED) {
                        player.sendMessage("\u00a7eEnter a valid price, e.g. 100 or 99.99");
                    } else {
                        player.sendMessage("\u00a7eEnter start price and minutes, e.g. 100 60");
                    }
                    return;
                }
                catch (RuntimeException ex) {
                    player.sendMessage("\u00a7cFailed to process item. Please try again.");
                    return;
                }
                finally {
                    try {
                        lock.unlock();
                    }
                    catch (IllegalMonitorStateException illegalMonitorStateException) {}
                    if (!lock.hasQueuedThreads()) {
                        CREATE_LOCKS.remove(player.getUniqueId(), lock);
                    }
                    mgr.clear(player.getUniqueId());
                }
            }
        });
    }
}

