/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.model;

import java.time.Instant;
import java.util.UUID;

public class TradeRequest {
    private final UUID requestId = UUID.randomUUID();
    private final UUID initiator;
    private final UUID target;
    private final Instant createdAt;
    private final Instant expiresAt;
    private TradeRequestStatus status;

    public TradeRequest(UUID initiator, UUID target) {
        this.initiator = initiator;
        this.target = target;
        this.createdAt = Instant.now();
        this.expiresAt = this.createdAt.plusSeconds(300L);
        this.status = TradeRequestStatus.PENDING;
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public UUID getInitiator() {
        return this.initiator;
    }

    public UUID getTarget() {
        return this.target;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getExpiresAt() {
        return this.expiresAt;
    }

    public TradeRequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(TradeRequestStatus status) {
        this.status = status;
    }

    public boolean isExpired() {
        return Instant.now().isAfter(this.expiresAt);
    }

    public static enum TradeRequestStatus {
        PENDING,
        ACCEPTED,
        DECLINED,
        EXPIRED;

    }
}

