/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.repo.adapters;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.texboobcat.globalMarketplace.repo.TransactionLog;

public class CompositeTransactionLog
implements TransactionLog {
    private final List<TransactionLog> delegates = new ArrayList<TransactionLog>();

    public CompositeTransactionLog(List<TransactionLog> logs) {
        if (logs != null) {
            this.delegates.addAll(logs);
        }
    }

    @Override
    public void log(UUID txUuid, UUID listingUuid, UUID buyerUuid, UUID sellerUuid, BigDecimal amount, String type) throws SQLException {
        SQLException first = null;
        for (TransactionLog d : this.delegates) {
            try {
                d.log(txUuid, listingUuid, buyerUuid, sellerUuid, amount, type);
            }
            catch (SQLException e) {
                if (first != null) continue;
                first = e;
            }
        }
        if (first != null) {
            throw first;
        }
    }

    @Override
    public void logExtended(UUID txUuid, UUID listingUuid, UUID buyerUuid, UUID sellerUuid, BigDecimal amount, String type, String metaJson) throws SQLException {
        SQLException first = null;
        for (TransactionLog d : this.delegates) {
            try {
                d.logExtended(txUuid, listingUuid, buyerUuid, sellerUuid, amount, type, metaJson);
            }
            catch (SQLException e) {
                if (first != null) continue;
                first = e;
            }
        }
        if (first != null) {
            throw first;
        }
    }

    @Override
    public TransactionLog.SaleRecord latestSaleForListing(UUID listingUuid) throws SQLException {
        SQLException last = null;
        for (TransactionLog d : this.delegates) {
            try {
                TransactionLog.SaleRecord s = d.latestSaleForListing(listingUuid);
                if (s == null) continue;
                return s;
            }
            catch (SQLException e) {
                last = e;
            }
        }
        if (last != null) {
            throw last;
        }
        return null;
    }
}

