/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.service;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.dao.LockProvider;
import org.texboobcat.globalMarketplace.economy.EconomyService;
import org.texboobcat.globalMarketplace.integrations.DiscordWebhookService;
import org.texboobcat.globalMarketplace.model.Listing;
import org.texboobcat.globalMarketplace.model.ListingStatus;
import org.texboobcat.globalMarketplace.model.ListingType;
import org.texboobcat.globalMarketplace.repo.BalanceRepository;
import org.texboobcat.globalMarketplace.repo.DeliveryQueue;
import org.texboobcat.globalMarketplace.repo.ListingRepository;
import org.texboobcat.globalMarketplace.repo.TransactionLog;
import org.texboobcat.globalMarketplace.util.ItemSerializer;

public class MarketplaceService {
    private final ListingRepository listingRepo;
    private final BalanceRepository balanceRepo;
    private final TransactionLog txLog;
    private final EconomyService economyService;
    private final DeliveryQueue deliveryQueue;
    private final LockProvider lockProvider;
    private final ConcurrentHashMap<UUID, Long> claimThrottle = new ConcurrentHashMap();
    private final DiscordWebhookService discordService;

    public MarketplaceService(ListingRepository listingRepo, BalanceRepository balanceRepo, TransactionLog txLog, EconomyService economyService, DeliveryQueue deliveryQueue, LockProvider lockProvider, DiscordWebhookService discordService) {
        this.listingRepo = listingRepo;
        this.balanceRepo = balanceRepo;
        this.txLog = txLog;
        this.economyService = economyService;
        this.deliveryQueue = deliveryQueue;
        this.lockProvider = lockProvider;
        this.discordService = discordService;
    }

    private static String metaJson(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Map.Entry<String, Object> e : map.entrySet()) {
            if (!first) {
                sb.append(',');
            }
            first = false;
            sb.append('\"').append(e.getKey().replace("\"", "\\\"")).append('\"').append(':');
            Object v = e.getValue();
            if (v == null) {
                sb.append("null");
                continue;
            }
            if (v instanceof Number || v instanceof Boolean) {
                sb.append(String.valueOf(v));
                continue;
            }
            sb.append('\"').append(String.valueOf(v).replace("\\", "\\\\").replace("\"", "\\\"")).append('\"');
        }
        sb.append('}');
        return sb.toString();
    }

    public List<Listing> getActiveListings(int page, int pageSize) {
        int offset = Math.max(0, page) * Math.max(1, pageSize);
        try {
            return this.listingRepo.findActive(pageSize, offset);
        }
        catch (SQLException e) {
            return Collections.emptyList();
        }
    }

    public List<Listing> searchActiveListings(String query, int page, int pageSize) {
        if (query == null || query.trim().isEmpty()) {
            return this.getActiveListings(page, pageSize);
        }
        String q = query.trim();
        try {
            List<Listing> window = this.listingRepo.findActive(1000, 0);
            String qLower = q.toLowerCase(Locale.ROOT);
            String sellerFilter = MarketplaceService.extractKey(qLower, "seller:");
            String typeFilter = MarketplaceService.extractKey(qLower, "type:");
            Double min = MarketplaceService.extractDouble(qLower, "min:");
            Double max = MarketplaceService.extractDouble(qLower, "max:");
            String free = qLower.replace("seller:" + (sellerFilter == null ? "" : sellerFilter), "").replace("type:" + (typeFilter == null ? "" : typeFilter), "").replace("min:" + String.valueOf(min == null ? "" : min), "").replace("max:" + String.valueOf(max == null ? "" : max), "").trim();
            ArrayList<Listing> filtered = new ArrayList<Listing>();
            for (Listing l : window) {
                String name;
                if (l.getStatus() != ListingStatus.ACTIVE) continue;
                if (typeFilter != null) {
                    String t = typeFilter;
                    if (l.getType() == ListingType.FIXED && !t.startsWith("fixed") || l.getType() == ListingType.AUCTION && !t.startsWith("auction") || l.getType() == ListingType.DIRECT && !t.startsWith("direct")) continue;
                }
                if (sellerFilter != null && ((name = MarketplaceService.safeSellerName(l.getSellerUuid())) == null || !name.toLowerCase(Locale.ROOT).contains(sellerFilter))) continue;
                if (min != null || max != null) {
                    BigDecimal p;
                    BigDecimal bigDecimal = l.getType() == ListingType.AUCTION ? (l.getCurrentBid() != null ? l.getCurrentBid() : l.getPrice()) : (p = l.getPrice());
                    if (p == null) continue;
                    double dv = p.doubleValue();
                    if (min != null && dv < min || max != null && dv > max) continue;
                }
                if (!free.isEmpty()) {
                    String mat = l.getItemSerialized();
                    String displayName = null;
                    try {
                        ItemStack stack = ItemSerializer.fromBase64(l.getItemSerialized());
                        if (stack != null) {
                            displayName = stack.hasItemMeta() && stack.getItemMeta().hasDisplayName() ? stack.getItemMeta().getDisplayName() : stack.getType().name();
                        }
                    }
                    catch (Exception stack) {
                        // empty catch block
                    }
                    String hay = (displayName != null ? displayName : String.valueOf(mat)).toLowerCase(Locale.ROOT);
                    if (!hay.contains(free)) continue;
                }
                filtered.add(l);
            }
            int from = Math.max(0, page) * Math.max(1, pageSize);
            int to = Math.min(filtered.size(), from + Math.max(1, pageSize));
            if (from >= filtered.size()) {
                return Collections.emptyList();
            }
            return filtered.subList(from, to);
        }
        catch (SQLException e) {
            return Collections.emptyList();
        }
    }

    private static String extractKey(String q, String key) {
        int i = q.indexOf(key);
        if (i < 0) {
            return null;
        }
        int start = i + key.length();
        int end = q.indexOf(32, start);
        String val = end >= 0 ? q.substring(start, end) : q.substring(start);
        if ((val = val.trim()).isEmpty()) {
            return null;
        }
        return val;
    }

    private static Double extractDouble(String q, String key) {
        String v = MarketplaceService.extractKey(q, key);
        if (v == null) {
            return null;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    private static String safeSellerName(UUID uuid) {
        try {
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)uuid);
            if (op != null && op.getName() != null) {
                return op.getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Optional<Listing> getListing(UUID uuid) {
        try {
            return this.listingRepo.getByUuid(uuid);
        }
        catch (SQLException e) {
            return Optional.empty();
        }
    }

    public Optional<BigDecimal> getPendingBalance(UUID player) {
        try {
            return Optional.ofNullable(this.balanceRepo.getPending(player));
        }
        catch (SQLException e) {
            return Optional.empty();
        }
    }

    public boolean payout(UUID player, BigDecimal amount) {
        if (this.economyService == null || !this.economyService.isEnabled()) {
            return false;
        }
        try {
            BigDecimal deducted = this.balanceRepo.tryDeductPending(player, amount);
            if (deducted.compareTo(BigDecimal.ZERO) <= 0) {
                return false;
            }
            boolean deposited = this.economyService.deposit(player, deducted.doubleValue());
            if (!deposited) {
                this.balanceRepo.addPending(player, deducted);
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean purchaseFixed(UUID buyerUuid, UUID listingUuid) {
        String lockKey = "listing:" + String.valueOf(listingUuid);
        try {
            if (this.lockProvider != null && !this.lockProvider.tryAcquire(lockKey, Duration.ofSeconds(10L))) {
                try {
                    this.txLog.logExtended(UUID.randomUUID(), listingUuid, buyerUuid, null, BigDecimal.ZERO, "LOCK_BUSY_BUY", MarketplaceService.metaJson(Map.of("reason", "listing lock busy")));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                boolean bl = false;
                return bl;
            }
            Optional<Listing> opt = this.listingRepo.getByUuid(listingUuid);
            if (opt.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            Listing listing = opt.get();
            if (listing.getStatus() != ListingStatus.ACTIVE) {
                boolean bl = false;
                return bl;
            }
            if (listing.getType() != ListingType.FIXED) {
                boolean bl = false;
                return bl;
            }
            BigDecimal price = listing.getPrice();
            if (!this.economyService.withdraw(buyerUuid, price.doubleValue())) {
                boolean bl = false;
                return bl;
            }
            boolean updated = this.listingRepo.tryUpdateStatusIf(listingUuid, ListingStatus.ACTIVE, ListingStatus.SOLD);
            if (!updated) {
                this.economyService.deposit(buyerUuid, price.doubleValue());
                try {
                    this.txLog.logExtended(UUID.randomUUID(), listingUuid, buyerUuid, listing.getSellerUuid(), price, "CAS_CONFLICT_BUY", MarketplaceService.metaJson(Map.of("reason", "status changed before purchase")));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                boolean bl = false;
                return bl;
            }
            this.balanceRepo.addPending(listing.getSellerUuid(), price);
            this.txLog.logExtended(UUID.randomUUID(), listing.getUuid(), buyerUuid, listing.getSellerUuid(), price, "BUY", MarketplaceService.metaJson(Map.of("type", listing.getType().name(), "price", price)));
            if (this.discordService != null) {
                this.discordService.send(DiscordWebhookService.EventType.FIXED_SOLD, listing, buyerUuid, price);
            }
            if (this.deliveryQueue != null) {
                this.deliveryQueue.enqueue(buyerUuid, listing.getItemSerialized(), listing.getUuid());
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (this.lockProvider != null) {
                    this.lockProvider.release(lockKey);
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public Optional<UUID> createFixedListing(UUID sellerUuid, String itemSerialized, BigDecimal price) {
        try {
            Listing l = new Listing();
            l.setUuid(UUID.randomUUID());
            l.setSellerUuid(sellerUuid);
            l.setItemSerialized(itemSerialized);
            l.setType(ListingType.FIXED);
            l.setPrice(price);
            l.setStatus(ListingStatus.ACTIVE);
            l.setExpiresAt(Instant.now().plus(Duration.ofDays(7L)));
            this.listingRepo.createListing(l);
            if (this.discordService != null) {
                this.discordService.send(DiscordWebhookService.EventType.NEW_FIXED, l, l.getSellerUuid(), l.getPrice());
            }
            return Optional.of(l.getUuid());
        }
        catch (SQLException e) {
            return Optional.empty();
        }
    }

    public Optional<UUID> createFixedListing(UUID listingUuid, UUID sellerUuid, String itemSerialized, BigDecimal price) {
        try {
            Listing l = new Listing();
            l.setUuid(listingUuid);
            l.setSellerUuid(sellerUuid);
            l.setItemSerialized(itemSerialized);
            l.setType(ListingType.FIXED);
            l.setPrice(price);
            l.setStatus(ListingStatus.ACTIVE);
            l.setExpiresAt(Instant.now().plus(Duration.ofDays(7L)));
            this.listingRepo.createListing(l);
            if (this.discordService != null) {
                this.discordService.send(DiscordWebhookService.EventType.NEW_FIXED, l, l.getSellerUuid(), l.getPrice());
            }
            return Optional.of(listingUuid);
        }
        catch (SQLException e) {
            return Optional.empty();
        }
    }

    public Optional<UUID> createAuctionListing(UUID sellerUuid, String itemSerialized, BigDecimal startingPrice, Instant expiresAt) {
        try {
            Listing l = new Listing();
            l.setUuid(UUID.randomUUID());
            l.setSellerUuid(sellerUuid);
            l.setItemSerialized(itemSerialized);
            l.setType(ListingType.AUCTION);
            l.setPrice(startingPrice);
            l.setStatus(ListingStatus.ACTIVE);
            l.setExpiresAt(expiresAt);
            this.listingRepo.createListing(l);
            if (this.discordService != null) {
                this.discordService.send(DiscordWebhookService.EventType.NEW_AUCTION, l, l.getSellerUuid(), l.getPrice());
            }
            return Optional.of(l.getUuid());
        }
        catch (SQLException e) {
            return Optional.empty();
        }
    }

    public Optional<UUID> createAuctionListing(UUID listingUuid, UUID sellerUuid, String itemSerialized, BigDecimal startingPrice, Instant expiresAt) {
        try {
            Listing l = new Listing();
            l.setUuid(listingUuid);
            l.setSellerUuid(sellerUuid);
            l.setItemSerialized(itemSerialized);
            l.setType(ListingType.AUCTION);
            l.setPrice(startingPrice);
            l.setStatus(ListingStatus.ACTIVE);
            l.setExpiresAt(expiresAt);
            this.listingRepo.createListing(l);
            if (this.discordService != null) {
                this.discordService.send(DiscordWebhookService.EventType.NEW_AUCTION, l, l.getSellerUuid(), l.getPrice());
            }
            return Optional.of(listingUuid);
        }
        catch (SQLException e) {
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean placeBid(UUID listingUuid, UUID bidderUuid, BigDecimal amount) {
        String lockKey = "listing:" + String.valueOf(listingUuid);
        try {
            BigDecimal min;
            if (this.lockProvider != null && !this.lockProvider.tryAcquire(lockKey, Duration.ofSeconds(10L))) {
                try {
                    this.txLog.logExtended(UUID.randomUUID(), listingUuid, bidderUuid, null, BigDecimal.ZERO, "LOCK_BUSY_BID", MarketplaceService.metaJson(Map.of("reason", "listing lock busy")));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                boolean bl = false;
                return bl;
            }
            Optional<Listing> opt = this.listingRepo.getByUuid(listingUuid);
            if (opt.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            Listing l = opt.get();
            if (l.getStatus() != ListingStatus.ACTIVE || l.getType() != ListingType.AUCTION) {
                boolean bl = false;
                return bl;
            }
            BigDecimal bigDecimal = min = l.getCurrentBid() != null ? l.getCurrentBid() : l.getPrice();
            if (amount.compareTo(min) <= 0) {
                boolean bl = false;
                return bl;
            }
            boolean ok = this.listingRepo.updateBid(listingUuid, amount, bidderUuid);
            if (ok) {
                this.txLog.logExtended(UUID.randomUUID(), l.getUuid(), bidderUuid, l.getSellerUuid(), amount, "BID", MarketplaceService.metaJson(Map.of("prevBid", l.getCurrentBid() != null ? l.getCurrentBid() : l.getPrice(), "newBid", amount)));
                if (this.discordService != null) {
                    this.discordService.send(DiscordWebhookService.EventType.BID_PLACED, l, bidderUuid, amount);
                }
            }
            boolean bl = ok;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (this.lockProvider != null) {
                    this.lockProvider.release(lockKey);
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processExpiredAuctions(int batchSize) {
        int processed = 0;
        try {
            List<Listing> expired = this.listingRepo.findExpiredActiveAuctions(Instant.now(), Math.max(1, batchSize));
            for (Listing l : expired) {
                String lockKey = "listing:" + String.valueOf(l.getUuid());
                boolean locked = true;
                try {
                    if (this.lockProvider != null && !(locked = this.lockProvider.tryAcquire(lockKey, Duration.ofSeconds(10L)))) {
                        try {
                            this.txLog.logExtended(UUID.randomUUID(), l.getUuid(), null, null, BigDecimal.ZERO, "LOCK_BUSY_EXPIRE", MarketplaceService.metaJson(Map.of("reason", "listing lock busy during expire")));
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        continue;
                    }
                    if (l.getCurrentBid() != null && l.getBidderUuid() != null) {
                        boolean paid = this.economyService.withdraw(l.getBidderUuid(), l.getCurrentBid().doubleValue());
                        if (paid) {
                            boolean sold = this.listingRepo.tryUpdateStatusIf(l.getUuid(), ListingStatus.ACTIVE, ListingStatus.SOLD);
                            if (!sold) {
                                try {
                                    this.txLog.logExtended(UUID.randomUUID(), l.getUuid(), l.getBidderUuid(), l.getSellerUuid(), l.getCurrentBid(), "CAS_CONFLICT_EXPIRE_SELL", MarketplaceService.metaJson(Map.of("reason", "status changed during expire")));
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                                this.economyService.deposit(l.getBidderUuid(), l.getCurrentBid().doubleValue());
                                continue;
                            }
                            this.balanceRepo.addPending(l.getSellerUuid(), l.getCurrentBid());
                            this.txLog.logExtended(UUID.randomUUID(), l.getUuid(), l.getBidderUuid(), l.getSellerUuid(), l.getCurrentBid(), "AUCTION_SELL", MarketplaceService.metaJson(Map.of("endsAt", String.valueOf(l.getExpiresAt()))));
                            if (this.discordService != null) {
                                this.discordService.send(DiscordWebhookService.EventType.AUCTION_SOLD, l, l.getBidderUuid(), l.getCurrentBid());
                            }
                            if (this.deliveryQueue != null) {
                                this.deliveryQueue.enqueue(l.getBidderUuid(), l.getItemSerialized(), l.getUuid());
                            }
                        } else {
                            boolean expiredOk = this.listingRepo.tryUpdateStatusIf(l.getUuid(), ListingStatus.ACTIVE, ListingStatus.EXPIRED);
                            if (!expiredOk) {
                                try {
                                    this.txLog.logExtended(UUID.randomUUID(), l.getUuid(), l.getBidderUuid(), l.getSellerUuid(), l.getCurrentBid(), "CAS_CONFLICT_EXPIRE", MarketplaceService.metaJson(Map.of("reason", "status changed during expire (unpaid)")));
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                                continue;
                            }
                            if (this.discordService != null) {
                                this.discordService.send(DiscordWebhookService.EventType.AUCTION_EXPIRED, l, null, null);
                            }
                        }
                    } else {
                        boolean expiredOk = this.listingRepo.tryUpdateStatusIf(l.getUuid(), ListingStatus.ACTIVE, ListingStatus.EXPIRED);
                        if (expiredOk) {
                            if (this.discordService != null) {
                                this.discordService.send(DiscordWebhookService.EventType.AUCTION_EXPIRED, l, null, null);
                            }
                        } else {
                            try {
                                this.txLog.logExtended(UUID.randomUUID(), l.getUuid(), null, l.getSellerUuid(), BigDecimal.ZERO, "CAS_CONFLICT_EXPIRE", MarketplaceService.metaJson(Map.of("reason", "status changed during expire (no bids)")));
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                    }
                    ++processed;
                }
                finally {
                    try {
                        if (!locked || this.lockProvider == null) continue;
                        this.lockProvider.release(lockKey);
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return processed;
        }
        catch (SQLException e) {
            return processed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int processExpiredListings(int batchSize) {
        int processed = 0;
        try {
            List<Listing> expired = this.listingRepo.findExpiredActiveAny(Instant.now(), Math.max(1, batchSize));
            for (Listing l : expired) {
                if (l.getType() == ListingType.AUCTION) continue;
                String lockKey = "listing:" + String.valueOf(l.getUuid());
                boolean locked = true;
                try {
                    if (this.lockProvider != null && !(locked = this.lockProvider.tryAcquire(lockKey, Duration.ofSeconds(10L)))) {
                        try {
                            this.txLog.logExtended(UUID.randomUUID(), l.getUuid(), null, l.getSellerUuid(), BigDecimal.ZERO, "LOCK_BUSY_EXPIRE", MarketplaceService.metaJson(Map.of("reason", "listing lock busy during expire (non-auction)")));
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        continue;
                    }
                    boolean ok = this.listingRepo.tryUpdateStatusIf(l.getUuid(), ListingStatus.ACTIVE, ListingStatus.EXPIRED);
                    if (!ok) {
                        try {
                            this.txLog.logExtended(UUID.randomUUID(), l.getUuid(), null, l.getSellerUuid(), BigDecimal.ZERO, "CAS_CONFLICT_EXPIRE", MarketplaceService.metaJson(Map.of("reason", "status changed during expire (non-auction)")));
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        continue;
                    }
                    ++processed;
                }
                finally {
                    try {
                        if (!locked || this.lockProvider == null) continue;
                        this.lockProvider.release(lockKey);
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return processed;
    }

    public Optional<UUID> createDirectListing(UUID sellerUuid, UUID targetBuyerUuid, String itemSerialized, BigDecimal price) {
        try {
            Listing l = new Listing();
            l.setUuid(UUID.randomUUID());
            l.setSellerUuid(sellerUuid);
            l.setItemSerialized(itemSerialized);
            l.setType(ListingType.DIRECT);
            l.setPrice(price);
            l.setStatus(ListingStatus.ACTIVE);
            l.setBidderUuid(targetBuyerUuid);
            l.setExpiresAt(Instant.now().plus(Duration.ofDays(7L)));
            this.listingRepo.createListing(l);
            return Optional.of(l.getUuid());
        }
        catch (SQLException e) {
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean purchaseDirect(UUID buyerUuid, UUID listingUuid) {
        String lockKey = "listing:" + String.valueOf(listingUuid);
        try {
            if (this.lockProvider != null && !this.lockProvider.tryAcquire(lockKey, Duration.ofSeconds(10L))) {
                try {
                    this.txLog.logExtended(UUID.randomUUID(), listingUuid, buyerUuid, null, BigDecimal.ZERO, "LOCK_BUSY_DIRECT", MarketplaceService.metaJson(Map.of("reason", "listing lock busy")));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                boolean bl = false;
                return bl;
            }
            Optional<Listing> opt = this.listingRepo.getByUuid(listingUuid);
            if (opt.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            Listing l = opt.get();
            if (l.getStatus() != ListingStatus.ACTIVE || l.getType() != ListingType.DIRECT) {
                boolean bl = false;
                return bl;
            }
            if (l.getBidderUuid() == null || !l.getBidderUuid().equals(buyerUuid)) {
                boolean bl = false;
                return bl;
            }
            BigDecimal price = l.getPrice();
            if (!this.economyService.withdraw(buyerUuid, price.doubleValue())) {
                boolean bl = false;
                return bl;
            }
            boolean updated = this.listingRepo.tryUpdateStatusIf(listingUuid, ListingStatus.ACTIVE, ListingStatus.SOLD);
            if (!updated) {
                this.economyService.deposit(buyerUuid, price.doubleValue());
                try {
                    this.txLog.logExtended(UUID.randomUUID(), listingUuid, buyerUuid, l.getSellerUuid(), price, "CAS_CONFLICT_DIRECT", MarketplaceService.metaJson(Map.of("reason", "status changed before direct buy")));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                boolean bl = false;
                return bl;
            }
            this.balanceRepo.addPending(l.getSellerUuid(), price);
            try {
                this.txLog.logExtended(UUID.randomUUID(), l.getUuid(), buyerUuid, l.getSellerUuid(), price, "DIRECT_BUY", MarketplaceService.metaJson(Map.of("price", price)));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (this.discordService != null) {
                this.discordService.send(DiscordWebhookService.EventType.DIRECT_SOLD, l, buyerUuid, price);
            }
            if (this.deliveryQueue != null) {
                this.deliveryQueue.enqueue(buyerUuid, l.getItemSerialized(), l.getUuid());
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (this.lockProvider != null) {
                    this.lockProvider.release(lockKey);
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    public boolean adminRemoveListing(UUID listingUuid) {
        try {
            return this.listingRepo.deleteByUuid(listingUuid);
        }
        catch (SQLException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean adminRemoveListingReturn(UUID listingUuid) {
        String lockKey = "listing:" + String.valueOf(listingUuid);
        try {
            if (this.lockProvider != null && !this.lockProvider.tryAcquire(lockKey, Duration.ofSeconds(10L))) {
                boolean bl = false;
                return bl;
            }
            Optional<Listing> opt = this.listingRepo.getByUuid(listingUuid);
            if (opt.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            Listing l = opt.get();
            if (l.getStatus() != ListingStatus.ACTIVE) {
                boolean bl = false;
                return bl;
            }
            boolean ok = this.listingRepo.tryUpdateStatusIf(listingUuid, ListingStatus.ACTIVE, ListingStatus.CANCELLED);
            if (!ok) {
                boolean bl = false;
                return bl;
            }
            if (this.deliveryQueue != null) {
                this.deliveryQueue.enqueue(l.getSellerUuid(), l.getItemSerialized(), l.getUuid());
            }
            try {
                this.txLog.logExtended(UUID.randomUUID(), l.getUuid(), null, l.getSellerUuid(), l.getPrice(), "ADMIN_REMOVE", MarketplaceService.metaJson(Map.of("by", "gui", "reason", "admin right-click remove")));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Player seller = Bukkit.getPlayer((UUID)l.getSellerUuid());
            if (seller != null && seller.isOnline()) {
                try {
                    this.claimDeliveries(seller, 36);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (this.lockProvider != null) {
                    this.lockProvider.release(lockKey);
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean adminRollbackListing(UUID listingUuid) {
        if (this.economyService == null) return false;
        if (!this.economyService.isEnabled()) {
            return false;
        }
        String lockKey = "listing:" + String.valueOf(listingUuid);
        try {
            if (this.lockProvider != null && !this.lockProvider.tryAcquire(lockKey, Duration.ofSeconds(10L))) {
                boolean bl = false;
                return bl;
            }
            Optional<Listing> opt = this.listingRepo.getByUuid(listingUuid);
            if (opt.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            Listing l = opt.get();
            if (l.getStatus() != ListingStatus.SOLD) {
                boolean bl = false;
                return bl;
            }
            TransactionLog.SaleRecord rec = this.txLog.latestSaleForListing(listingUuid);
            if (rec == null || rec.amount == null || rec.buyerUuid == null || rec.sellerUuid == null) {
                boolean bl = false;
                return bl;
            }
            boolean ok = this.listingRepo.tryUpdateStatusIf(listingUuid, ListingStatus.SOLD, ListingStatus.ACTIVE);
            if (!ok) {
                boolean bl = false;
                return bl;
            }
            BigDecimal deducted = this.balanceRepo.tryDeductPending(rec.sellerUuid, rec.amount);
            if (deducted.compareTo(rec.amount) != 0) {
                try {
                    this.listingRepo.tryUpdateStatusIf(listingUuid, ListingStatus.ACTIVE, ListingStatus.SOLD);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                boolean bl = false;
                return bl;
            }
            boolean refunded = this.economyService.deposit(rec.buyerUuid, rec.amount.doubleValue());
            if (!refunded) {
                this.balanceRepo.addPending(rec.sellerUuid, deducted);
                try {
                    this.listingRepo.tryUpdateStatusIf(listingUuid, ListingStatus.ACTIVE, ListingStatus.SOLD);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                boolean bl = false;
                return bl;
            }
            this.txLog.log(UUID.randomUUID(), listingUuid, rec.buyerUuid, rec.sellerUuid, rec.amount, "ROLLBACK");
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (this.lockProvider != null) {
                    this.lockProvider.release(lockKey);
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean cancelListing(UUID sellerUuid, UUID listingUuid) {
        String lockKey = "listing:" + String.valueOf(listingUuid);
        try {
            if (this.lockProvider != null && !this.lockProvider.tryAcquire(lockKey, Duration.ofSeconds(10L))) {
                boolean bl = false;
                return bl;
            }
            Optional<Listing> opt = this.listingRepo.getByUuid(listingUuid);
            if (opt.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            Listing l = opt.get();
            if (!l.getSellerUuid().equals(sellerUuid)) {
                boolean bl = false;
                return bl;
            }
            if (l.getStatus() != ListingStatus.ACTIVE) {
                boolean bl = false;
                return bl;
            }
            boolean ok = this.listingRepo.tryUpdateStatusIf(listingUuid, ListingStatus.ACTIVE, ListingStatus.CANCELLED);
            if (!ok) {
                boolean bl = false;
                return bl;
            }
            if (this.deliveryQueue != null) {
                this.deliveryQueue.enqueue(sellerUuid, l.getItemSerialized(), l.getUuid());
            }
            this.txLog.logExtended(UUID.randomUUID(), l.getUuid(), null, l.getSellerUuid(), l.getPrice(), "CANCEL", MarketplaceService.metaJson(Map.of("by", "seller")));
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (this.lockProvider != null) {
                    this.lockProvider.release(lockKey);
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int claimDeliveries(Player player, int max) {
        if (this.deliveryQueue == null) {
            return 0;
        }
        if (!Bukkit.isPrimaryThread()) {
            return 0;
        }
        String lockKey = "claim:" + String.valueOf(player.getUniqueId());
        try {
            long now = System.currentTimeMillis();
            Long last = this.claimThrottle.get(player.getUniqueId());
            if (last != null && now - last < 750L) {
                int n = 0;
                return n;
            }
            this.claimThrottle.put(player.getUniqueId(), now);
            if (this.lockProvider != null && !this.lockProvider.tryAcquire(lockKey, Duration.ofSeconds(10L))) {
                int n = 0;
                return n;
            }
            if (player.getInventory().firstEmpty() == -1) {
                int n = 0;
                return n;
            }
            List<DeliveryQueue.Record> rows = this.deliveryQueue.fetch(player.getUniqueId(), Math.max(1, max));
            int delivered = 0;
            for (DeliveryQueue.Record r : rows) {
                ItemStack stack;
                block36: {
                    try {
                        stack = ItemSerializer.fromBase64(r.itemBase64);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    try {
                        ItemMeta meta = stack.getItemMeta();
                        if (meta == null) break block36;
                        NamespacedKey tokenKey = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "gmarket_item_id");
                        try {
                            String tokenVal = (String)meta.getPersistentDataContainer().get(tokenKey, PersistentDataType.STRING);
                            if (tokenVal != null && r.listingUuid != null && !tokenVal.equals(r.listingUuid.toString())) {
                                try {
                                    this.txLog.logExtended(UUID.randomUUID(), r.listingUuid, player.getUniqueId(), null, BigDecimal.ZERO, "CLAIM_TOKEN_MISMATCH", MarketplaceService.metaJson(Map.of("token", tokenVal)));
                                }
                                catch (SQLException sQLException) {}
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        meta.getPersistentDataContainer().remove(tokenKey);
                        stack.setItemMeta(meta);
                    }
                    catch (Throwable meta) {
                        // empty catch block
                    }
                }
                PlayerInventory inv = player.getInventory();
                HashMap leftover = inv.addItem(new ItemStack[]{stack});
                if (!leftover.isEmpty()) break;
                this.deliveryQueue.deleteById(r.id);
                ++delivered;
            }
            int n = delivered;
            return n;
        }
        catch (SQLException e) {
            int n = 0;
            return n;
        }
        finally {
            try {
                if (this.lockProvider != null) {
                    this.lockProvider.release(lockKey);
                }
            }
            catch (SQLException sQLException) {}
        }
    }
}

