/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;

public class JsonStore {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)Instant.class), new InstantMillisAdapter()).setPrettyPrinting().create();

    public static <T> T read(Path path, Class<T> type, T defaultValue) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return defaultValue;
        }
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            T obj = GSON.fromJson((Reader)reader, type);
            T t = obj != null ? obj : defaultValue;
            return t;
        }
    }

    public static <T> void writeAtomic(Path path, T data) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Path tmp = new File(path.toFile().getParentFile(), path.getFileName().toString() + ".tmp").toPath();
        try (BufferedWriter writer = Files.newBufferedWriter(tmp, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson(data, (Appendable)writer);
        }
        Files.move(tmp, path, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
    }

    static class InstantMillisAdapter
    extends TypeAdapter<Instant> {
        InstantMillisAdapter() {
        }

        @Override
        public void write(JsonWriter out, Instant value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(value.toEpochMilli());
            }
        }

        @Override
        public Instant read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            if (token == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            switch (token) {
                case NUMBER: {
                    return Instant.ofEpochMilli(in.nextLong());
                }
                case STRING: {
                    String s = in.nextString();
                    try {
                        return Instant.ofEpochMilli(Long.parseLong(s));
                    }
                    catch (NumberFormatException e) {
                        return Instant.parse(s);
                    }
                }
            }
            throw new IOException("Unexpected token for Instant: " + String.valueOf((Object)token));
        }
    }
}

