/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.storage.file;

import java.io.IOException;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.texboobcat.globalMarketplace.repo.DeliveryQueue;
import org.texboobcat.globalMarketplace.storage.JsonStore;

public class FileDeliveryQueue
implements DeliveryQueue {
    private final Path file;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private long nextId;
    private List<DeliveryQueue.Record> records;

    public FileDeliveryQueue(Path file) throws IOException {
        this.file = file;
        Snapshot snap = JsonStore.read(file, Snapshot.class, new Snapshot());
        this.records = snap.records != null ? snap.records : new ArrayList<DeliveryQueue.Record>();
        this.nextId = Math.max(1L, snap.nextId);
        if (this.nextId == 1L && !this.records.isEmpty()) {
            this.nextId = this.records.stream().mapToLong(r -> r.id).max().orElse(0L) + 1L;
        }
    }

    private void persist() throws SQLException {
        this.lock.writeLock().lock();
        try {
            Snapshot snap = new Snapshot();
            snap.records = this.records;
            snap.nextId = this.nextId;
            try {
                JsonStore.writeAtomic(this.file, snap);
            }
            catch (IOException e) {
                throw new SQLException("Failed to write deliveries file", e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(UUID playerUuid, String itemBase64, UUID listingUuid) throws SQLException {
        this.lock.writeLock().lock();
        try {
            DeliveryQueue.Record r = new DeliveryQueue.Record();
            r.id = this.nextId++;
            r.playerUuid = playerUuid;
            r.itemBase64 = itemBase64;
            r.listingUuid = listingUuid;
            this.records.add(r);
            this.persist();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DeliveryQueue.Record> fetch(UUID playerUuid, int limit) throws SQLException {
        this.lock.readLock().lock();
        try {
            List<DeliveryQueue.Record> list = this.records.stream().filter(r -> r.playerUuid.equals(playerUuid)).sorted(Comparator.comparingLong(r -> r.id)).limit(Math.max(1, limit)).map(this::copy).collect(Collectors.toList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void deleteById(long id) throws SQLException {
        this.lock.writeLock().lock();
        try {
            this.records.removeIf(r -> r.id == id);
            this.persist();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private DeliveryQueue.Record copy(DeliveryQueue.Record r) {
        DeliveryQueue.Record c = new DeliveryQueue.Record();
        c.id = r.id;
        c.playerUuid = r.playerUuid;
        c.itemBase64 = r.itemBase64;
        c.listingUuid = r.listingUuid;
        return c;
    }

    private static class Snapshot {
        List<DeliveryQueue.Record> records = new ArrayList<DeliveryQueue.Record>();
        long nextId = 1L;

        private Snapshot() {
        }
    }
}

