/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.storage.file;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.texboobcat.globalMarketplace.repo.TransactionLog;
import org.texboobcat.globalMarketplace.storage.JsonStore;

public class FileTransactionLog
implements TransactionLog {
    private final Path file;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private List<Entry> entries;

    public FileTransactionLog(Path file) throws IOException {
        this.file = file;
        Snapshot snap = JsonStore.read(file, Snapshot.class, new Snapshot());
        this.entries = snap.entries != null ? snap.entries : new ArrayList<Entry>();
    }

    private void persist() throws SQLException {
        this.lock.writeLock().lock();
        try {
            Snapshot snap = new Snapshot();
            snap.entries = this.entries;
            try {
                JsonStore.writeAtomic(this.file, snap);
            }
            catch (IOException e) {
                throw new SQLException("Failed to write transactions file", e);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(UUID txUuid, UUID listingUuid, UUID buyerUuid, UUID sellerUuid, BigDecimal amount, String type) throws SQLException {
        this.lock.writeLock().lock();
        try {
            Entry e = new Entry();
            e.txUuid = txUuid;
            e.listingUuid = listingUuid;
            e.buyerUuid = buyerUuid;
            e.sellerUuid = sellerUuid;
            e.amount = amount;
            e.type = type;
            this.entries.add(e);
            this.persist();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logExtended(UUID txUuid, UUID listingUuid, UUID buyerUuid, UUID sellerUuid, BigDecimal amount, String type, String metaJson) throws SQLException {
        this.lock.writeLock().lock();
        try {
            Entry e = new Entry();
            e.txUuid = txUuid;
            e.listingUuid = listingUuid;
            e.buyerUuid = buyerUuid;
            e.sellerUuid = sellerUuid;
            e.amount = amount;
            e.type = type;
            e.meta = metaJson;
            this.entries.add(e);
            this.persist();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionLog.SaleRecord latestSaleForListing(UUID listingUuid) throws SQLException {
        this.lock.readLock().lock();
        try {
            for (int i = this.entries.size() - 1; i >= 0; --i) {
                Entry e = this.entries.get(i);
                if (!e.listingUuid.equals(listingUuid) || !"BUY".equals(e.type) && !"DIRECT_BUY".equals(e.type) && !"AUCTION_SELL".equals(e.type)) continue;
                TransactionLog.SaleRecord s = new TransactionLog.SaleRecord();
                s.txUuid = e.txUuid;
                s.listingUuid = e.listingUuid;
                s.buyerUuid = e.buyerUuid;
                s.sellerUuid = e.sellerUuid;
                s.amount = e.amount;
                s.type = e.type;
                TransactionLog.SaleRecord saleRecord = s;
                return saleRecord;
            }
            TransactionLog.SaleRecord saleRecord = null;
            return saleRecord;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private static class Snapshot {
        List<Entry> entries = new ArrayList<Entry>();

        private Snapshot() {
        }
    }

    private static class Entry {
        UUID txUuid;
        UUID listingUuid;
        UUID buyerUuid;
        UUID sellerUuid;
        BigDecimal amount;
        String type;
        String meta;

        private Entry() {
        }
    }
}

