/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.sync;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

public class RedisSync {
    private final String host;
    private final int port;
    private final String password;
    private final String channel;
    private ExecutorService executor;
    private Future<?> subscriberTask;
    private volatile boolean running;

    public RedisSync(String host, int port, String password, String channel) {
        this.host = host;
        this.port = port;
        this.password = password;
        this.channel = channel;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "GM-Redis-Subscriber"));
        this.subscriberTask = this.executor.submit(this::runSubscriber);
    }

    public void stop() {
        this.running = false;
        if (this.subscriberTask != null) {
            this.subscriberTask.cancel(true);
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void publish(String message) {
        try (Jedis jedis = new Jedis(this.host, this.port);){
            if (this.password != null && !this.password.isEmpty()) {
                jedis.auth(this.password);
            }
            jedis.publish(this.channel, message);
        }
        catch (Exception e) {
            GlobalMarketplacePlugin.getInstance().getLogger().warning("Redis publish failed: " + e.getMessage());
        }
    }

    private void runSubscriber() {
        try (Jedis jedis = new Jedis(this.host, this.port);){
            if (this.password != null && !this.password.isEmpty()) {
                jedis.auth(this.password);
            }
            JedisPubSub sub = new JedisPubSub(){

                @Override
                public void onMessage(String ch, String message) {
                    if (!RedisSync.this.channel.equals(ch)) {
                        return;
                    }
                    Bukkit.getScheduler().runTask((Plugin)GlobalMarketplacePlugin.getInstance(), () -> GlobalMarketplacePlugin.getInstance().getLogger().fine("Redis sync msg: " + message));
                }
            };
            jedis.subscribe(sub, this.channel);
        }
        catch (Exception e) {
            GlobalMarketplacePlugin.getInstance().getLogger().warning("Redis subscribe error: " + e.getMessage());
        }
    }
}

