/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.globalMarketplace.ui;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.texboobcat.globalMarketplace.GlobalMarketplacePlugin;
import org.texboobcat.globalMarketplace.model.TradeSession;
import org.texboobcat.globalMarketplace.service.TradeService;

public class TradeMenu {
    public static final String TITLE_PREFIX = "Trade: ";
    private static final int ROWS = 6;

    public void open(Player player, UUID sessionId) {
        int i;
        TradeService tradeService = GlobalMarketplacePlugin.getInstance().getTradeService();
        TradeSession session = tradeService.getTradeSession(sessionId);
        if (session == null) {
            player.sendMessage("\u00a7cTrade session not found.");
            return;
        }
        Player otherPlayer = Bukkit.getPlayer((UUID)session.getOtherPlayer(player.getUniqueId()));
        String otherPlayerName = otherPlayer != null ? otherPlayer.getName() : "Unknown";
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)(TITLE_PREFIX + otherPlayerName));
        ItemStack filler = this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ");
        for (int i2 = 0; i2 < inv.getSize(); ++i2) {
            inv.setItem(i2, filler);
        }
        ItemStack divider = this.createItem(Material.BLACK_STAINED_GLASS_PANE, "\u00a78Divider");
        for (int row = 0; row < 4; ++row) {
            inv.setItem(row * 9 + 4, divider);
        }
        boolean isPlayer1 = session.isPlayer1(player.getUniqueId());
        List<ItemStack> playerItems = isPlayer1 ? session.getPlayer1Items() : session.getPlayer2Items();
        BigDecimal playerMoney = isPlayer1 ? session.getPlayer1Money() : session.getPlayer2Money();
        boolean playerReady = isPlayer1 ? session.isPlayer1Ready() : session.isPlayer2Ready();
        boolean playerConfirmed = isPlayer1 ? session.isPlayer1Confirmed() : session.isPlayer2Confirmed();
        List<ItemStack> otherItems = isPlayer1 ? session.getPlayer2Items() : session.getPlayer1Items();
        BigDecimal otherMoney = isPlayer1 ? session.getPlayer2Money() : session.getPlayer1Money();
        boolean otherReady = isPlayer1 ? session.isPlayer2Ready() : session.isPlayer1Ready();
        boolean otherConfirmed = isPlayer1 ? session.isPlayer2Confirmed() : session.isPlayer1Confirmed();
        int[] leftSlots = new int[]{0, 1, 2, 3, 9, 10, 11, 12, 18, 19, 20, 21, 27, 28, 29, 30};
        int[] rightSlots = new int[]{5, 6, 7, 8, 14, 15, 16, 17, 23, 24, 25, 26, 32, 33, 34, 35};
        int[] playerSlots = isPlayer1 ? leftSlots : rightSlots;
        int[] otherSlotsArr = isPlayer1 ? rightSlots : leftSlots;
        for (int s : playerSlots) {
            inv.setItem(s, null);
        }
        for (i = 0; i < Math.min(playerItems.size(), playerSlots.length); ++i) {
            ItemStack item = playerItems.get(i).clone();
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
                lore.add("\u00a77Click to remove");
                meta.setLore(lore);
                NamespacedKey key = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "trade_action");
                meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)("remove_item:" + i));
                item.setItemMeta(meta);
            }
            inv.setItem(playerSlots[i], item);
        }
        for (i = 0; i < Math.min(otherItems.size(), otherSlotsArr.length); ++i) {
            ItemStack item = otherItems.get(i).clone();
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
                lore.add("\u00a77" + otherPlayerName + "'s item");
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
            inv.setItem(otherSlotsArr[i], item);
        }
        ItemStack playerMoneyItem = this.createMoneyItem(playerMoney, true, "Your Money");
        NamespacedKey moneyKey = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "trade_action");
        ItemMeta playerMoneyMeta = playerMoneyItem.getItemMeta();
        if (playerMoneyMeta != null) {
            TradeService ts = GlobalMarketplacePlugin.getInstance().getTradeService();
            Optional<BigDecimal> balOpt = ts.getBalance(player.getUniqueId());
            List lore = playerMoneyMeta.hasLore() ? playerMoneyMeta.getLore() : new ArrayList();
            String balStr = balOpt.map(b -> b.setScale(2, RoundingMode.DOWN).toPlainString()).orElse("unknown");
            lore.add("\u00a77Balance: \u00a7a$" + balStr);
            playerMoneyMeta.setLore(lore);
            playerMoneyMeta.getPersistentDataContainer().set(moneyKey, PersistentDataType.STRING, (Object)"set_money");
            playerMoneyItem.setItemMeta(playerMoneyMeta);
        }
        ItemStack otherMoneyItem = this.createMoneyItem(otherMoney, false, otherPlayerName + "'s Money");
        int playerMoneySlot = isPlayer1 ? 36 : 44;
        int otherMoneySlot = isPlayer1 ? 44 : 36;
        inv.setItem(playerMoneySlot, playerMoneyItem);
        inv.setItem(otherMoneySlot, otherMoneyItem);
        ItemStack info = this.createItem(Material.CHEST, "\u00a7aAdd Items");
        ItemMeta infoMeta = info.getItemMeta();
        if (infoMeta != null) {
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a77Drag items from your inventory");
            lore.add("\u00a77into the green slots on your side.");
            infoMeta.setLore(lore);
            info.setItemMeta(infoMeta);
        }
        inv.setItem(isPlayer1 ? 37 : 43, info);
        Material readyMaterial = playerReady ? Material.LIME_DYE : Material.GRAY_DYE;
        String readyText = playerReady ? "\u00a7aReady!" : "\u00a77Not Ready";
        String readyAction = playerReady ? "unready" : "ready";
        ItemStack readyButton = this.createActionItem(readyMaterial, readyText, "\u00a77Click to toggle ready status", readyAction);
        inv.setItem(isPlayer1 ? 38 : 42, readyButton);
        if (session.bothPlayersReady()) {
            Material confirmMaterial = playerConfirmed ? Material.EMERALD : Material.DIAMOND;
            String confirmText = playerConfirmed ? "\u00a7aConfirmed!" : "\u00a7bConfirm Trade";
            String confirmAction = playerConfirmed ? "unconfirm" : "confirm";
            ItemStack confirmButton = this.createActionItem(confirmMaterial, confirmText, "\u00a77Click to confirm the trade", confirmAction);
            inv.setItem(isPlayer1 ? 39 : 41, confirmButton);
        } else {
            ItemStack waitingConfirm = this.createItem(Material.BARRIER, "\u00a7cWaiting for Ready");
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a77Both players must be ready");
            lore.add("\u00a77before confirming the trade");
            ItemMeta meta = waitingConfirm.getItemMeta();
            if (meta != null) {
                meta.setLore(lore);
                waitingConfirm.setItemMeta(meta);
            }
            inv.setItem(isPlayer1 ? 39 : 41, waitingConfirm);
        }
        Material otherReadyMaterial = otherReady ? Material.LIME_DYE : Material.GRAY_DYE;
        String otherReadyText = otherReady ? "\u00a7a" + otherPlayerName + " Ready!" : "\u00a77" + otherPlayerName + " Not Ready";
        ItemStack otherReadyButton = this.createItem(otherReadyMaterial, otherReadyText);
        inv.setItem(isPlayer1 ? 41 : 39, otherReadyButton);
        if (session.bothPlayersReady()) {
            Material otherConfirmMaterial = otherConfirmed ? Material.EMERALD : Material.DIAMOND;
            String otherConfirmText = otherConfirmed ? "\u00a7a" + otherPlayerName + " Confirmed!" : "\u00a77" + otherPlayerName + " Not Confirmed";
            ItemStack otherConfirmButton = this.createItem(otherConfirmMaterial, otherConfirmText);
            inv.setItem(isPlayer1 ? 42 : 38, otherConfirmButton);
        }
        ItemStack cancelButton = this.createActionItem(Material.REDSTONE, "\u00a7cCancel Trade", "\u00a77Click to cancel the trade", "cancel");
        inv.setItem(isPlayer1 ? 45 : 53, cancelButton);
        ItemStack statusItem = this.createStatusItem(session, otherPlayerName);
        inv.setItem(49, statusItem);
        player.openInventory(inv);
    }

    private ItemStack createItem(Material material, String name) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createActionItem(Material material, String name, String ... loreAndAction) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            ArrayList<String> lore = new ArrayList<String>();
            String action = "";
            for (int i = 0; i < loreAndAction.length; ++i) {
                if (i == loreAndAction.length - 1) {
                    action = loreAndAction[i];
                    continue;
                }
                lore.add(loreAndAction[i]);
            }
            if (!lore.isEmpty()) {
                meta.setLore(lore);
            }
            if (!action.isEmpty()) {
                NamespacedKey key = new NamespacedKey((Plugin)GlobalMarketplacePlugin.getInstance(), "trade_action");
                meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)action);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createMoneyItem(BigDecimal amount, boolean editable, String title) {
        ItemStack item = new ItemStack(Material.GOLD_NUGGET);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a76" + title);
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77Amount: \u00a7a$" + String.valueOf(amount));
            if (editable) {
                lore.add("\u00a77Click to change amount");
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createStatusItem(TradeSession session, String otherPlayerName) {
        ItemStack item = new ItemStack(Material.PAPER);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7eTrade Status");
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77Trading with: \u00a7f" + otherPlayerName);
            lore.add("");
            if (session.bothPlayersReady()) {
                if (session.bothPlayersConfirmed()) {
                    lore.add("\u00a7aExecuting trade...");
                } else {
                    lore.add("\u00a7eWaiting for confirmations");
                }
            } else {
                lore.add("\u00a77Waiting for players to ready up");
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }
}

