/*
 * Decompiled with CFR 0.152.
 */
package org.ivangeevo.animageddon.mixin.entity;

import btwr.btwr_sl.tag.BTWRConventionalTags;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1391;
import net.minecraft.class_1428;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3417;
import org.ivangeevo.animageddon.item.ModItems;
import org.ivangeevo.animageddon.util.ServerTimeHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1428.class})
public abstract class ChickenEntityMixin
extends class_1429 {
    @Unique
    private boolean hasBeenFed = false;
    @Unique
    private long lastFedTime = -1L;
    @Unique
    private long lastWorldTime = -1L;
    @Unique
    private long timeToLayEgg = 0L;
    @Shadow
    public int field_6739;

    protected ChickenEntityMixin(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.lastWorldTime = world.method_8532();
    }

    @Inject(method={"isBreedingItem"}, at={@At(value="RETURN")}, cancellable=true)
    private void setBreedingItem(class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)stack.method_31574(ModItems.CHICKEN_FEED));
    }

    private void modifyTemptGoal(CallbackInfo ci) {
        class_1391 customTemptGoal = new class_1391((class_1314)this, 1.0, stack -> stack.method_31573(BTWRConventionalTags.Items.CHICKEN_TEMPT_ITEMS), true);
        this.field_6201.method_6277(3, (class_1352)customTemptGoal);
    }

    private void addBreedingGoal(CallbackInfo ci) {
        class_1391 customBreedingGoal = new class_1391((class_1314)this, 1.25, stack -> stack.method_31574(ModItems.CHICKEN_FEED), false);
        this.field_6201.method_6277(3, (class_1352)customBreedingGoal);
    }

    @Inject(method={"tickMovement"}, at={@At(value="TAIL")})
    private void onTickMovement(CallbackInfo ci) {
        this.field_6739 = Integer.MAX_VALUE;
        if (!this.method_6109() && this.timeToLayEgg > 0L && this.validateTimeToLayEgg(this.method_37908()) && this.method_37908().method_8532() > this.timeToLayEgg) {
            this.method_5783(class_3417.field_14863, 1.0f, this.method_6017());
            this.method_5783(class_3417.field_14601, 1.0f, this.method_6017());
            this.method_5706((class_1935)class_1802.field_8803);
            this.timeToLayEgg = 0L;
        }
    }

    protected void method_6475(class_1657 player, class_1268 hand, class_1799 stack) {
        if (stack.method_31574(ModItems.CHICKEN_FEED) && !this.method_6109()) {
            long currentTime = ServerTimeHelper.getOverworldTimeOfDayServerOnly();
            this.timeToLayEgg = ((currentTime + 12000L) / 24000L + 1L) * 24000L;
            this.timeToLayEgg += (long)(-1450 + this.field_5974.method_43048(600));
            this.method_5783(class_3417.field_14601, this.method_6107(), this.field_5974.method_43057() * 0.2f + 1.5f);
        }
        super.method_6475(player, hand, stack);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void onWriteCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10544("TimeToLayEgg", this.timeToLayEgg);
        nbt.method_10544("LastFedTime", this.lastFedTime);
        nbt.method_10556("HasBeenFed", this.getHasBeenFed());
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void onReadCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10545("TimeToLayEgg")) {
            this.timeToLayEgg = nbt.method_10537("TimeToLayEgg");
            this.lastFedTime = nbt.method_10537("LastFedTime");
            this.setHasBeenFed(nbt.method_10577("HasBeenFed"));
        } else {
            this.timeToLayEgg = 0L;
            this.lastFedTime = -1L;
            this.setHasBeenFed(false);
        }
    }

    @Unique
    private boolean validateTimeToLayEgg(class_1937 world) {
        long currentTime = world.method_8510();
        long deltaTime = this.timeToLayEgg - currentTime;
        if (deltaTime > 48000L) {
            this.timeToLayEgg = 0L;
            return false;
        }
        return true;
    }

    public boolean getHasBeenFed() {
        return this.hasBeenFed;
    }

    public void setHasBeenFed(boolean value) {
        this.hasBeenFed = value;
    }
}

