/*
 * Decompiled with CFR 0.152.
 */
package org.ivangeevo.animageddon.data.attachments.hunger;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.ivangeevo.animageddon.data.attachments.hunger.AnimalHungerConstants;
import org.ivangeevo.animageddon.data.interfaces.AnimalHungerData;

public class AnimalHungerAttachedData
implements AnimalHungerData,
AnimalHungerConstants {
    private int hungerLevel;
    private final int foodValueMultiplier;
    private int grazeDuration;
    private int hungerCountdown;
    public static Codec<AnimalHungerAttachedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("hunger_level").forGetter(AnimalHungerAttachedData::getHungerLevel), (App)Codec.INT.fieldOf("food_value_multiplier").forGetter(AnimalHungerAttachedData::getFoodValueMultiplier), (App)Codec.INT.fieldOf("graze_duration").forGetter(AnimalHungerAttachedData::getGrazeDuration)).apply((Applicative)instance, AnimalHungerAttachedData::new));
    public static class_9139<ByteBuf, AnimalHungerAttachedData> PACKET_CODEC = class_9135.method_56368(CODEC);

    public AnimalHungerAttachedData(int foodValueMultiplier, int grazeDuration) {
        this.hungerLevel = 0;
        this.foodValueMultiplier = foodValueMultiplier;
        this.grazeDuration = grazeDuration;
    }

    public AnimalHungerAttachedData(int hungerLevel, int foodValueMultiplier, int grazeDuration) {
        this.hungerLevel = hungerLevel;
        this.foodValueMultiplier = foodValueMultiplier;
        this.grazeDuration = grazeDuration;
    }

    public static AnimalHungerAttachedData forDefault() {
        return new AnimalHungerAttachedData(2, 40);
    }

    public int getHungerLevel() {
        return this.hungerLevel;
    }

    public void setHungerLevel(int hungerLevel) {
        this.hungerLevel = hungerLevel;
    }

    public int getHungerCountdown() {
        return this.hungerCountdown;
    }

    public void setHungerCountdown(int value) {
        this.hungerCountdown = value;
    }

    public int getGrazeDuration() {
        return this.grazeDuration;
    }

    public void setGrazeDuration(int value) {
        this.grazeDuration = value;
    }

    public void resetHungerCountdown() {
        this.hungerCountdown = 24000;
    }

    @Override
    public boolean isFullyFed() {
        return this.getHungerLevel() == 0;
    }

    @Override
    public boolean isFamished() {
        return this.getHungerLevel() == 1;
    }

    @Override
    public boolean isStarving() {
        return this.getHungerLevel() >= 2;
    }

    public void onBecomeFamished() {
        this.hungerLevel = 1;
    }

    public void onBecomeStarving() {
        this.hungerLevel = 2;
    }

    @Override
    public int getGrazeHungerGain() {
        return 200 * this.getFoodValueMultiplier();
    }

    @Override
    public int getFoodValueMultiplier() {
        return this.foodValueMultiplier;
    }
}

